/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb;

public class PacketType {
    public static final int CreateDirectory = 0;
    public static final int DeleteDirectory = 1;
    public static final int OpenFile = 2;
    public static final int CreateFile = 3;
    public static final int CloseFile = 4;
    public static final int FlushFile = 5;
    public static final int DeleteFile = 6;
    public static final int RenameFile = 7;
    public static final int GetFileAttributes = 8;
    public static final int SetFileAttributes = 9;
    public static final int ReadFile = 10;
    public static final int WriteFile = 11;
    public static final int LockFile = 12;
    public static final int UnLockFile = 13;
    public static final int CreateTemporary = 14;
    public static final int CreateNew = 15;
    public static final int CheckDirectory = 16;
    public static final int ProcessExit = 17;
    public static final int SeekFile = 18;
    public static final int LockAndRead = 19;
    public static final int WriteAndUnlock = 20;
    public static final int ReadRaw = 26;
    public static final int ReadMpx = 27;
    public static final int ReadMpxSecondary = 28;
    public static final int WriteRaw = 29;
    public static final int WriteMpx = 30;
    public static final int WriteMpxSecondary = 31;
    public static final int WriteComplete = 32;
    public static final int SetInformation2 = 34;
    public static final int QueryInformation2 = 35;
    public static final int LockingAndX = 36;
    public static final int Transaction = 37;
    public static final int TransactionSecond = 38;
    public static final int IOCtl = 39;
    public static final int IOCtlSecondary = 40;
    public static final int Copy = 41;
    public static final int Move = 42;
    public static final int Echo = 43;
    public static final int WriteAndClose = 44;
    public static final int OpenAndX = 45;
    public static final int ReadAndX = 46;
    public static final int WriteAndX = 47;
    public static final int CloseAndTreeDisc = 49;
    public static final int Transaction2 = 50;
    public static final int Transaction2Second = 51;
    public static final int FindClose2 = 52;
    public static final int FindNotifyClose = 53;
    public static final int TreeConnect = 112;
    public static final int TreeDisconnect = 113;
    public static final int Negotiate = 114;
    public static final int SessionSetupAndX = 115;
    public static final int LogoffAndX = 116;
    public static final int TreeConnectAndX = 117;
    public static final int DiskInformation = 128;
    public static final int Search = 129;
    public static final int Find = 130;
    public static final int FindUnique = 131;
    public static final int NTTransact = 160;
    public static final int NTTransactSecond = 161;
    public static final int NTCreateAndX = 162;
    public static final int NTCancel = 164;
    public static final int OpenPrintFile = 192;
    public static final int WritePrintFile = 193;
    public static final int ClosePrintFile = 194;
    public static final int GetPrintQueue = 195;
    public static final int SendMessage = 208;
    public static final int SendBroadcast = 209;
    public static final int SendForward = 210;
    public static final int CancelForward = 211;
    public static final int GetMachineName = 212;
    public static final int SendMultiStart = 213;
    public static final int SendMultiEnd = 214;
    public static final int SendMultiText = 215;
    public static final int Trans2Open = 0;
    public static final int Trans2FindFirst = 1;
    public static final int Trans2FindNext = 2;
    public static final int Trans2QueryFileSys = 3;
    public static final int Trans2QueryPath = 5;
    public static final int Trans2SetPath = 6;
    public static final int Trans2QueryFile = 7;
    public static final int Trans2SetFile = 8;
    public static final int Trans2CreateDir = 13;
    public static final int Trans2SessSetup = 14;
    public static final int RAPShareEnum = 0;
    public static final int RAPShareGetInfo = 1;
    public static final int RAPSessionEnum = 6;
    public static final int RAPServerGetInfo = 13;
    public static final int NetServerDiskEnum = 15;
    public static final int NetGroupEnum = 47;
    public static final int RAPUserGetInfo = 56;
    public static final int RAPWkstaGetInfo = 63;
    public static final int RAPServerEnum = 94;
    public static final int RAPServerEnum2 = 104;
    public static final int RAPWkstaUserLogon = 132;
    public static final int RAPWkstaUserLogoff = 133;
    public static final int RAPChangePassword = 214;
    public static final int NetServiceEnum = 39;
    public static final int NetServiceInstall = 40;
    public static final int NetServiceControl = 41;
    public static final int NetGroupGetUsers = 52;
    public static final int NetUserEnum = 53;
    public static final int NetUserGetGroups = 59;
    public static final int NetPrintQEnum = 69;
    public static final int NetPrintQGetInfo = 70;
    public static final int NetPrintQSetInfo = 71;
    public static final int NetPrintQAdd = 72;
    public static final int NetPrintQDel = 73;
    public static final int NetPrintQPause = 74;
    public static final int NetPrintQContinue = 75;
    public static final int NetPrintJobEnum = 76;
    public static final int NetPrintJobGetInfo = 77;
    public static final int NetPrintJobSetInfo = 78;
    public static final int NetPrintJobDelete = 81;
    public static final int NetPrintJobPause = 82;
    public static final int NetPrintJobContinue = 83;
    public static final int NetPrintDestEnum = 84;
    public static final int NetPrintDestGetInfo = 85;
    public static final int NetPrintDestControl = 86;
    public static final int CallNamedPipe = 84;
    public static final int WaitNamedPipe = 83;
    public static final int PeekNmPipe = 35;
    public static final int QNmPHandState = 33;
    public static final int SetNmPHandState = 1;
    public static final int QNmPipeInfo = 34;
    public static final int TransactNmPipe = 38;
    public static final int RawReadNmPipe = 17;
    public static final int RawWriteNmPipe = 49;
    public static final int NetBIOSEnum = 92;
    public static final int NTTransCreate = 1;
    public static final int NTTransIOCtl = 2;
    public static final int NTTransSetSecurityDesc = 3;
    public static final int NTTransNotifyChange = 4;
    public static final int NTTransRename = 5;
    public static final int NTTransQuerySecurityDesc = 6;
    public static final int NTTransGetUserQuota = 7;
    public static final int NTTransSetUserQuota = 8;
    public static final int NoChainedCommand = 255;
    private static String[] _cmdNames1 = new String[]{"CreateDirectory", "DeleteDirectory", "OpenFile", "CreateFile", "CloseFile", "FlushFile", "DeleteFile", "RenameFile", "GetFileAttributes", "SetFileAttributes", "ReadFile", "WriteFile", "LockFile", "UnLockFile", "CreateTemporary", "CreateNew", "CheckDirectory", "ProcessExit", "SeekFile", "LockAndRead", "WriteAndUnlock", null, null, null, null, null, "ReadRaw", "ReadMpx", "ReadMpxSecondary", "WriteRaw", "WriteMpx", null, "WriteComplete", null, "SetInformation2", "QueryInformation2", "LockingAndX", "Transaction", "TransactionSecond", "IOCtl", "IOCtlSecondary", "Copy", "Move", "Echo", "WriteAndClose", "OpenAndX", "ReadAndX", "WriteAndX", null, "CloseAndTreeDisconnect", "Transaction2", "Transaction2Secondary", "FindClose2", "FindNotifyClose"};
    private static String[] _cmdNames2 = new String[]{"TreeConnect", "TreeDisconnect", "Negotiate", "SessionSetupAndX", "LogoffAndX", "TreeConnectAndX"};
    private static String[] _cmdNames3 = new String[]{"DiskInformation", "Search", "Find", "FindUnique"};
    private static String[] _cmdNames4 = new String[]{"NTTransact", "NTTransactSecondary", "NTCreateAndX", null, "NTCancel"};
    private static String[] _cmdNames5 = new String[]{"OpenPrintFile", "WritePrintFile", "ClosePrintFile", "GetPrintQueue"};
    private static String[] _cmdNames6 = new String[]{"SendMessage", "SendBroadcast", "SendForward", "CancelForward", "GetMachineName", "SendMultiStart", "SendMultiEnd", "SendMultiText"};
    private static String[] _transNames = new String[]{"Trans2Open", "Trans2FindFirst", "Trans2FindNext", "Trans2QueryFileSys", "Trans2QueryPath", "Trans2SetPath", "Trans2QueryFile", "Trans2SetFile", "Trans2CreateDirectory", "Trans2SessionSetup"};
    private static String[] _ntTranNames = new String[]{"", "NTTransCreate", "NTTransIOCtl", "NTTransSetSecurityDesc", "NTTransNotifyChange", "NTTransRename", "NTTransQuerySecurityDesc", "NTTransGetUserQuota", "NTTransSetUserQuota"};

    public static final String getCommandName(int cmd) {
        String cmdName = "";
        if (cmd >= 0 && cmd < _cmdNames1.length) {
            cmdName = _cmdNames1[cmd];
        } else {
            switch (cmd & 0xF0) {
                case 112: {
                    cmdName = _cmdNames2[cmd - 112];
                    break;
                }
                case 128: {
                    cmdName = _cmdNames3[cmd - 128];
                    break;
                }
                case 160: {
                    cmdName = _cmdNames4[cmd - 160];
                    break;
                }
                case 192: {
                    cmdName = _cmdNames5[cmd - 192];
                    break;
                }
                case 208: {
                    cmdName = _cmdNames6[cmd - 208];
                    break;
                }
                default: {
                    cmdName = "0x" + Integer.toHexString(cmd);
                }
            }
        }
        return cmdName;
    }

    public static final String getTransactionName(int opcode) {
        String opcodeName = "";
        if (opcode >= 0 && opcode < _transNames.length) {
            opcodeName = _transNames[opcode];
        }
        return opcodeName;
    }

    public static final String getNTTransationName(int opcode) {
        String opcodeName = "";
        if (opcode >= 0 && opcode < _ntTranNames.length) {
            opcodeName = _ntTranNames[opcode];
        }
        return opcodeName;
    }
}

