/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SocketSessionHandler;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.mailslot.TcpipNetBIOSHostAnnouncer;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.NetBIOSPacketHandler;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class NetBIOSSessionSocketHandler
extends SocketSessionHandler {
    private static final ThreadGroup NetBIOSGroup = new ThreadGroup("NetBIOSSessions");

    public NetBIOSSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("NetBIOS", "SMB", srv, bindAddr, port);
        this.setDebug(debug);
    }

    protected void acceptConnection(Socket sock) {
        block2: {
            try {
                sock.setSoTimeout(this.getSocketTimeout());
                SMBServer smbServer = (SMBServer)this.getServer();
                NetBIOSPacketHandler pktHandler = new NetBIOSPacketHandler(sock, smbServer.getPacketPool());
                SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                Thread srvThread = new Thread(NetBIOSGroup, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_N" + srvSess.getSessionId() + "_" + sock.getInetAddress().getHostAddress());
                srvThread.start();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block2;
                Debug.println("[SMB] NetBIOS Failed to create session, " + ex.toString());
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        CIFSConfigSection cifsConfig = (CIFSConfigSection)config.getConfigSection("CIFS");
        NetBIOSSessionSocketHandler sessHandler = new NetBIOSSessionSocketHandler(server, cifsConfig.getSessionPort(), cifsConfig.getSMBBindAddress(), sockDbg);
        sessHandler.setSocketTimeout(cifsConfig.getSocketTimeout());
        sessHandler.initializeSessionHandler(server);
        Thread nbThread = new Thread(sessHandler);
        nbThread.setName("NetBIOS_Handler");
        nbThread.start();
        if (sockDbg) {
            Debug.println("[SMB] TCP NetBIOS session handler created");
        }
        if (cifsConfig.hasEnableAnnouncer()) {
            TcpipNetBIOSHostAnnouncer announcer = new TcpipNetBIOSHostAnnouncer();
            announcer.addHostName(cifsConfig.getServerName());
            announcer.setDomain(cifsConfig.getDomainName());
            announcer.setComment(cifsConfig.getComment());
            announcer.setBindAddress(cifsConfig.getSMBBindAddress());
            if (cifsConfig.getHostAnnouncerPort() != 0) {
                announcer.setPort(cifsConfig.getHostAnnouncerPort());
            }
            if (cifsConfig.hasAliasNames()) {
                announcer.addHostNames(cifsConfig.getAliasNames());
            }
            if (cifsConfig.getHostAnnounceInterval() > 0) {
                announcer.setInterval(cifsConfig.getHostAnnounceInterval());
            }
            try {
                announcer.setBroadcastAddress(cifsConfig.getBroadcastMask());
            }
            catch (Exception ex) {
                // empty catch block
            }
            announcer.setServerType(cifsConfig.getServerType());
            if (cifsConfig.hasHostAnnounceDebug()) {
                announcer.setDebug(true);
            }
            announcer.start();
            if (sockDbg) {
                Debug.println("[SMB] TCP NetBIOS host announcer created");
            }
        }
    }
}

