/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import java.net.Socket;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SocketPacketHandler;
import org.alfresco.jlan.util.DataPacker;

public class TcpipSMBPacketHandler
extends SocketPacketHandler {
    private byte[] m_headerBuf = new byte[4];

    public TcpipSMBPacketHandler(Socket sock, CIFSPacketPool packetPool) throws IOException {
        super(sock, 1, "TCP-SMB", "T", packetPool);
    }

    public SMBSrvPacket readPacket() throws IOException {
        int offset;
        int len = this.readBytes(this.m_headerBuf, 0, 4);
        if (len == -1) {
            throw new IOException("Connection closed (header read)");
        }
        if (len < 4) {
            throw new IOException("Invalid header, len=" + len);
        }
        int dlen = DataPacker.getShort(this.m_headerBuf, 2);
        if (this.m_headerBuf[1] != 0) {
            byte llen = this.m_headerBuf[1];
            dlen += llen << 16;
        }
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(dlen + 4);
        int totlen = offset = 4;
        try {
            while (dlen > 0) {
                len = this.readBytes(pkt.getBuffer(), offset, dlen);
                if (len == -1) {
                    throw new IOException("Connection closed (request read)");
                }
                totlen += len;
                dlen -= len;
                offset += len;
            }
        }
        catch (IOException ex) {
            this.getPacketPool().releasePacket(pkt);
            throw ex;
        }
        pkt.setReceivedLength(totlen);
        return pkt;
    }

    public void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        byte[] buf = pkt.getBuffer();
        DataPacker.putInt(len, buf, 0);
        int bufSiz = len + 4;
        this.writeBytes(buf, 0, bufSiz);
    }
}

