/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.server.SessionHandlerBase;
import org.alfresco.jlan.server.SessionHandlerInterface;
import org.alfresco.jlan.server.SessionHandlerList;
import org.alfresco.jlan.server.SocketSessionHandler;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.mailslot.HostAnnouncer;
import org.alfresco.jlan.smb.mailslot.TcpipNetBIOSHostAnnouncer;
import org.alfresco.jlan.smb.mailslot.win32.Win32NetBIOSHostAnnouncer;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.CifsConnectionsHandler;
import org.alfresco.jlan.smb.server.NetBIOSSessionSocketHandler;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.TcpipSMBSessionSocketHandler;
import org.alfresco.jlan.smb.server.win32.LanaListener;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSLanaMonitor;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSSessionSocketHandler;

public class ThreadedCifsConnectionsHandler
implements CifsConnectionsHandler {
    public static final long LANAPollingInterval = 5000L;
    private SessionHandlerList m_handlerList = new SessionHandlerList();
    private Vector<HostAnnouncer> m_hostAnnouncers = new Vector();
    private SMBServer m_server;
    private boolean m_debug;

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public void initializeHandler(SMBServer srv, CIFSConfigSection config) throws InvalidConfigurationException {
        SessionHandlerBase sessHandler;
        block37: {
            this.m_server = srv;
            if ((config.getSessionDebugFlags() & 0x400000) != 0) {
                this.m_debug = true;
            }
            if (config.hasNetBIOSSMB()) {
                sessHandler = new NetBIOSSessionSocketHandler(srv, config.getSessionPort(), config.getSMBBindAddress(), this.hasDebug());
                ((SocketSessionHandler)sessHandler).setSocketTimeout(config.getSocketTimeout());
                try {
                    ((SocketSessionHandler)sessHandler).initializeSessionHandler(srv);
                    this.m_handlerList.addHandler(sessHandler);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] TCP NetBIOS session handler created");
                    }
                    if (!config.hasEnableAnnouncer()) break block37;
                    TcpipNetBIOSHostAnnouncer announcer = new TcpipNetBIOSHostAnnouncer();
                    announcer.addHostName(config.getServerName());
                    announcer.setDomain(config.getDomainName());
                    announcer.setComment(config.getComment());
                    announcer.setBindAddress(config.getSMBBindAddress());
                    if (config.getHostAnnouncerPort() != 0) {
                        announcer.setPort(config.getHostAnnouncerPort());
                    }
                    if (config.hasAliasNames()) {
                        announcer.addHostNames(config.getAliasNames());
                    }
                    if (config.getHostAnnounceInterval() > 0) {
                        announcer.setInterval(config.getHostAnnounceInterval());
                    }
                    try {
                        announcer.setBroadcastAddress(config.getBroadcastMask());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    announcer.setServerType(config.getServerType());
                    if (config.hasHostAnnounceDebug()) {
                        announcer.setDebug(true);
                    }
                    this.m_hostAnnouncers.add(announcer);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] TCP NetBIOS host announcer created");
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (config.hasTcpipSMB()) {
            sessHandler = new TcpipSMBSessionSocketHandler(srv, config.getTcpipSMBPort(), config.getSMBBindAddress(), this.hasDebug());
            ((SocketSessionHandler)sessHandler).setSocketTimeout(config.getSocketTimeout());
            try {
                ((SocketSessionHandler)sessHandler).initializeSessionHandler(srv);
                this.m_handlerList.addHandler(sessHandler);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Native SMB TCP session handler created");
                }
            }
            catch (IOException ex) {
                throw new InvalidConfigurationException("Error initializing session handler, " + ex.getMessage());
            }
        }
        if (config.hasWin32NetBIOS() && this.isWindowsNTOnwards()) {
            if (this.hasDebug()) {
                int[] lanas = Win32NetBIOS.LanaEnumerate();
                StringBuffer lanaStr = new StringBuffer();
                if (lanas != null && lanas.length > 0) {
                    for (int i = 0; i < lanas.length; ++i) {
                        lanaStr.append(Integer.toString(lanas[i]));
                        lanaStr.append(" ");
                    }
                }
                Debug.println("[SMB] Win32 NetBIOS Available LANAs: " + lanaStr.toString());
            }
            sessHandler = null;
            ArrayList<SessionHandlerBase> lanaListeners = new ArrayList<SessionHandlerBase>();
            if (config.getWin32LANA() != -1) {
                block38: {
                    sessHandler = new Win32NetBIOSSessionSocketHandler(srv, config.getWin32LANA(), this.hasDebug());
                    try {
                        ((Win32NetBIOSSessionSocketHandler)sessHandler).initializeSessionHandler(srv);
                        this.m_handlerList.addHandler(sessHandler);
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Win32 NetBIOS created session handler on LANA " + config.getWin32LANA());
                        }
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) break block38;
                        Debug.println("[SMB] Win32 NetBIOS failed to create session handler for LANA " + config.getWin32LANA());
                        Debug.println("      " + ex.getMessage());
                    }
                }
                if (config.hasWin32EnableAnnouncer()) {
                    Win32NetBIOSHostAnnouncer hostAnnouncer = new Win32NetBIOSHostAnnouncer((Win32NetBIOSSessionSocketHandler)sessHandler, config.getDomainName(), config.getWin32HostAnnounceInterval());
                    hostAnnouncer.setDebug(this.hasDebug());
                    this.m_hostAnnouncers.add(hostAnnouncer);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Win32 NetBIOS host announcer enabled on LANA " + config.getWin32LANA());
                    }
                }
                if (sessHandler instanceof LanaListener) {
                    lanaListeners.add(sessHandler);
                }
            } else {
                int[] lanas = Win32NetBIOS.LanaEnumerate();
                if (lanas != null && lanas.length > 0) {
                    for (int i = 0; i < lanas.length; ++i) {
                        int lana;
                        block39: {
                            lana = lanas[i];
                            sessHandler = new Win32NetBIOSSessionSocketHandler(srv, lana, this.hasDebug());
                            try {
                                ((Win32NetBIOSSessionSocketHandler)sessHandler).initializeSessionHandler(srv);
                                this.m_handlerList.addHandler(sessHandler);
                                if (this.hasDebug()) {
                                    Debug.println("[SMB] Win32 NetBIOS created session handler on LANA " + lana);
                                }
                            }
                            catch (Exception ex) {
                                if (!this.hasDebug()) break block39;
                                Debug.println("[SMB] Win32 NetBIOS failed to create session handler for LANA " + lana);
                                Debug.println("      " + ex.getMessage());
                            }
                        }
                        if (config.hasWin32EnableAnnouncer()) {
                            Win32NetBIOSHostAnnouncer hostAnnouncer = new Win32NetBIOSHostAnnouncer((Win32NetBIOSSessionSocketHandler)sessHandler, config.getDomainName(), config.getWin32HostAnnounceInterval());
                            hostAnnouncer.setDebug(this.hasDebug());
                            this.m_hostAnnouncers.add(hostAnnouncer);
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Win32 NetBIOS host announcer enabled on LANA " + lana);
                            }
                        }
                        if (!(sessHandler instanceof LanaListener)) continue;
                        lanaListeners.add(sessHandler);
                    }
                }
                Win32NetBIOSLanaMonitor lanaMonitor = new Win32NetBIOSLanaMonitor(srv, lanas, 5000L, this.hasDebug());
                if (lanaListeners.size() > 0) {
                    for (int i = 0; i < lanaListeners.size(); ++i) {
                        Win32NetBIOSSessionSocketHandler handler = (Win32NetBIOSSessionSocketHandler)lanaListeners.get(i);
                        lanaMonitor.addLanaListener(handler.getLANANumber(), handler);
                    }
                }
            }
        }
    }

    public int numberOfSessionHandlers() {
        return this.m_handlerList.numberOfHandlers();
    }

    public void startHandler() {
        int idx;
        for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
            SessionHandlerInterface sessHandler = this.m_handlerList.getHandlerAt(idx);
            if (!(sessHandler instanceof Runnable)) continue;
            Thread handlerThread = new Thread((Runnable)((Object)sessHandler));
            handlerThread.setName("CIFSSessHandler_" + sessHandler.getHandlerName());
            handlerThread.start();
            if (!this.hasDebug()) continue;
            Debug.println("[SMB] Created session handler thread " + handlerThread.getName());
        }
        if (this.m_hostAnnouncers.size() > 0) {
            for (idx = 0; idx < this.m_hostAnnouncers.size(); ++idx) {
                HostAnnouncer hostAnnouncer = this.m_hostAnnouncers.get(idx);
                hostAnnouncer.startAnnouncer();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Started host announcer " + hostAnnouncer.getName());
            }
        }
    }

    public void stopHandler() {
        int idx;
        for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
            SessionHandlerInterface sessHandler = this.m_handlerList.getHandlerAt(idx);
            sessHandler.closeSessionHandler(this.m_server);
            if (!this.hasDebug()) continue;
            Debug.println("[SMB] Shutting down session handler thread " + sessHandler.getHandlerName());
        }
        if (this.m_hostAnnouncers.size() > 0) {
            for (idx = 0; idx < this.m_hostAnnouncers.size(); ++idx) {
                HostAnnouncer hostAnnouncer = this.m_hostAnnouncers.get(idx);
                hostAnnouncer.shutdownAnnouncer();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Shutting down host announcer " + hostAnnouncer.getName());
            }
        }
    }

    private final boolean isWindowsNTOnwards() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME");
        }
        return false;
    }
}

