/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.disk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.server.filesys.AccessMode;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.smb.server.disk.NIOFileLock;

public class NIOJavaNetworkFile
extends NetworkFile {
    protected File m_file;
    protected RandomAccessFile m_io;
    protected boolean m_eof;
    protected FileChannel m_channel;

    public NIOJavaNetworkFile(File file, String netPath) {
        super(file.getName());
        this.m_file = file;
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    public NIOJavaNetworkFile(String name, String netPath) {
        super(name);
        File newFile = new File(name);
        if (newFile.exists()) {
            this.m_file = newFile;
        } else {
            String lowerName = name.toLowerCase();
            File newFile2 = new File(lowerName);
            if (newFile2.exists()) {
                this.m_file = newFile2;
            } else {
                this.m_file = newFile;
                try {
                    FileOutputStream outFile = new FileOutputStream(newFile);
                    outFile.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    public NIOJavaNetworkFile(String name, int mode) {
        super(name);
        File newFile = new File(name);
        if (!newFile.exists()) {
            String lowerName = name.toLowerCase();
            File newFile2 = new File(lowerName);
            if (newFile2.exists()) {
                this.m_file = newFile2;
            } else {
                this.m_file = newFile;
                if (AccessMode.getAccessMode(mode) != 0) {
                    try {
                        FileOutputStream outFile = new FileOutputStream(newFile);
                        outFile.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
    }

    public void closeFile() throws IOException {
        if (this.m_channel != null) {
            this.m_io.close();
            this.m_io = null;
            this.m_channel.close();
            this.m_channel = null;
            if (this.getWriteCount() > 0) {
                this.m_file.setLastModified(System.currentTimeMillis());
            }
            this.setClosed(true);
        }
    }

    public long currentPosition() {
        try {
            if (this.m_channel != null) {
                return this.m_channel.position();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public void flushFile() throws IOException {
        if (this.m_channel != null) {
            this.m_channel.force(false);
        }
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_channel != null && this.m_channel.position() == this.m_channel.size();
    }

    public void openFile(boolean createFlag) throws IOException {
        this.m_io = new RandomAccessFile(this.m_file, this.getGrantedAccess() == 2 ? "rw" : "r");
        this.m_channel = this.m_io.getChannel();
        this.setClosed(false);
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_channel == null) {
            this.openFile(false);
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, pos, len);
        int rdlen = this.m_channel.read(byteBuf);
        return rdlen;
    }

    public long seekFile(long pos, int typ) throws IOException {
        if (this.m_channel == null) {
            this.openFile(false);
        }
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_channel.position(pos);
                break;
            }
            case 1: {
                this.m_channel.position(this.currentPosition() + pos);
                break;
            }
            case 2: {
                long newPos = this.m_channel.size() + pos;
                this.m_channel.position(newPos);
            }
        }
        return this.currentPosition();
    }

    public void truncateFile(long siz) throws IOException {
        if (this.m_channel == null) {
            this.openFile(true);
        }
        this.m_io.setLength(siz);
        this.incrementWriteCount();
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, pos, len);
        this.m_channel.write(byteBuf);
        this.incrementWriteCount();
    }

    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        long fileLen;
        if (this.m_io == null) {
            this.openFile(true);
        }
        if (offset > (fileLen = this.m_io.length())) {
            this.m_io.setLength(offset + (long)len);
        }
        if (len == 0) {
            return;
        }
        this.m_channel.position(offset);
        ByteBuffer byteBuf = ByteBuffer.wrap(buf, pos, len);
        this.m_channel.write(byteBuf);
        this.incrementWriteCount();
    }

    public void lockFile(NIOFileLock lock) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        }
        if (this.hasLocks() && !this.getLockList().allowsLock(lock)) {
            Debug.println("** Lock conflict " + lock);
            throw new LockConflictException();
        }
        boolean sharedLock = this.getGrantedAccess() == 0;
        FileLock nioLock = null;
        try {
            nioLock = lock.isWholeFile() ? (sharedLock ? this.m_channel.tryLock(0L, this.getFileSize(), sharedLock) : this.m_channel.tryLock()) : this.m_channel.tryLock(lock.getOffset(), lock.getLength(), sharedLock);
        }
        catch (OverlappingFileLockException ex) {
            Debug.println("** Lock overlap - " + lock + " **");
        }
        catch (IOException ex) {
            Debug.println("** Lock IO error - " + lock + " - " + ex.toString() + " **");
        }
        if (nioLock == null) {
            throw new LockConflictException();
        }
        lock.setNIOLock(nioLock);
        this.addLock(lock);
        Debug.println("** Add lock " + lock + ", cnt=" + this.getLockList().numberOfLocks());
    }

    public void unlockFile(NIOFileLock lock) throws IOException {
        if (this.getLockList() == null) {
            return;
        }
        NIOFileLock fLock = (NIOFileLock)this.getLockList().removeLock(lock);
        if (fLock != null && fLock.getNIOLock() != null) {
            fLock.getNIOLock().release();
            fLock.setNIOLock(null);
            Debug.println("** Remove lock " + lock + ", cnt=" + this.getLockList().numberOfLocks());
        }
    }
}

