/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio;

import java.nio.channels.SelectionKey;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class NIOCIFSThreadRequest
implements ThreadRequest {
    private SMBSrvSession m_sess;
    private SelectionKey m_selectionKey;

    public NIOCIFSThreadRequest(SMBSrvSession sess, SelectionKey selKey) {
        this.m_sess = sess;
        this.m_selectionKey = selKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            SMBSrvPacket smbPkt = null;
            try {
                block11: {
                    try {
                        PacketHandler pktHandler = this.m_sess.getPacketHandler();
                        smbPkt = pktHandler.readPacket();
                        if (smbPkt == null) {
                            if (this.m_sess.hasDebug(0x400000)) {
                                Debug.println("Received null packet, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
                            }
                            this.m_sess.hangupSession("Client closed socket");
                            this.m_sess.processPacket(null);
                            this.m_selectionKey.cancel();
                            this.m_selectionKey.selector().wakeup();
                            break block11;
                        }
                        this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                        this.m_selectionKey.selector().wakeup();
                        this.m_sess.processPacket(smbPkt);
                        smbPkt = null;
                    }
                    catch (Throwable ex) {
                        if (this.m_sess.hasDebug(0x400000)) {
                            Debug.println("Error during packet receive, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress() + " ex=" + ex.getMessage());
                        }
                        this.m_sess.hangupSession("Client closed socket");
                        this.m_sess.processPacket(null);
                        this.m_selectionKey.cancel();
                        this.m_selectionKey.selector().wakeup();
                        Object var4_5 = null;
                        if (smbPkt != null) {
                            this.m_sess.getPacketPool().releasePacket(smbPkt);
                        }
                    }
                }
                Object var4_4 = null;
                if (smbPkt != null) {
                    this.m_sess.getPacketPool().releasePacket(smbPkt);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (smbPkt != null) {
                    this.m_sess.getPacketPool().releasePacket(smbPkt);
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NIO CIFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("]");
        return str.toString();
    }
}

