/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.notify;

import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.smb.server.NTTransPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.notify.NotifyChangeEvent;
import org.alfresco.jlan.smb.server.notify.NotifyChangeEventList;
import org.alfresco.jlan.smb.server.notify.NotifyRequest;
import org.alfresco.jlan.smb.server.notify.NotifyRequestList;
import org.alfresco.jlan.util.DataPacker;

public class NotifyChangeHandler
implements Runnable {
    private NotifyRequestList m_notifyList;
    private int m_globalNotifyMask;
    private DiskDeviceContext m_diskCtx;
    private Thread m_procThread;
    private NotifyChangeEventList m_eventList;
    private boolean m_debug = false;
    private boolean m_shutdown;

    public NotifyChangeHandler(DiskDeviceContext diskCtx) {
        this.m_diskCtx = diskCtx;
        this.m_eventList = new NotifyChangeEventList();
        this.m_procThread = new Thread(this);
        this.m_procThread.setDaemon(true);
        this.m_procThread.setName("Notify_" + this.m_diskCtx.getDeviceName());
        this.m_procThread.start();
    }

    public final void addNotifyRequest(NotifyRequest req) {
        if (this.m_notifyList == null) {
            this.m_notifyList = new NotifyRequestList();
        }
        req.setDiskContext(this.m_diskCtx);
        this.m_notifyList.addRequest(req);
        this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
    }

    public final void removeNotifyRequest(NotifyRequest req) {
        this.removeNotifyRequest(req, true);
    }

    public final void removeNotifyRequest(NotifyRequest req, boolean updateMask) {
        if (this.m_notifyList == null) {
            return;
        }
        this.m_notifyList.removeRequest(req);
        if (updateMask) {
            this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
        }
    }

    public final void removeNotifyRequests(SMBSrvSession sess) {
        this.m_notifyList.removeAllRequestsForSession(sess);
        this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
    }

    public final boolean hasFileNameChange() {
        return this.hasFilterFlag(1);
    }

    public final boolean hasDirectoryNameChange() {
        return this.hasFilterFlag(2);
    }

    public final boolean hasAttributeChange() {
        return this.hasFilterFlag(4);
    }

    public final boolean hasFileSizeChange() {
        return this.hasFilterFlag(8);
    }

    public final boolean hasFileWriteTimeChange() {
        return this.hasFilterFlag(16);
    }

    public final boolean hasFileAccessTimeChange() {
        return this.hasFilterFlag(32);
    }

    public final boolean hasFileCreateTimeChange() {
        return this.hasFilterFlag(64);
    }

    public final boolean hasSecurityDescriptorChange() {
        return this.hasFilterFlag(256);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final int getGlobalNotifyMask() {
        return this.m_globalNotifyMask;
    }

    public final int getRequestQueueSize() {
        return this.m_notifyList != null ? this.m_notifyList.numberOfRequests() : 0;
    }

    private final boolean hasFilterFlag(int flag) {
        return (this.m_globalNotifyMask & flag) != 0;
    }

    public final void notifyFileChanged(int action, String path) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(1, action, path, false));
    }

    public final void notifyRename(String oldName, String newName) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileNameChange() && !this.hasDirectoryNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(1, 5, oldName, newName, false));
    }

    public final void notifyDirectoryChanged(int action, String path) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasDirectoryNameChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(2, action, path, true));
    }

    public final void notifyAttributesChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasAttributeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(4, 3, path, isdir));
    }

    public final void notifyFileSizeChanged(String path) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileSizeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(8, 3, path, false));
    }

    public final void notifyLastWriteTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileWriteTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(16, 3, path, isdir));
    }

    public final void notifyLastAccessTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileAccessTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(32, 3, path, isdir));
    }

    public final void notifyCreationTimeChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasFileCreateTimeChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(64, 3, path, isdir));
    }

    public final void notifySecurityDescriptorChanged(String path, boolean isdir) {
        if (this.getGlobalNotifyMask() == 0 || !this.hasSecurityDescriptorChange()) {
            return;
        }
        this.queueNotification(new NotifyChangeEvent(256, 3, path, isdir));
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void shutdownRequest() {
        if (this.m_procThread != null) {
            this.m_shutdown = true;
            this.m_procThread.interrupt();
        }
    }

    public final void sendBufferedNotifications(NotifyRequest req, NotifyChangeEventList evtList) {
        block15: {
            if (this.hasDebug()) {
                Debug.println("Send buffered notifications, req=" + req + ", evtList=" + (evtList != null ? "" + evtList.numberOfEvents() : "null"));
            }
            long tmo = System.currentTimeMillis() + 10000L;
            NTTransPacket ntpkt = new NTTransPacket();
            ntpkt.setParameterCount(18);
            ntpkt.resetBytePointerAlign();
            int pos = ntpkt.getPosition();
            ntpkt.setNTParameter(1, 0);
            ntpkt.setNTParameter(3, pos - 4);
            if (req.hasNotifyEnum()) {
                ntpkt.setNTParameter(0, 0);
                ntpkt.setNTParameter(2, 0);
                ntpkt.setNTParameter(6, pos - 4);
                ntpkt.setByteCount();
                ntpkt.setCommand(160);
                ntpkt.setLongErrorCode(268);
                ntpkt.setFlags(24);
                ntpkt.setFlags2(49152);
                req.setCompleted(true, tmo);
                req.setNotifyEnum(false);
                ntpkt.setMultiplexId(req.getMultiplexId());
                ntpkt.setTreeId(req.getTreeId());
                ntpkt.setUserId(req.getUserId());
                ntpkt.setProcessId(req.getProcessId());
                try {
                    if (!req.getSession().sendAsynchResponseSMB(ntpkt, ntpkt.getLength())) {
                        ntpkt = new NTTransPacket(ntpkt);
                    }
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block15;
                    Debug.println("Failed to send change notification, " + ex.getMessage());
                }
            } else if (evtList != null) {
                for (int i = 0; i < evtList.numberOfEvents(); ++i) {
                    NotifyChangeEvent evt = evtList.getEventAt(i);
                    String relName = FileName.makeRelativePath(req.getWatchPath(), evt.getFileName());
                    if (relName == null) {
                        relName = evt.getShortFileName();
                    }
                    if (this.hasDebug()) {
                        Debug.println("  Notify evtPath=" + evt.getFileName() + ", reqPath=" + req.getWatchPath() + ", relative=" + relName);
                    }
                    ntpkt.packInt(0);
                    ntpkt.packInt(evt.getAction());
                    ntpkt.packInt(relName.length() * 2);
                    ntpkt.packString(relName, true, false);
                    if (evt.getAction() == 5 && evt.hasOldFileName()) {
                        int newPos = DataPacker.longwordAlign(ntpkt.getPosition());
                        DataPacker.putIntelInt(newPos - pos, ntpkt.getBuffer(), pos);
                        relName = FileName.makeRelativePath(req.getWatchPath(), evt.getOldFileName());
                        if (relName == null) {
                            relName = evt.getOldFileName();
                        }
                        ntpkt.packInt(0);
                        ntpkt.packInt(4);
                        ntpkt.packInt(relName.length() * 2);
                        ntpkt.packString(relName, true, false);
                    }
                    int prmLen = ntpkt.getPosition() - pos;
                    ntpkt.alignBytePointer();
                    pos = pos + 3 & 0xFFFFFFFC;
                    ntpkt.setNTParameter(0, prmLen);
                    ntpkt.setNTParameter(2, prmLen);
                    ntpkt.setNTParameter(6, ntpkt.getPosition() - 4);
                    ntpkt.setByteCount();
                    ntpkt.setCommand(160);
                    ntpkt.setFlags(24);
                    ntpkt.setFlags2(49152);
                    req.setCompleted(true, tmo);
                    ntpkt.setMultiplexId(req.getMultiplexId());
                    ntpkt.setTreeId(req.getTreeId());
                    ntpkt.setUserId(req.getUserId());
                    ntpkt.setProcessId(req.getProcessId());
                    try {
                        if (req.getSession().sendAsynchResponseSMB(ntpkt, ntpkt.getLength())) continue;
                        ntpkt = new NTTransPacket(ntpkt);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) continue;
                        Debug.println("Failed to send change notification, " + ex.getMessage());
                    }
                }
            }
        }
        if (this.hasDebug()) {
            Debug.println("sendBufferedNotifications() done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void queueNotification(NotifyChangeEvent evt) {
        if (this.hasDebug()) {
            Debug.println("Queue notification event=" + evt.toString());
        }
        NotifyChangeEventList notifyChangeEventList = this.m_eventList;
        synchronized (notifyChangeEventList) {
            this.m_eventList.addEvent(evt);
            this.m_eventList.notifyAll();
        }
    }

    protected final int sendChangeNotification(NotifyChangeEvent evt) {
        Vector reqList;
        if (this.hasDebug()) {
            Debug.println("sendChangeNotification event=" + evt);
        }
        if ((reqList = this.findMatchingRequests(evt.getFilter(), evt.getFileName(), evt.isDirectory())) == null || reqList.size() == 0) {
            return 0;
        }
        if (this.hasDebug()) {
            Debug.println("  Found " + reqList.size() + " matching change listeners");
        }
        long tmo = System.currentTimeMillis() + 10000L;
        NTTransPacket ntpkt = new NTTransPacket();
        for (int i = 0; i < reqList.size(); ++i) {
            NotifyRequest req = (NotifyRequest)reqList.elementAt(i);
            ntpkt.setParameterCount(18);
            ntpkt.resetBytePointerAlign();
            int pos = ntpkt.getPosition();
            ntpkt.setNTParameter(1, 0);
            ntpkt.setNTParameter(3, pos - 4);
            String relName = evt.getFileName();
            if (relName == null) {
                relName = evt.getShortFileName();
            }
            if (this.hasDebug()) {
                Debug.println("  Notify evtPath=" + evt.getFileName() + ", MID=" + req.getMultiplexId() + ", reqPath=" + req.getWatchPath() + ", relative=" + relName);
            }
            ntpkt.packInt(0);
            ntpkt.packInt(evt.getAction());
            ntpkt.packInt(relName.length() * 2);
            ntpkt.packString(relName, true, false);
            if (evt.getAction() == 5 && evt.hasOldFileName()) {
                int newPos = DataPacker.longwordAlign(ntpkt.getPosition());
                DataPacker.putIntelInt(newPos - pos, ntpkt.getBuffer(), pos);
                relName = FileName.makeRelativePath(req.getWatchPath(), evt.getOldFileName());
                if (relName == null) {
                    relName = evt.getOldFileName();
                }
                ntpkt.packInt(0);
                ntpkt.packInt(4);
                ntpkt.packInt(relName.length() * 2);
                ntpkt.packString(relName, true, false);
            }
            int prmLen = ntpkt.getPosition() - pos;
            ntpkt.alignBytePointer();
            pos = pos + 3 & 0xFFFFFFFC;
            ntpkt.setNTParameter(0, prmLen);
            ntpkt.setNTParameter(2, prmLen);
            ntpkt.setNTParameter(6, ntpkt.getPosition() - 4);
            ntpkt.setByteCount();
            int bytCnt = ntpkt.getByteCount();
            ntpkt.setCommand(160);
            ntpkt.setLongErrorCode(0);
            ntpkt.setFlags(24);
            ntpkt.setFlags2(49152);
            if (!req.isCompleted()) {
                req.setCompleted(true, tmo);
                ntpkt.setMultiplexId(req.getMultiplexId());
                ntpkt.setTreeId(req.getTreeId());
                ntpkt.setUserId(req.getUserId());
                ntpkt.setProcessId(req.getProcessId());
                try {
                    if (!req.getSession().sendAsynchResponseSMB(ntpkt, ntpkt.getLength())) {
                        ntpkt = new NTTransPacket(ntpkt);
                        if (req.getSession().hasDebug(0x100000)) {
                            req.getSession().debugPrintln("  Notification request was queued, sess=" + req.getSession().getSessionId() + ", MID=" + req.getMultiplexId());
                        }
                    } else if (req.getSession().hasDebug(0x100000)) {
                        req.getSession().debugPrintln("  Notification request was sent, sess=" + req.getSession().getSessionId() + ", MID=" + req.getMultiplexId());
                    }
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            } else {
                req.addEvent(evt);
                if (req.getSession().hasDebug(0x100000)) {
                    req.getSession().debugPrintln("Buffered notify req=" + req + ", event=" + evt + ", sess=" + req.getSession().getSessionId());
                }
            }
            req.getSession().setNotifyPending(false);
            if (!req.getSession().hasDebug(0x100000)) continue;
            req.getSession().debugPrintln("Asynch notify req=" + req + ", event=" + evt + ", sess=" + req.getSession().getUniqueId());
        }
        if (this.hasDebug()) {
            Debug.println("sendChangeNotification() done");
        }
        return reqList.size();
    }

    protected final synchronized Vector findMatchingRequests(int typ, String path, boolean isdir) {
        Vector<NotifyRequest> reqList = new Vector<NotifyRequest>();
        String matchPath = path.toUpperCase();
        int idx = 0;
        long curTime = System.currentTimeMillis();
        boolean removedReq = false;
        while (idx < this.m_notifyList.numberOfRequests()) {
            NotifyRequest curReq = this.m_notifyList.getRequest(idx);
            if (this.hasDebug()) {
                Debug.println("findMatchingRequests() req=" + curReq.toString());
            }
            if (curReq.hasExpired(curTime)) {
                this.m_notifyList.removeRequestAt(idx);
                if (this.hasDebug()) {
                    Debug.println("Removed expired request req=" + curReq.toString());
                    if (curReq.getBufferedEventList() != null) {
                        NotifyChangeEventList bufList = curReq.getBufferedEventList();
                        Debug.println("  Buffered events = " + bufList.numberOfEvents());
                        for (int b = 0; b < bufList.numberOfEvents(); ++b) {
                            Debug.println("    " + (b + 1) + ": " + bufList.getEventAt(b));
                        }
                    }
                }
                removedReq = true;
                continue;
            }
            if (curReq.hasFilter(typ)) {
                String[] paths;
                if (this.hasDebug()) {
                    Debug.println("  hasFilter typ=" + typ + ", watchTree=" + curReq.hasWatchTree() + ", watchPath=" + curReq.getWatchPath() + ", matchPath=" + matchPath + ", isDir=" + isdir);
                }
                boolean wantReq = false;
                if (matchPath.length() == 0 && curReq.hasWatchTree()) {
                    wantReq = true;
                } else if (curReq.hasWatchTree() && matchPath.startsWith(curReq.getWatchPath())) {
                    wantReq = true;
                } else if (isdir && matchPath.compareTo(curReq.getWatchPath()) == 0) {
                    wantReq = true;
                } else if (!isdir && (paths = FileName.splitPath(matchPath)) != null && paths[0] != null && curReq.getWatchPath().equalsIgnoreCase(paths[0])) {
                    wantReq = true;
                }
                if (wantReq) {
                    curReq.getSession().setNotifyPending(true);
                    reqList.addElement(curReq);
                    if (this.hasDebug()) {
                        Debug.println("  Added request to matching list");
                    }
                }
            }
            ++idx;
        }
        if (removedReq) {
            this.m_globalNotifyMask = this.m_notifyList.getGlobalFilter();
        }
        return reqList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: while (!this.m_shutdown) {
            NotifyChangeEventList notifyChangeEventList = this.m_eventList;
            synchronized (notifyChangeEventList) {
                try {
                    this.m_eventList.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.m_shutdown) break;
            while (this.m_eventList.numberOfEvents() > 0) {
                NotifyChangeEvent evt = null;
                NotifyChangeEventList ex = this.m_eventList;
                synchronized (ex) {
                    evt = this.m_eventList.removeEventAt(0);
                }
                if (evt == null) continue block10;
                try {
                    int cnt = this.sendChangeNotification(evt);
                    if (!this.hasDebug()) continue;
                    Debug.println("Change notify event=" + evt.toString() + ", clients=" + cnt);
                }
                catch (Throwable ex2) {
                    Debug.println("NotifyChangeHandler thread");
                    Debug.println(ex2);
                }
            }
        }
        if (this.hasDebug()) {
            Debug.println("NotifyChangeHandler thread exit");
        }
    }
}

