/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;

public class SHARED_LOOPBACK
extends TP {
    private static int next_port = 10000;
    private PhysicalAddress physical_addr = null;
    private Address local_addr = null;
    private static final Map<String, Map<Address, SHARED_LOOPBACK>> routing_table = new ConcurrentHashMap<String, Map<Address, SHARED_LOOPBACK>>();

    public String toString() {
        return "SHARED_LOOPBACK(local address: " + this.local_addr + ')';
    }

    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        for (Map.Entry<Address, SHARED_LOOPBACK> entry : dests.entrySet()) {
            Address dest = entry.getKey();
            SHARED_LOOPBACK target = entry.getValue();
            try {
                target.receive(this.local_addr, data, offset, length);
            }
            catch (Throwable t) {
                this.log.error("failed sending message to " + dest, t);
            }
        }
    }

    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        SHARED_LOOPBACK target = dests.get(dest);
        if (target == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("destination address " + dest + " not found");
            }
            return;
        }
        target.receive(this.local_addr, data, offset, length);
    }

    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        SHARED_LOOPBACK target = dests.get(dest);
        if (target == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("destination address " + dest + " not found");
            }
            return;
        }
        target.receive(this.local_addr, buf, offset, length);
    }

    public String getInfo() {
        return this.toString();
    }

    protected PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    public String getName() {
        return "SHARED_LOOPBACK";
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress("127.0.0.1", next_port++);
        super.init();
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                SHARED_LOOPBACK.register(this.channel_name, this.local_addr, this);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 4: {
                SHARED_LOOPBACK.unregister(this.channel_name, this.local_addr);
            }
        }
        return retval;
    }

    private static void register(String channel_name, Address local_addr, SHARED_LOOPBACK shared_loopback) {
        Map<Address, SHARED_LOOPBACK> map = routing_table.get(channel_name);
        if (map == null) {
            map = new ConcurrentHashMap<Address, SHARED_LOOPBACK>();
            routing_table.put(channel_name, map);
        }
        map.put(local_addr, shared_loopback);
    }

    private static void unregister(String channel_name, Address local_addr) {
        Map<Address, SHARED_LOOPBACK> map = routing_table.get(channel_name);
        if (map != null) {
            map.remove(local_addr);
            if (map.isEmpty()) {
                routing_table.remove(channel_name);
            }
        }
    }
}

