/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ExposedByteArrayInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManagerThreadPoolExecutor;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Transport protocol")
@DeprecatedProperty(names={"bind_to_all_interfaces", "use_incoming_packet_handler", "use_outgoing_packet_handler", "use_concurrent_stack", "prevent_port_reuse", "persistent_ports", "pm_expiry_time", "persistent_ports_file"})
public abstract class TP
extends Protocol {
    private static final byte LIST = 1;
    private static final byte MULTICAST = 2;
    private static final byte OOB = 4;
    private static NumberFormat f = NumberFormat.getNumberInstance();
    private static final int INITIAL_BUFSIZE = 4095;
    private ExposedByteArrayOutputStream out_stream = null;
    private ExposedDataOutputStream dos = null;
    private final Lock out_stream_lock = new ReentrantLock();
    @ManagedAttribute
    @Property(converter=PropertyConverters.BindAddress.class, description="The interface (NIC) which should be used by this transport ")
    protected InetAddress bind_addr = null;
    @Property(description="Ignores all bind address parameters and  let's the OS return the local host address. Default is false")
    protected boolean use_local_host = false;
    @ManagedAttribute
    @Property(description=" If true, the transport should use all available interfaces to receive multicast messages. Default is false")
    protected boolean receive_on_all_interfaces = false;
    @ManagedAttribute
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces = null;
    @Property(name="start_port", deprecatedMessage="start_port is deprecated; use bind_port instead", description="The port to which the transport binds. Default of 0 binds to any (ephemeral) port")
    protected int bind_port = 0;
    @Property(name="end_port", deprecatedMessage="end_port is deprecated; use port_range instead")
    protected int port_range = 1;
    @Deprecated
    @Property(description="tries to make sure ephemeral ports are used", deprecatedMessage="Not used anymore since logical addresses make this superfluous (2.8)")
    protected boolean prevent_port_reuse = false;
    @ManagedAttribute(description="", writable=true)
    @Property(description="Messages to self are looped back immediately if true. Default is false")
    protected boolean loopback = false;
    @ManagedAttribute(description="Discard packets with a different version", writable=true)
    @Property(description="Discard packets with a different version if true. Default is false")
    protected boolean discard_incompatible_packets = false;
    @Property(description="Thread naming pattern for threads in this channel. Default is cl")
    protected String thread_naming_pattern = "cl";
    @Property(name="oob_thread_pool.enabled", description="Switch for enabling thread pool for OOB messages. Default true")
    protected boolean oob_thread_pool_enabled = true;
    @ManagedAttribute(description="Minimum thread pool size for OOB messages. Default is 2")
    @Property(name="oob_thread_pool.min_threads", description="Minimum thread pool size for OOB messages. Default is 2")
    protected int oob_thread_pool_min_threads = 2;
    @ManagedAttribute(description="Maximum thread pool size for OOB messages. Default is 10")
    @Property(name="oob_thread_pool.max_threads", description="Maximum thread pool size for OOB messages. Default is 10")
    protected int oob_thread_pool_max_threads = 10;
    @ManagedAttribute(description="Timeout in milliseconds to remove idle thread from OOB pool. Default is 30000")
    @Property(name="oob_thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle thread from OOB pool. Default is 30000")
    protected long oob_thread_pool_keep_alive_time = 30000L;
    @ManagedAttribute(description="Use queue to enqueue incoming OOB messages. Default is true")
    @Property(name="oob_thread_pool.queue_enabled", description="Use queue to enqueue incoming OOB messages. Default is true")
    protected boolean oob_thread_pool_queue_enabled = true;
    @ManagedAttribute(description="Maximum queue size for incoming OOB messages. Default is 500")
    @Property(name="oob_thread_pool.queue_max_size", description="Maximum queue size for incoming OOB messages. Default is 500")
    protected int oob_thread_pool_queue_max_size = 500;
    @ManagedAttribute
    @Property(name="oob_thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run. Default is Run")
    String oob_thread_pool_rejection_policy = "Run";
    @ManagedAttribute(description="Minimum thread pool size for regular messages. Default is 2")
    @Property(name="thread_pool.min_threads", description="Minimum thread pool size for regular messages. Default is 2")
    protected int thread_pool_min_threads = 2;
    @ManagedAttribute(description="Maximum thread pool size for regular messages. Default is 10")
    @Property(name="thread_pool.max_threads", description="Maximum thread pool size for regular messages. Default is 10")
    protected int thread_pool_max_threads = 10;
    @ManagedAttribute(description="Timeout in milliseconds to remove idle thread from regular pool. Default is 30000")
    @Property(name="thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle thread from regular pool. Default is 30000")
    protected long thread_pool_keep_alive_time = 30000L;
    @ManagedAttribute(description="Switch for enabling thread pool for regular messages. Default true")
    @Property(name="thread_pool.enabled", description="Switch for enabling thread pool for regular messages. Default true")
    protected boolean thread_pool_enabled = true;
    @ManagedAttribute(description="Use queue to enqueue incoming regular messages")
    @Property(name="thread_pool.queue_enabled", description="Use queue to enqueue incoming regular messages. Default is true")
    protected boolean thread_pool_queue_enabled = true;
    @ManagedAttribute(description="Maximum queue size for incoming OOB messages")
    @Property(name="thread_pool.queue_max_size", description="Maximum queue size for incoming OOB messages. Default is 500")
    protected int thread_pool_queue_max_size = 500;
    @ManagedAttribute
    @Property(name="thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run Default is Run")
    protected String thread_pool_rejection_policy = "Run";
    @ManagedAttribute(description="Number of threads to be used by the timer thread pool")
    @Property(name="timer.num_threads", description="Number of threads to be used by the timer thread pool. Default is 4")
    protected int num_timer_threads = 4;
    @ManagedAttribute(description="Enable bundling of smaller messages into bigger ones", writable=true)
    @Property(description="Enable bundling of smaller messages into bigger ones. Default is true")
    protected boolean enable_bundling = true;
    @Property(description="Enable bundling of smaller messages into bigger ones for unicast messages. Default is false")
    protected boolean enable_unicast_bundling = false;
    @Property(description="Switch to enable diagnostic probing. Default is true")
    protected boolean enable_diagnostics = true;
    @Property(description="Address for diagnostic probing. Default is 224.0.75.75")
    protected String diagnostics_addr = "224.0.75.75";
    @Property(description="Port for diagnostic probing. Default is 7500")
    protected int diagnostics_port = 7500;
    @Property(description="If assigned enable this transport to be a singleton (shared) transport")
    protected String singleton_name = null;
    @Property(description="Path to a file to store currently used ports on this machine", deprecatedMessage="With the addition of logical addresses, the port manager has been deprecated")
    protected String persistent_ports_file = null;
    @Property(name="ports_expiry_time", description="Timeout to expire ports used with PortManager. Default is 30000 msec", deprecatedMessage="With the addition of logical addresses, the port manager has been deprecated")
    protected long pm_expiry_time = 30000L;
    @Property(description="Switch to enable tracking of currently used ports on this machine. Default is false", deprecatedMessage="With the addition of logical addresses, the port manager has been deprecated")
    protected boolean persistent_ports = false;
    protected int max_bundle_size = 64000;
    protected long max_bundle_timeout = 20L;
    @ManagedAttribute
    protected long num_msgs_sent = 0L;
    @ManagedAttribute
    protected long num_msgs_received = 0L;
    @ManagedAttribute
    protected long num_bytes_sent = 0L;
    @ManagedAttribute
    protected long num_bytes_received = 0L;
    @ManagedAttribute
    protected String channel_name = null;
    @ManagedAttribute(writable=true, description="whether or not warnings about messages from different groups are logged")
    private boolean log_discard_msgs = true;
    @ManagedAttribute
    protected long num_oob_msgs_received = 0L;
    @ManagedAttribute
    protected long num_incoming_msgs_received = 0L;
    protected Address local_addr = null;
    protected final Set<Address> members = new CopyOnWriteArraySet<Address>();
    protected final ExposedByteArrayInputStream in_stream = new ExposedByteArrayInputStream(new byte[]{48});
    protected final DataInputStream dis = new DataInputStream(this.in_stream);
    protected ThreadGroup pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
    protected int connect_count = 0;
    protected final ReentrantLock connectLock = new ReentrantLock();
    protected Executor oob_thread_pool;
    protected ThreadFactory oob_thread_factory = null;
    protected BlockingQueue<Runnable> oob_thread_pool_queue = null;
    protected Executor thread_pool;
    protected ThreadFactory default_thread_factory = null;
    protected BlockingQueue<Runnable> thread_pool_queue = null;
    protected TimeScheduler timer = null;
    protected ThreadFactory timer_thread_factory;
    protected ThreadFactory global_thread_factory = null;
    private Bundler bundler = null;
    private DiagnosticsHandler diag_handler = null;
    private final List<ProbeHandler> preregistered_probe_handlers = new LinkedList<ProbeHandler>();
    private final ConcurrentMap<String, Protocol> up_prots = new ConcurrentHashMap<String, Protocol>();
    protected TpHeader header;
    protected final String name = this.getName();
    protected final LazyRemovalCache<Address, PhysicalAddress> logical_addr_cache = new LazyRemovalCache(20, 120000L);
    private static final LazyRemovalCache.Printable<Address, PhysicalAddress> print_function;
    protected long last_who_has_request = System.currentTimeMillis();

    protected TP() {
    }

    public String toString() {
        if (!this.isSingleton()) {
            return this.local_addr != null ? this.name + "(local address: " + this.local_addr + ')' : this.name;
        }
        return this.name + " (singleton=" + this.singleton_name + ")";
    }

    @Override
    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_incoming_msgs_received = 0L;
        this.num_oob_msgs_received = 0L;
    }

    public void registerProbeHandler(ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.registerProbeHandler(handler);
        } else {
            this.preregistered_probe_handlers.add(handler);
        }
    }

    public void unregisterProbeHandler(ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(handler);
        }
    }

    public void setThreadPoolQueueEnabled(boolean flag) {
        this.thread_pool_queue_enabled = flag;
    }

    public Executor getDefaultThreadPool() {
        return this.thread_pool;
    }

    public void setDefaultThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        this.thread_pool = thread_pool;
    }

    public ThreadFactory getDefaultThreadPoolThreadFactory() {
        return this.default_thread_factory;
    }

    public void setDefaultThreadPoolThreadFactory(ThreadFactory factory) {
        this.default_thread_factory = factory;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
    }

    public Executor getOOBThreadPool() {
        return this.oob_thread_pool;
    }

    public void setOOBThreadPool(Executor oob_thread_pool) {
        if (this.oob_thread_pool != null) {
            TP.shutdownThreadPool(this.oob_thread_pool);
        }
        this.oob_thread_pool = oob_thread_pool;
    }

    public ThreadFactory getOOBThreadPoolThreadFactory() {
        return this.oob_thread_factory;
    }

    public void setOOBThreadPoolThreadFactory(ThreadFactory factory) {
        this.oob_thread_factory = factory;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setThreadFactory(factory);
        }
    }

    public ThreadFactory getTimerThreadFactory() {
        return this.timer_thread_factory;
    }

    public void setTimerThreadFactory(ThreadFactory factory) {
        this.timer_thread_factory = factory;
        this.timer.setThreadFactory(factory);
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.global_thread_factory;
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.global_thread_factory = factory;
    }

    public String getThreadNamingPattern() {
        return this.thread_naming_pattern;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "null";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        this.bind_addr = InetAddress.getByName(bind_addr);
    }

    public InetAddress getBindAddressAsInetAddress() {
        return this.bind_addr;
    }

    public int getBindPort() {
        return this.bind_port;
    }

    public void setBindPort(int port) {
        this.bind_port = port;
    }

    public boolean getBindToAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public static boolean isSendOnAllInterfaces() {
        return false;
    }

    public static List<NetworkInterface> getSendInterfaces() {
        return null;
    }

    public boolean isDiscardIncompatiblePackets() {
        return this.discard_incompatible_packets;
    }

    public void setDiscardIncompatiblePackets(boolean flag) {
        this.discard_incompatible_packets = flag;
    }

    public boolean isEnableBundling() {
        return this.enable_bundling;
    }

    public void setEnableBundling(boolean flag) {
        this.enable_bundling = flag;
    }

    public boolean isEnableUnicastBundling() {
        return this.enable_unicast_bundling;
    }

    public void setEnableUnicastBundling(boolean enable_unicast_bundling) {
        this.enable_unicast_bundling = enable_unicast_bundling;
    }

    public void setPortRange(int range) {
        this.port_range = range;
    }

    @Deprecated
    public void setUseConcurrentStack(boolean flag) {
    }

    @ManagedAttribute
    public boolean isOOBThreadPoolEnabled() {
        return this.oob_thread_pool_enabled;
    }

    @ManagedAttribute
    public boolean isDefaulThreadPoolEnabled() {
        return this.thread_pool_enabled;
    }

    @ManagedAttribute(description="Maximum number of bytes for messages to be queued until they are sent")
    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    @ManagedAttribute(description="Maximum number of bytes for messages to be queued until they are sent", writable=true)
    @Property(name="max_bundle_size")
    public void setMaxBundleSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") is <= 0");
        }
        this.max_bundle_size = size;
    }

    @ManagedAttribute(description="Max number of milliseconds until queued messages are sent")
    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    @ManagedAttribute(description="Max number of milliseconds until queued messages are sent", writable=true)
    @Property(name="max_bundle_timeout")
    public void setMaxBundleTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("max_bundle_timeout of " + timeout + " is invalid");
        }
        this.max_bundle_timeout = timeout;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean b) {
        this.loopback = b;
    }

    public static boolean isUseIncomingPacketHandler() {
        return false;
    }

    public ConcurrentMap<String, Protocol> getUpProtocols() {
        return this.up_prots;
    }

    @ManagedAttribute
    public int getOOBMinPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getCorePoolSize() : 0;
    }

    @ManagedAttribute
    public void setOOBMinPoolSize(int size) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setCorePoolSize(size);
        }
    }

    @ManagedAttribute
    public int getOOBMaxPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getMaximumPoolSize() : 0;
    }

    @ManagedAttribute
    public void setOOBMaxPoolSize(int size) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setMaximumPoolSize(size);
        }
    }

    @ManagedAttribute
    public int getOOBPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getPoolSize() : 0;
    }

    @ManagedAttribute
    public long getOOBKeepAliveTime() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getKeepAliveTime(TimeUnit.MILLISECONDS) : 0L;
    }

    @ManagedAttribute
    public void setOOBKeepAliveTime(long time) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getOOBMessages() {
        return this.num_oob_msgs_received;
    }

    @ManagedAttribute
    public int getOOBQueueSize() {
        return this.oob_thread_pool_queue.size();
    }

    public int getOOBMaxQueueSize() {
        return this.oob_thread_pool_queue_max_size;
    }

    @ManagedAttribute
    public int getIncomingMinPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getCorePoolSize() : 0;
    }

    @ManagedAttribute
    public void setIncomingMinPoolSize(int size) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
    }

    @ManagedAttribute
    public int getIncomingMaxPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getMaximumPoolSize() : 0;
    }

    @ManagedAttribute
    public void setIncomingMaxPoolSize(int size) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
    }

    @ManagedAttribute
    public int getIncomingPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getPoolSize() : 0;
    }

    @ManagedAttribute
    public long getIncomingKeepAliveTime() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getKeepAliveTime(TimeUnit.MILLISECONDS) : 0L;
    }

    @ManagedAttribute
    public void setIncomingKeepAliveTime(long time) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getIncomingMessages() {
        return this.num_incoming_msgs_received;
    }

    @ManagedAttribute
    public int getIncomingQueueSize() {
        return this.thread_pool_queue.size();
    }

    public int getIncomingMaxQueueSize() {
        return this.thread_pool_queue_max_size;
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    @ManagedOperation(description="Dumps the contents of the logical address cache")
    public String printLogicalAddressCache() {
        return this.logical_addr_cache.printCache(print_function);
    }

    public abstract void sendMulticast(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendUnicast(PhysicalAddress var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    @Override
    public void init() throws Exception {
        super.init();
        this.global_thread_factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
        this.timer_thread_factory = new LazyThreadFactory(Util.getGlobalThreadGroup(), "Timer", true, true);
        if (this.isSingleton()) {
            this.timer_thread_factory.setIncludeClusterName(false);
        }
        this.default_thread_factory = new DefaultThreadFactory(this.pool_thread_group, "Incoming", false, true);
        this.oob_thread_factory = new DefaultThreadFactory(this.pool_thread_group, "OOB", false, true);
        this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
        this.timer = new TimeScheduler(this.timer_thread_factory, this.num_timer_threads);
        this.verifyRejectionPolicy(this.oob_thread_pool_rejection_policy);
        this.verifyRejectionPolicy(this.thread_pool_rejection_policy);
        this.out_stream = new ExposedByteArrayOutputStream(4095);
        this.dos = new ExposedDataOutputStream(this.out_stream);
        if (this.oob_thread_pool_enabled) {
            this.oob_thread_pool_queue = this.oob_thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.oob_thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
            this.oob_thread_pool = TP.createThreadPool(this.oob_thread_pool_min_threads, this.oob_thread_pool_max_threads, this.oob_thread_pool_keep_alive_time, this.oob_thread_pool_rejection_policy, this.oob_thread_pool_queue, this.oob_thread_factory);
        } else {
            this.oob_thread_pool = new DirectExecutor();
        }
        if (this.thread_pool_enabled) {
            this.thread_pool_queue = this.thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
            this.thread_pool = TP.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.thread_pool_rejection_policy, this.thread_pool_queue, this.default_thread_factory);
        } else {
            this.thread_pool = new DirectExecutor();
        }
        if (this.bind_addr != null) {
            HashMap<String, InetAddress> m = new HashMap<String, InetAddress>(1);
            m.put("bind_addr", this.bind_addr);
            this.up(new Event(56, m));
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (InterruptedException e) {
                this.log.error("failed stopping the timer", e);
            }
        }
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.oob_thread_pool);
            this.oob_thread_pool = null;
        }
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.thread_pool);
            this.thread_pool = null;
        }
    }

    @Override
    public void start() throws Exception {
        this.fetchLocalAddresses();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.enable_diagnostics) {
            this.diag_handler = new DiagnosticsHandler();
            this.diag_handler.start();
            for (ProbeHandler handler : this.preregistered_probe_handlers) {
                this.diag_handler.registerProbeHandler(handler);
            }
            this.preregistered_probe_handlers.clear();
        }
        if (this.enable_bundling) {
            this.bundler = new Bundler();
        }
        this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
    }

    @Override
    public void stop() {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
            this.diag_handler = null;
        }
        this.preregistered_probe_handlers.clear();
    }

    protected void handleConnect() throws Exception {
        ++this.connect_count;
    }

    protected void handleDisconnect() {
        this.connect_count = Math.max(0, this.connect_count - 1);
    }

    public String getSingletonName() {
        return this.singleton_name;
    }

    public boolean isSingleton() {
        return this.singleton_name != null && this.singleton_name.length() > 0;
    }

    @Override
    public Object up(Event evt) {
        if (this.isSingleton()) {
            this.passToAllUpProtocols(evt);
            return null;
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        block11: {
            boolean multicast;
            Address dest;
            if (evt.getType() != 1) {
                return this.handleDownEvent(evt);
            }
            Message msg = (Message)evt.getArg();
            if (this.header != null) {
                msg.putHeaderIfAbsent(this.name, this.header);
            }
            if (!this.isSingleton()) {
                this.setSourceAddress(msg);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sending msg to " + msg.getDest() + ", src=" + msg.getSrc() + ", headers are " + msg.printHeaders());
            }
            if ((dest = msg.getDest()) instanceof PhysicalAddress) {
                msg.setDest(null);
            }
            boolean bl = multicast = dest == null || dest.isMulticastAddress();
            if (this.loopback && (multicast || dest.equals(msg.getSrc()))) {
                final Message copy = msg.copy();
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder("looping back message ").append(copy));
                }
                Executor pool = msg.isFlagSet((byte)1) ? this.oob_thread_pool : this.thread_pool;
                pool.execute(new Runnable(){

                    public void run() {
                        TP.this.passMessageUp(copy, false);
                    }
                });
                if (!multicast) {
                    return null;
                }
            }
            try {
                this.send(msg, dest, multicast);
            }
            catch (InterruptedException interruptedEx) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block11;
                String dst = msg.getDest() == null ? "null" : msg.getDest().toString();
                this.log.error("failed sending message to " + dst + " (" + msg.size() + " bytes)", e);
            }
        }
        return null;
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null && this.local_addr != null) {
            msg.setSrc(this.local_addr);
        }
    }

    private void passMessageUp(Message msg, boolean perform_cluster_name_matching) {
        TpHeader hdr = (TpHeader)msg.getHeader(this.name);
        if (hdr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message does not have a transport header, msg is " + msg + ", headers are " + msg.printHeaders() + ", will be discarded");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("message is ").append(msg).append(", headers are ").append(msg.printHeaders()));
        }
        String ch_name = hdr.channel_name;
        if (this.isSingleton()) {
            Protocol tmp_prot = (Protocol)this.up_prots.get(ch_name);
            if (tmp_prot != null) {
                tmp_prot.up(new Event(1, msg));
            }
        } else if (perform_cluster_name_matching && this.channel_name != null && !this.channel_name.equals(ch_name)) {
            if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                this.log.warn("discarded message from different cluster \"" + ch_name + "\" (our cluster is \"" + this.channel_name + "\"). Sender was " + msg.getSrc());
            }
        } else {
            this.up_prot.up(new Event(1, msg));
        }
    }

    protected void receive(Address sender, byte[] data, int offset, int length) {
        block5: {
            if (data == null) {
                return;
            }
            try {
                byte oob_flag = data[2];
                if ((oob_flag & 4) == 4) {
                    ++this.num_oob_msgs_received;
                    this.dispatchToThreadPool(this.oob_thread_pool, sender, data, offset, length);
                } else {
                    ++this.num_incoming_msgs_received;
                    this.dispatchToThreadPool(this.thread_pool, sender, data, offset, length);
                }
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("failed handling data from " + sender, t);
            }
        }
    }

    private void dispatchToThreadPool(Executor pool, Address sender, byte[] data, int offset, int length) {
        if (pool instanceof DirectExecutor) {
            pool.execute(new IncomingPacket(sender, data, offset, length));
        } else {
            byte[] tmp = new byte[length];
            System.arraycopy(data, offset, tmp, 0, length);
            pool.execute(new IncomingPacket(sender, tmp, 0, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message msg, Address dest, boolean multicast) throws Exception {
        if (this.enable_bundling && !msg.isFlagSet((byte)1) && (this.enable_unicast_bundling || multicast)) {
            this.bundler.send(msg, dest);
            return;
        }
        this.out_stream_lock.lock();
        try {
            this.out_stream.reset();
            this.dos.reset();
            TP.writeMessage(msg, this.dos, multicast);
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            this.doSend(buf, dest, multicast);
        }
        finally {
            this.out_stream_lock.unlock();
        }
    }

    private void doSend(Buffer buf, Address dest, boolean multicast) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.sendMulticast(buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.sendToSingleMember(dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        PhysicalAddress physical_dest;
        PhysicalAddress physicalAddress = physical_dest = dest instanceof PhysicalAddress ? (PhysicalAddress)dest : this.getPhysicalAddressFromCache(dest);
        if (physical_dest == null) {
            if (System.currentTimeMillis() - this.last_who_has_request >= 5000L) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("no physical address for " + dest + ", dropping message");
                }
                this.up_prot.up(new Event(87, dest));
                this.last_who_has_request = System.currentTimeMillis();
            }
            return;
        }
        this.sendUnicast(physical_dest, buf, offset, length);
    }

    protected void sendToAllPhysicalAddresses(byte[] buf, int offset, int length) throws Exception {
        HashSet<PhysicalAddress> dests = new HashSet<PhysicalAddress>(this.logical_addr_cache.values());
        for (PhysicalAddress dest : dests) {
            this.sendUnicast(dest, buf, offset, length);
        }
    }

    private static void writeMessage(Message msg, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        if (msg.isFlagSet((byte)1)) {
            flags = (byte)(flags + 4);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    private static Message readMessage(DataInputStream instream) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        return msg;
    }

    private static void writeMessageList(List<Message> msgs, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        int len = msgs != null ? msgs.size() : 0;
        dos.writeShort(Version.version);
        flags = (byte)(flags + 1);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        dos.writeInt(len);
        if (msgs != null) {
            for (Message msg : msgs) {
                msg.writeTo(dos);
            }
        }
    }

    private static List<Message> readMessageList(DataInputStream instream) throws Exception {
        int len = instream.readInt();
        ArrayList<Message> list = new ArrayList<Message>(len);
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(instream);
            list.add(msg);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Set<Address> set = this.members;
                synchronized (set) {
                    View view = (View)evt.getArg();
                    HashSet<Address> old_mbrs = new HashSet<Address>(this.members);
                    this.members.clear();
                    if (!this.isSingleton()) {
                        Vector<Address> tmpvec = view.getMembers();
                        this.members.addAll(tmpvec);
                    } else {
                        for (Protocol prot : this.up_prots.values()) {
                            if (!(prot instanceof ProtocolAdapter)) continue;
                            ProtocolAdapter ad = (ProtocolAdapter)prot;
                            Set<Address> tmp = ad.getMembers();
                            this.members.addAll(tmp);
                        }
                    }
                }
                this.logical_addr_cache.retainAll(this.members);
                UUID.retainAll(this.members);
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.channel_name = (String)evt.getArg();
                this.header = new TpHeader(this.channel_name);
                this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
                this.setThreadNames();
                this.connectLock.lock();
                try {
                    this.handleConnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.connectLock.unlock();
                }
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                this.connectLock.lock();
                try {
                    this.handleDisconnect();
                    break;
                }
                finally {
                    this.connectLock.unlock();
                }
            }
            case 87: {
                return this.getPhysicalAddressFromCache((UUID)evt.getArg());
            }
            case 88: {
                return this.logical_addr_cache.contents();
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                this.addPhysicalAddressToCache((Address)tuple.getVal1(), (PhysicalAddress)tuple.getVal2());
                break;
            }
            case 90: {
                this.removeLogicalAddressFromCache((UUID)evt.getArg());
                break;
            }
            case 8: {
                if (!this.isSingleton()) {
                    this.local_addr = (Address)evt.getArg();
                }
                this.registerLocalAddress((Address)evt.getArg());
            }
        }
        return null;
    }

    protected void registerLocalAddress(Address addr) {
        PhysicalAddress physical_addr = this.getPhysicalAddress();
        if (physical_addr != null && addr != null) {
            this.addPhysicalAddressToCache(addr, physical_addr);
        }
    }

    protected void fetchLocalAddresses() {
        if (!this.isSingleton()) {
            if (this.local_addr != null) {
                this.registerLocalAddress(this.local_addr);
            } else {
                Address addr;
                this.local_addr = addr = (Address)this.up_prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        } else {
            for (Protocol prot : this.up_prots.values()) {
                Address addr = (Address)prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        }
    }

    protected void setThreadNames() {
        if (this.diag_handler != null) {
            this.global_thread_factory.renameThread("DiagnosticsHandler", this.diag_handler.getThread());
        }
    }

    protected void unsetThreadNames() {
        if (this.diag_handler != null && this.diag_handler.getThread() != null) {
            this.diag_handler.getThread().setName("DiagnosticsHandler");
        }
    }

    private void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories = new ThreadFactory[]{this.timer_thread_factory, this.default_thread_factory, this.oob_thread_factory, this.global_thread_factory};
        boolean is_shared_transport = this.isSingleton();
        for (ThreadFactory factory : factories) {
            if (pattern != null) {
                factory.setPattern(pattern);
                if (is_shared_transport) {
                    factory.setIncludeClusterName(false);
                }
            }
            if (cluster_name != null && !is_shared_transport) {
                factory.setClusterName(cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadManagerThreadPoolExecutor pool = new ThreadManagerThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue);
        pool.setThreadFactory(factory);
        RejectedExecutionHandler handler = new ThreadPoolExecutor.CallerRunsPolicy();
        if (rejection_policy != null) {
            if (rejection_policy.equals("abort")) {
                handler = new ThreadPoolExecutor.AbortPolicy();
            } else if (rejection_policy.equals("discard")) {
                handler = new ThreadPoolExecutor.DiscardPolicy();
            } else if (rejection_policy.equals("discardoldest")) {
                handler = new ThreadPoolExecutor.DiscardOldestPolicy();
            }
        }
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }

    private static void shutdownThreadPool(Executor thread_pool) {
        if (thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void verifyRejectionPolicy(String str) throws Exception {
        if (!(str.equalsIgnoreCase("run") || str.equalsIgnoreCase("abort") || str.equalsIgnoreCase("discard") || str.equalsIgnoreCase("discardoldest"))) {
            this.log.error("rejection policy of " + str + " is unknown");
            throw new Exception("Unknown rejection policy " + str);
        }
    }

    protected void passToAllUpProtocols(Event evt) {
        for (Protocol prot : this.up_prots.values()) {
            try {
                prot.up(evt);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed passing up event " + evt, e);
            }
        }
    }

    protected void addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        if (logical_addr != null && physical_addr != null) {
            this.logical_addr_cache.add(logical_addr, physical_addr);
        }
    }

    protected PhysicalAddress getPhysicalAddressFromCache(Address logical_addr) {
        return logical_addr != null ? this.logical_addr_cache.get(logical_addr) : null;
    }

    protected void removeLogicalAddressFromCache(Address logical_addr) {
        if (logical_addr != null) {
            this.logical_addr_cache.remove(logical_addr);
        }
    }

    public void clearLogicalAddressCache() {
        this.logical_addr_cache.clear(true);
    }

    protected abstract PhysicalAddress getPhysicalAddress();

    static /* synthetic */ Log access$300(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$400(TP x0) {
        return x0.log;
    }

    static /* synthetic */ List access$500(DataInputStream x0) throws Exception {
        return TP.readMessageList(x0);
    }

    static /* synthetic */ Log access$600(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Message access$700(DataInputStream x0) throws Exception {
        return TP.readMessage(x0);
    }

    static /* synthetic */ Log access$800(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$900(TP x0) {
        return x0.log;
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
        print_function = new LazyRemovalCache.Printable<Address, PhysicalAddress>(){

            @Override
            public String print(Address logical_addr, PhysicalAddress physical_addr) {
                StringBuilder sb = new StringBuilder();
                String tmp_logical_name = UUID.get(logical_addr);
                if (tmp_logical_name != null) {
                    sb.append(tmp_logical_name).append(": ");
                }
                sb.append(((UUID)logical_addr).toStringLong()).append(": ").append(physical_addr).append("\n");
                return sb.toString();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProtocolAdapter
    extends Protocol
    implements ProbeHandler {
        String cluster_name;
        final String transport_name;
        TpHeader header;
        final Set<Address> members = new CopyOnWriteArraySet<Address>();
        final ThreadFactory factory;
        Address local_addr;

        public ProtocolAdapter(String cluster_name, Address local_addr, String transport_name, Protocol up, Protocol down, String pattern) {
            this.cluster_name = cluster_name;
            this.local_addr = local_addr;
            this.transport_name = transport_name;
            this.up_prot = up;
            this.down_prot = down;
            this.header = new TpHeader(cluster_name);
            this.factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
            this.factory.setPattern(pattern);
            if (local_addr != null) {
                this.factory.setAddress(local_addr.toString());
            }
            if (cluster_name != null) {
                this.factory.setClusterName(cluster_name);
            }
        }

        @ManagedAttribute(description="Name of the cluster to which this adapter proxies")
        public String getClusterName() {
            return this.cluster_name;
        }

        public Address getAddress() {
            return this.local_addr;
        }

        @ManagedAttribute(name="Address", description="local address")
        public String getAddressAsString() {
            return this.local_addr != null ? this.local_addr.toString() : null;
        }

        @ManagedAttribute(name="AddressUUID", description="local address")
        public String getAddressAsUUID() {
            return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
        }

        @ManagedAttribute(description="Name of the transport")
        public String getTransportName() {
            return this.transport_name;
        }

        public Set<Address> getMembers() {
            return Collections.unmodifiableSet(this.members);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.factory;
        }

        @Override
        public void start() throws Exception {
            TP transport = this.getTransport();
            if (transport != null) {
                transport.registerProbeHandler(this);
            }
        }

        @Override
        public void stop() {
            TP transport = this.getTransport();
            if (transport != null) {
                transport.unregisterProbeHandler(this);
            }
        }

        @Override
        public Object down(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    msg.putHeader(this.transport_name, this.header);
                    if (msg.getSrc() != null) break;
                    msg.setSrc(this.local_addr);
                    break;
                }
                case 6: {
                    View view = (View)evt.getArg();
                    Vector<Address> tmp = view.getMembers();
                    this.members.clear();
                    this.members.addAll(tmp);
                    break;
                }
                case 2: 
                case 80: 
                case 92: 
                case 93: {
                    this.cluster_name = (String)evt.getArg();
                    this.factory.setClusterName(this.cluster_name);
                    this.header = new TpHeader(this.cluster_name);
                    break;
                }
                case 8: {
                    Address addr = (Address)evt.getArg();
                    if (addr == null) break;
                    this.local_addr = addr;
                    this.factory.setAddress(addr.toString());
                }
            }
            return this.down_prot.down(evt);
        }

        @Override
        public String getName() {
            return "TP.ProtocolAdapter";
        }

        public String toString() {
            return this.cluster_name + " (" + this.transport_name + ")";
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> retval = new HashMap<String, String>();
            retval.put("cluster", this.cluster_name);
            retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
            retval.put("local_addr (UUID)", this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null);
            retval.put("transport_name", this.transport_name);
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiagnosticsHandler
    implements Runnable {
        public static final String THREAD_NAME = "DiagnosticsHandler";
        private Thread thread = null;
        private MulticastSocket diag_sock = null;
        private final Set<ProbeHandler> handlers = new HashSet<ProbeHandler>();

        DiagnosticsHandler() {
        }

        Thread getThread() {
            return this.thread;
        }

        void registerProbeHandler(ProbeHandler handler) {
            if (handler != null) {
                this.handlers.add(handler);
            }
        }

        void unregisterProbeHandler(ProbeHandler handler) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }

        void start() throws IOException {
            this.registerProbeHandler(new ProbeHandler(){

                @Override
                public Map<String, String> handleProbe(String ... keys) {
                    HashMap<String, String> retval = new HashMap<String, String>(2);
                    for (String key : keys) {
                        if (key.equals("dump")) {
                            retval.put("dump", Util.dumpThreads());
                            continue;
                        }
                        if (key.equals("uuids")) {
                            retval.put("uuids", TP.this.printLogicalAddressCache());
                            if (TP.this.isSingleton() || retval.containsKey("local_addr")) continue;
                            retval.put("local_addr", TP.this.local_addr != null ? TP.this.local_addr.toString() : null);
                            continue;
                        }
                        if (key.equals("keys")) {
                            StringBuilder sb = new StringBuilder();
                            for (ProbeHandler handler : DiagnosticsHandler.this.handlers) {
                                String[] tmp = handler.supportedKeys();
                                if (tmp == null || tmp.length <= 0) continue;
                                for (String s : tmp) {
                                    sb.append(s).append(" ");
                                }
                            }
                            retval.put("keys", sb.toString());
                        }
                        if (!key.equals("info") || TP.this.singleton_name == null || TP.this.singleton_name.length() <= 0) continue;
                        retval.put("singleton_name", TP.this.singleton_name);
                    }
                    return retval;
                }

                @Override
                public String[] supportedKeys() {
                    return new String[]{"dump", "keys", "uuids", "info"};
                }
            });
            this.diag_sock = new MulticastSocket(TP.this.diagnostics_port);
            List<NetworkInterface> interfaces = Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.diag_sock);
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = TP.this.global_thread_factory.newThread(this, THREAD_NAME);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        void stop() {
            if (this.diag_sock != null) {
                this.diag_sock.close();
            }
            this.handlers.clear();
            if (this.thread != null) {
                try {
                    this.thread.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            byte[] buf = new byte[1500];
            while (!this.diag_sock.isClosed() && Thread.currentThread().equals(this.thread)) {
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                try {
                    this.diag_sock.receive(packet);
                    this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset(), packet.getLength()));
                }
                catch (IOException iOException) {}
            }
        }

        private void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
            StringTokenizer tok = new StringTokenizer(request);
            ArrayList<String> list = new ArrayList<String>(10);
            while (tok.hasMoreTokens()) {
                String req = tok.nextToken().trim();
                if (req.length() <= 0) continue;
                list.add(req);
            }
            String[] tokens = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                tokens[i] = (String)list.get(i);
            }
            for (ProbeHandler handler : this.handlers) {
                Map<String, String> map = handler.handleProbe(tokens);
                if (map == null || map.isEmpty()) continue;
                if (!map.containsKey("cluster")) {
                    map.put("cluster", TP.this.channel_name != null ? TP.this.channel_name : "n/a");
                }
                StringBuilder info = new StringBuilder();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    info.append(entry.getKey()).append("=").append(entry.getValue()).append("\r\n");
                }
                byte[] diag_rsp = info.toString().getBytes();
                if (TP.this.log.isDebugEnabled()) {
                    TP.this.log.debug("sending diag response to " + sender);
                }
                try {
                    this.sendResponse(sock, sender, diag_rsp);
                }
                catch (Throwable t) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error("failed sending diag rsp to " + sender, t);
                }
            }
        }

        private void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) throws IOException {
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
            sock.send(p);
        }

        private void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s) {
            InetSocketAddress group_addr = new InetSocketAddress(TP.this.diagnostics_addr, TP.this.diagnostics_port);
            for (NetworkInterface i : interfaces) {
                try {
                    if (!i.getInetAddresses().hasMoreElements()) continue;
                    s.joinGroup(group_addr, i);
                    if (!TP.this.log.isTraceEnabled()) continue;
                    TP.this.log.trace("joined " + group_addr + " on " + i.getName());
                }
                catch (IOException e) {
                    TP.this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProbeHandler {
        public Map<String, String> handleProbe(String ... var1);

        public String[] supportedKeys();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bundler {
        static final int MIN_NUMBER_OF_BUNDLING_TASKS = 2;
        final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(36);
        long count = 0L;
        int num_msgs = 0;
        int num_bundling_tasks = 0;
        long last_bundle_time;
        final ReentrantLock lock = new ReentrantLock();
        final ExposedByteArrayOutputStream bundler_out_stream = new ExposedByteArrayOutputStream(4095);
        final ExposedDataOutputStream bundler_dos = new ExposedDataOutputStream(this.bundler_out_stream);

        private Bundler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(Message msg, Address dest) throws Exception {
            long length = msg.size();
            this.checkLength(length);
            this.lock.lock();
            try {
                if (this.count + length >= (long)TP.this.max_bundle_size && !this.msgs.isEmpty()) {
                    this.sendBundledMessages(this.msgs);
                }
                this.addMessage(msg, dest);
                this.count += length;
                if (this.num_bundling_tasks < 2) {
                    ++this.num_bundling_tasks;
                    TP.this.timer.schedule(new BundlingTimer(), TP.this.max_bundle_timeout, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void addMessage(Message msg, Address dest) {
            List<Message> tmp;
            if (this.msgs.isEmpty()) {
                this.last_bundle_time = System.currentTimeMillis();
            }
            if ((tmp = this.msgs.get(dest)) == null) {
                tmp = new LinkedList<Message>();
                this.msgs.put(dest, tmp);
            }
            tmp.add(msg);
            ++this.num_msgs;
        }

        private void sendBundledMessages(Map<Address, List<Message>> msgs) {
            if (TP.this.log.isTraceEnabled()) {
                long stop = System.currentTimeMillis();
                double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                StringBuilder sb = new StringBuilder("sending ").append(this.num_msgs).append(" msgs (");
                this.num_msgs = 0;
                sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size)");
                if (this.last_bundle_time > 0L) {
                    sb.append(", collected in ").append(stop - this.last_bundle_time).append("ms) ");
                }
                sb.append(" to ").append(msgs.size()).append(" destination(s)");
                if (msgs.size() > 1) {
                    sb.append(" (dests=").append(msgs.keySet()).append(")");
                }
                TP.this.log.trace(sb);
            }
            for (Map.Entry<Address, List<Message>> entry : msgs.entrySet()) {
                List<Message> list = entry.getValue();
                if (list.isEmpty()) continue;
                Address dst = entry.getKey();
                boolean multicast = dst == null || dst.isMulticastAddress();
                try {
                    this.bundler_out_stream.reset();
                    this.bundler_dos.reset();
                    TP.writeMessageList(list, this.bundler_dos, multicast);
                    Buffer buffer = new Buffer(this.bundler_out_stream.getRawBuffer(), 0, this.bundler_out_stream.size());
                    TP.this.doSend(buffer, dst, multicast);
                }
                catch (Throwable e) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error("exception sending msg: " + e.toString(), e);
                }
            }
            msgs.clear();
            this.count = 0L;
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private class BundlingTimer
        implements Runnable {
            private BundlingTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Bundler.this.lock.lock();
                try {
                    if (!Bundler.this.msgs.isEmpty()) {
                        Bundler.this.sendBundledMessages(Bundler.this.msgs);
                    }
                }
                finally {
                    --Bundler.this.num_bundling_tasks;
                    Bundler.this.lock.unlock();
                }
            }
        }
    }

    class IncomingPacket
    implements Runnable {
        final Address sender;
        final byte[] buf;
        final int offset;
        final int length;

        IncomingPacket(Address sender, byte[] buf, int offset, int length) {
            this.sender = sender;
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleMyMessage(Message msg, boolean multicast) {
            if (TP.this.stats) {
                ++TP.this.num_msgs_received;
                TP.this.num_bytes_received += (long)msg.getLength();
            }
            if (TP.this.loopback && multicast && msg.isFlagSet((byte)8)) {
                return;
            }
            TP.this.passMessageUp(msg, true);
        }
    }
}

