/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class GossipRouter {
    public static final byte EOF = -1;
    public static final byte CONNECT = 1;
    public static final byte DISCONNECT = 2;
    public static final byte GOSSIP_GET = 4;
    public static final byte SHUTDOWN = 9;
    public static final byte MESSAGE = 10;
    public static final byte SUSPECT = 11;
    public static final int PORT = 12001;
    public static final long EXPIRY_TIME = 30000L;
    public static final long GOSSIP_REQUEST_TIMEOUT = 1000L;
    public static final long ROUTING_CLIENT_REPLY_TIMEOUT = 120000L;
    @ManagedAttribute(description="server port on which the GossipRouter accepts client connections", writable=true)
    private int port;
    @ManagedAttribute(description="address to which the GossipRouter should bind", writable=true, name="bindAddress")
    private String bindAddressString;
    @ManagedAttribute(description="time (in msecs) until a cached 'gossip' member entry expires", writable=true)
    private long expiryTime = 30000L;
    @ManagedAttribute(description="number of millisecs the main thread waits to receive a gossip request after connection was established; upon expiration, the router initiates the routing protocol on the connection. Don't set the interval too big, otherwise the router will appear slow in answering routing requests.", writable=true)
    private long gossipRequestTimeout;
    @ManagedAttribute(description="time (in ms) main thread waits for a router client to send the routing request type and the group afiliation before it declares the request failed.", writable=true)
    private long routingClientReplyTimeout;
    private final ConcurrentMap<String, ConcurrentMap<Address, RoutingEntry>> routingTable = new ConcurrentHashMap<String, ConcurrentMap<Address, RoutingEntry>>();
    private ServerSocket srvSock = null;
    private InetAddress bindAddress = null;
    @Property(description="Time (in millis) for setting SO_LINGER on sockets returned from accept(). 0 means do not set SO_LINGER")
    private long linger_timeout = 2000L;
    @Property(description="Time (in millis) for SO_TIMEOUT on sockets returned from accept(). 0 means don't set SO_TIMEOUT")
    private long sock_read_timeout = 5000L;
    @Property(description="The max queue size of backlogged connections")
    private int backlog = 1000;
    @ManagedAttribute(description="operational status", name="running")
    private boolean up = false;
    @ManagedAttribute(description="whether to discard message sent to self", writable=true)
    private boolean discard_loopbacks = false;
    protected List<ConnectionTearListener> connectionTearListeners = new CopyOnWriteArrayList<ConnectionTearListener>();
    protected ThreadFactory default_thread_factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "gossip-handlers", true, true);
    protected Timer timer = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean jmx = false;
    private boolean registered = false;

    public GossipRouter() {
        this(12001);
    }

    public GossipRouter(int port) {
        this(port, null);
    }

    public GossipRouter(int port, String bindAddressString) {
        this(port, bindAddressString, 30000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime) {
        this(port, bindAddressString, expiryTime, 1000L, 120000L);
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime, long gossipRequestTimeout, long routingClientReplyTimeout) {
        this.port = port;
        this.bindAddressString = bindAddressString;
        this.expiryTime = expiryTime;
        this.gossipRequestTimeout = gossipRequestTimeout;
        this.routingClientReplyTimeout = routingClientReplyTimeout;
        this.connectionTearListeners.add(new FailureDetectionListener());
    }

    public GossipRouter(int port, String bindAddressString, long expiryTime, long gossipRequestTimeout, long routingClientReplyTimeout, boolean jmx) {
        this(port, bindAddressString, expiryTime, gossipRequestTimeout, routingClientReplyTimeout);
        this.jmx = jmx;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddressString = bindAddress;
    }

    public String getBindAddress() {
        return this.bindAddressString;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setGossipRequestTimeout(long gossipRequestTimeout) {
        this.gossipRequestTimeout = gossipRequestTimeout;
    }

    public long getGossipRequestTimeout() {
        return this.gossipRequestTimeout;
    }

    public void setRoutingClientReplyTimeout(long routingClientReplyTimeout) {
        this.routingClientReplyTimeout = routingClientReplyTimeout;
    }

    public long getRoutingClientReplyTimeout() {
        return this.routingClientReplyTimeout;
    }

    @ManagedAttribute(description="status")
    public boolean isStarted() {
        return this.srvSock != null;
    }

    public boolean isDiscardLoopbacks() {
        return this.discard_loopbacks;
    }

    public void setDiscardLoopbacks(boolean discard_loopbacks) {
        this.discard_loopbacks = discard_loopbacks;
    }

    public long getLingerTimeout() {
        return this.linger_timeout;
    }

    public void setLingerTimeout(long linger_timeout) {
        this.linger_timeout = linger_timeout;
    }

    public long getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(long sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public ThreadFactory getDefaultThreadPoolThreadFactory() {
        return this.default_thread_factory;
    }

    public static String type2String(int type) {
        switch (type) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "DISCONNECT";
            }
            case 4: {
                return "GOSSIP_GET";
            }
            case 9: {
                return "SHUTDOWN";
            }
        }
        return "unknown";
    }

    public void create() throws Exception {
    }

    @ManagedOperation(description="Lifecycle operation. Called after create(). When this method is called, the managed attributes have already been set. Brings the Router into a fully functional state.")
    public void start() throws Exception {
        if (this.srvSock != null) {
            throw new Exception("Router already started.");
        }
        if (this.jmx && !this.registered) {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.register(this, server, "jgroups:name=GossipRouter");
            this.registered = true;
        }
        if (this.bindAddressString != null) {
            this.bindAddress = InetAddress.getByName(this.bindAddressString);
            this.srvSock = new ServerSocket(this.port, this.backlog, this.bindAddress);
        } else {
            this.srvSock = new ServerSocket(this.port, this.backlog);
        }
        this.up = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GossipRouter.this.cleanup();
                GossipRouter.this.stop();
            }
        });
        new Thread(new Runnable(){

            public void run() {
                GossipRouter.this.mainLoop();
                GossipRouter.this.cleanup();
            }
        }, "GossipRouter").start();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                GossipRouter.this.sweep();
            }
        }, this.expiryTime, this.expiryTime);
    }

    @ManagedOperation(description="Always called before destroy(). Closes connections and frees resources")
    public void stop() {
        this.up = false;
        this.timer.cancel();
        if (this.srvSock != null) {
            this.shutdown();
            Util.close(this.srvSock);
            this.srvSock = null;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("router stopped");
        }
    }

    public void destroy() {
    }

    @ManagedOperation(description="dumps the contents of the routing table")
    public String dumpRoutingTable() {
        String label = "routing";
        StringBuilder sb = new StringBuilder();
        if (this.routingTable.isEmpty()) {
            sb.append("empty ").append(label).append(" table");
        } else {
            Iterator i = this.routingTable.keySet().iterator();
            while (i.hasNext()) {
                String gname = (String)i.next();
                sb.append("GROUP: '" + gname + "'\n");
                Map map = (Map)this.routingTable.get(gname);
                if (map == null) {
                    sb.append("\tnull list of addresses\n");
                    continue;
                }
                if (map.isEmpty()) {
                    sb.append("\tempty list of addresses\n");
                    continue;
                }
                Iterator j = map.values().iterator();
                while (j.hasNext()) {
                    sb.append('\t').append((String)i.next()).append('\n');
                }
            }
        }
        return sb.toString();
    }

    private void mainLoop() {
        if (this.bindAddress == null) {
            this.bindAddress = this.srvSock.getInetAddress();
        }
        this.printStartupInfo();
        block9: while (this.up && this.srvSock != null) {
            try {
                Socket sock = this.srvSock.accept();
                if (this.linger_timeout > 0L) {
                    int linger = Math.max(1, (int)(this.linger_timeout / 1000L));
                    sock.setSoLinger(true, linger);
                }
                if (this.sock_read_timeout > 0L) {
                    sock.setSoTimeout((int)this.sock_read_timeout);
                }
                DataInputStream input = new DataInputStream(sock.getInputStream());
                OutputStream output = null;
                IpAddress peer_addr = null;
                GossipData req = new GossipData();
                try {
                    req.readFrom(input);
                    switch (req.getType()) {
                        case 1: {
                            peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                            Address logical_addr = req.getAddress();
                            String group_name = req.getGroup();
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("CONNECT(" + group_name + ", " + logical_addr + ")");
                            }
                            ConnectionHandler ch = new ConnectionHandler(sock, group_name, logical_addr);
                            this.addEntry(group_name, logical_addr, new RoutingEntry(logical_addr, peer_addr, ch));
                            this.getDefaultThreadPoolThreadFactory().newThread(ch).start();
                            break;
                        }
                        case 9: {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("router shutting down");
                            }
                            Util.close(input);
                            Util.close(output);
                            Util.close(sock);
                            this.up = false;
                            break;
                        }
                        default: {
                            if (!this.log.isWarnEnabled()) continue block9;
                            this.log.warn("received unkown gossip request (gossip=" + req + ')');
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.up && this.log.isErrorEnabled()) {
                        this.log.error("failure handling a client request", e);
                    }
                    Util.close(input);
                    Util.close(output);
                    Util.close(sock);
                }
            }
            catch (SocketException se) {
                if (this.srvSock == null || !this.srvSock.isClosed()) continue;
                this.log.warn("Server socket closing");
            }
            catch (Exception exc) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failure receiving and setting up a client request", exc);
            }
        }
    }

    private void cleanup() {
        for (ConcurrentMap map : this.routingTable.values()) {
            if (map == null) continue;
            for (RoutingEntry entry : map.values()) {
                entry.destroy();
            }
        }
        this.routingTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        block6: {
            Socket s = null;
            DataOutputStream dos = null;
            try {
                s = new Socket(this.srvSock.getInetAddress(), this.srvSock.getLocalPort());
                dos = new DataOutputStream(s.getOutputStream());
                dos.writeInt(9);
                dos.writeUTF("");
                Util.close(s);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("shutdown failed: " + e);
                }
                break block6;
            }
            finally {
                Util.close(s);
                Util.close(dos);
            }
            Util.close(dos);
        }
    }

    private void sweep() {
        long currentTime = System.currentTimeMillis();
        int num_entries_removed = 0;
        Iterator it = this.routingTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Map map = (Map)entry.getValue();
            if (map == null || map.isEmpty()) {
                it.remove();
                continue;
            }
            Iterator it2 = map.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                RoutingEntry ae = (RoutingEntry)entry2.getValue();
                long diff = currentTime - ae.timestamp;
                if (diff <= this.expiryTime) continue;
                it2.remove();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removed " + ae.logical_addr + " (" + diff + " msecs old)");
                }
                ++num_entries_removed;
            }
        }
        if (num_entries_removed > 0 && this.log.isTraceEnabled()) {
            this.log.trace("done (removed " + num_entries_removed + " entries)");
        }
    }

    private void route(Address dest, String dest_group, byte[] msg, Address sender) {
        if (dest == null) {
            if (dest_group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("both dest address and group are null");
                }
            } else {
                this.sendToAllMembersInGroup(dest_group, msg, sender);
            }
        } else {
            RoutingEntry ae = this.findAddressEntry(dest_group, dest);
            if (ae == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("cannot find " + dest + " in the routing table, \nrouting table=\n" + this.dumpRoutingTable());
                }
                return;
            }
            if (ae.getOutputStream() == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(dest + " is associated with a null output stream");
                }
                return;
            }
            try {
                this.sendToMember(dest, ae.getOutputStream(), msg, sender);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed sending message to " + dest + ": " + e.getMessage());
                }
                this.removeEntry(dest_group, dest);
            }
        }
    }

    private void addEntry(String groupname, Address logical_addr, RoutingEntry entry) {
        this.addEntry(groupname, logical_addr, entry, false);
    }

    private void addEntry(String groupname, Address logical_addr, RoutingEntry entry, boolean update_only) {
        if (groupname == null || logical_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("groupname or logical_addr was null, entry was not added");
            }
            return;
        }
        ConcurrentHashMap<Address, RoutingEntry> mbrs = (ConcurrentHashMap<Address, RoutingEntry>)this.routingTable.get(groupname);
        if (mbrs == null) {
            mbrs = new ConcurrentHashMap<Address, RoutingEntry>();
            mbrs.put(logical_addr, entry);
            this.routingTable.putIfAbsent(groupname, mbrs);
        } else {
            RoutingEntry tmp = (RoutingEntry)mbrs.get(logical_addr);
            if (tmp != null) {
                if (update_only) {
                    tmp.update();
                    return;
                }
                tmp.destroy();
            }
            mbrs.put(logical_addr, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(String groupname, Address logical_addr) {
        Map val = (Map)this.routingTable.get(groupname);
        if (val == null) {
            return;
        }
        Map map = val;
        synchronized (map) {
            RoutingEntry entry = (RoutingEntry)val.get(logical_addr);
            if (entry != null) {
                entry.destroy();
                val.remove(logical_addr);
            }
        }
    }

    private RoutingEntry findAddressEntry(String group_name, Address logical_addr) {
        if (group_name == null || logical_addr == null) {
            return null;
        }
        Map val = (Map)this.routingTable.get(group_name);
        if (val == null) {
            return null;
        }
        return (RoutingEntry)val.get(logical_addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToAllMembersInGroup(String groupname, byte[] msg, Address sender) {
        Map val = (Map)this.routingTable.get(groupname);
        if (val == null || val.isEmpty()) {
            return;
        }
        Map map = val;
        synchronized (map) {
            Iterator i = val.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry tmp = i.next();
                RoutingEntry entry = (RoutingEntry)tmp.getValue();
                DataOutputStream dos = entry.getOutputStream();
                if (dos == null) continue;
                try {
                    this.sendToMember(null, dos, msg, sender);
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("cannot send to " + entry.logical_addr + ": " + e.getMessage());
                    }
                    entry.destroy();
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToMember(Address dest, DataOutputStream out, byte[] msg, Address sender) throws IOException {
        if (out == null) {
            return;
        }
        if (this.discard_loopbacks && dest != null && dest.equals(sender)) {
            return;
        }
        DataOutputStream dataOutputStream = out;
        synchronized (dataOutputStream) {
            out.writeByte(10);
            Util.writeAddress(dest, out);
            out.writeInt(msg.length);
            out.write(msg, 0, msg.length);
            out.flush();
        }
    }

    private void notifyAbnormalConnectionTear(final ConnectionHandler ch, final Exception e) {
        Thread thread = this.getDefaultThreadPoolThreadFactory().newThread(new Runnable(){

            public void run() {
                for (ConnectionTearListener l : GossipRouter.this.connectionTearListeners) {
                    l.connectionTorn(ch, e);
                }
            }
        }, "notifyAbnormalConnectionTear");
        thread.start();
    }

    private void printStartupInfo() {
        System.out.println("GossipRouter started at " + new Date());
        System.out.print("Listening on port " + this.port);
        System.out.println(" bound on address " + this.bindAddress);
        System.out.print("Backlog is " + this.backlog);
        System.out.print(", linger timeout is " + this.linger_timeout);
        System.out.println(", and read timeout is " + this.sock_read_timeout);
    }

    public static void main(String[] args) throws Exception {
        int port = 12001;
        long expiry = 30000L;
        long timeout = 1000L;
        long routingTimeout = 120000L;
        int backlog = 0;
        long soLinger = -1L;
        long soTimeout = -1L;
        GossipRouter router = null;
        String bind_addr = null;
        boolean jmx = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg) || "-bind_addr".equals(arg)) {
                bind_addr = args[++i];
                continue;
            }
            if ("-backlog".equals(arg)) {
                backlog = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-jmx".equals(arg)) {
                jmx = true;
                continue;
            }
            if ("-timeout".equals(arg)) {
                System.out.println("    -timeout is depracted and will be ignored");
                ++i;
                continue;
            }
            if ("-rtimeout".equals(arg)) {
                System.out.println("    -rtimeout is depracted and will be ignored");
                ++i;
                continue;
            }
            if ("-solinger".equals(arg)) {
                soLinger = Long.parseLong(args[++i]);
                continue;
            }
            if ("-sotimeout".equals(arg)) {
                soTimeout = Long.parseLong(args[++i]);
                continue;
            }
            GossipRouter.help();
            return;
        }
        System.out.println("GossipRouter is starting. Enter quit to exit JVM");
        try {
            router = new GossipRouter(port, bind_addr, expiry, timeout, routingTimeout, jmx);
            if (backlog > 0) {
                router.setBacklog(backlog);
            }
            if (soTimeout >= 0L) {
                router.setSocketReadTimeout(soTimeout);
            }
            if (soLinger >= 0L) {
                router.setLingerTimeout(soLinger);
            }
            router.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String quit = "";
        while (!quit.startsWith("quit")) {
            Scanner in = new Scanner(System.in);
            try {
                quit = in.nextLine();
            }
            catch (Exception e) {}
        }
        router.stop();
        router.cleanup();
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bind_addr <address>] [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        System.out.println("    -backlog <backlog>    - Max queue size of backlogged connections. Must be");
        System.out.println("                            greater than zero or the default of 1000 will be");
        System.out.println("                            used.");
        System.out.println();
        System.out.println("    -expiry <msecs>       - Time until a gossip cache entry expires. 30000 is");
        System.out.println("                            the default value.");
        System.out.println();
        System.out.println("    -jmx                  - Expose attributes and operations via JMX.");
        System.out.println();
        System.out.println("    -solinger <msecs>     - Time for setting SO_LINGER on connections. 0");
        System.out.println("                            means do not set SO_LINGER. Must be greater than");
        System.out.println("                            or equal to zero or the default of 2000 will be");
        System.out.println("                            used.");
        System.out.println();
        System.out.println("    -sotimeout <msecs>    - Time for setting SO_TIMEOUT on connections. 0");
        System.out.println("                            means don't set SO_TIMEOUT. Must be greater than");
        System.out.println("                            or equal to zero or the default of 3000 will be");
        System.out.println("                            used.");
        System.out.println();
    }

    class ConnectionHandler
    implements Runnable {
        private volatile boolean active = true;
        private final Socket sock;
        private final DataOutputStream output;
        private final DataInputStream input;
        private final Address logical_addr;
        private final String group_name;

        public ConnectionHandler(Socket sock, String group_name, Address logical_addr) throws IOException {
            this.sock = sock;
            this.input = new DataInputStream(sock.getInputStream());
            this.output = new DataOutputStream(sock.getOutputStream());
            this.group_name = group_name;
            this.logical_addr = logical_addr;
        }

        void close() {
            this.active = false;
            Util.close(this.input);
            Util.close(this.output);
            Util.close(this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.output.writeBoolean(true);
                this.readLoop();
            }
            catch (IOException e1) {
                try {
                    this.output.writeBoolean(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.close();
            }
        }

        private void readLoop() {
            while (this.active) {
                try {
                    byte command = this.input.readByte();
                    switch (command) {
                        case 10: {
                            String gname = this.input.readUTF();
                            Address dst_addr = Util.readAddress(this.input);
                            int len = this.input.readInt();
                            if (len == 0) {
                                if (!GossipRouter.this.log.isWarnEnabled()) break;
                                GossipRouter.this.log.warn("received null message");
                                break;
                            }
                            byte[] buf = new byte[len];
                            this.input.readFully(buf, 0, buf.length);
                            try {
                                GossipRouter.this.route(dst_addr, gname, buf, this.logical_addr);
                            }
                            catch (Exception e) {
                                if (!GossipRouter.this.log.isErrorEnabled()) break;
                                GossipRouter.this.log.error("failed routing request to " + dst_addr, e);
                            }
                            break;
                        }
                        case 4: {
                            String group = this.input.readUTF();
                            LinkedList mbrs = null;
                            Map map = (Map)GossipRouter.this.routingTable.get(group);
                            if (map != null) {
                                mbrs = new LinkedList(map.keySet());
                            }
                            DataOutputStream rsp = new DataOutputStream(this.sock.getOutputStream());
                            Util.writeAddresses(mbrs, rsp);
                            break;
                        }
                        case 2: {
                            GossipRouter.this.removeEntry(this.group_name, this.logical_addr);
                            this.close();
                            break;
                        }
                        case -1: {
                            GossipRouter.this.notifyAbnormalConnectionTear(this, null);
                            GossipRouter.this.removeEntry(this.group_name, this.logical_addr);
                        }
                    }
                }
                catch (SocketTimeoutException ste) {
                }
                catch (IOException ioex) {
                    GossipRouter.this.notifyAbnormalConnectionTear(this, ioex);
                    GossipRouter.this.removeEntry(this.group_name, this.logical_addr);
                    break;
                }
                catch (Exception ex) {
                    if (GossipRouter.this.log.isWarnEnabled()) {
                        GossipRouter.this.log.warn("Exception in TUNNEL receiver thread", ex);
                    }
                    GossipRouter.this.removeEntry(this.group_name, this.logical_addr);
                    break;
                }
            }
        }
    }

    class RoutingEntry {
        private final Address logical_addr;
        private final Address physical_addr;
        private final ConnectionHandler handler;
        private long timestamp = 0L;

        public RoutingEntry(Address logical_addr, Address physical_addr, ConnectionHandler ch) throws IOException {
            this.logical_addr = logical_addr;
            this.physical_addr = physical_addr;
            this.handler = ch;
            this.timestamp = System.currentTimeMillis();
        }

        void destroy() {
            this.handler.close();
            this.timestamp = 0L;
        }

        DataOutputStream getOutputStream() {
            this.update();
            return this.handler.output;
        }

        public void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            return other instanceof RoutingEntry && this.logical_addr.equals(((RoutingEntry)other).logical_addr);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("logical addr=");
            sb.append(this.logical_addr).append(" (").append(this.physical_addr).append(")");
            if (this.timestamp > 0L) {
                long diff = System.currentTimeMillis() - this.timestamp;
                sb.append(", ").append(diff).append(" ms old");
            }
            return sb.toString();
        }
    }

    class FailureDetectionListener
    implements ConnectionTearListener {
        FailureDetectionListener() {
        }

        public void connectionTorn(ConnectionHandler ch, Exception e) {
            Map map = (Map)GossipRouter.this.routingTable.get(ch.group_name);
            if (map != null && !map.isEmpty()) {
                Iterator i = map.entrySet().iterator();
                while (i.hasNext()) {
                    DataOutputStream stream;
                    RoutingEntry entry = (RoutingEntry)i.next().getValue();
                    Address logical_addr = entry.logical_addr;
                    Address broken = ch.logical_addr;
                    if (logical_addr == null || broken == null || logical_addr.equals(broken) || (stream = entry.getOutputStream()) == null) continue;
                    try {
                        stream.writeByte(11);
                        Util.writeAddress(ch.logical_addr, stream);
                        stream.flush();
                        if (!GossipRouter.this.log.isDebugEnabled()) continue;
                        GossipRouter.this.log.debug("Notified entry " + logical_addr + " about suspect " + ch.logical_addr);
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    public static interface ConnectionTearListener {
        public void connectionTorn(ConnectionHandler var1, Exception var2);
    }
}

