/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager {
    private static final IpAddressRep rep;
    private static short mcast_port;
    private static short tcp_port;

    private ResourceManager() {
    }

    public static String getNextMulticastAddress() {
        return rep.nextAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized short getNextMulticastPort(InetAddress bind_addr) throws Exception {
        short s = mcast_port;
        mcast_port = (short)(s + 1);
        short port = s;
        try {
            DatagramSocket sock = Util.createDatagramSocket(bind_addr, port);
            port = (short)sock.getLocalPort();
            sock.close();
            ServerSocket srv_sock = Util.createServerSocket(bind_addr, port);
            port = (short)srv_sock.getLocalPort();
            srv_sock.close();
            short s2 = port;
            return s2;
        }
        finally {
            mcast_port = (short)(port + 1);
        }
    }

    public static synchronized List<Short> getNextTcpPorts(InetAddress bind_addr, int num_requested_ports) throws Exception {
        short s = tcp_port;
        tcp_port = (short)(s + 1);
        short port = s;
        ArrayList<Short> retval = new ArrayList<Short>(num_requested_ports);
        for (int i = 0; i < num_requested_ports; ++i) {
            ServerSocket sock = Util.createServerSocket(bind_addr, port);
            port = (short)sock.getLocalPort();
            retval.add(port);
            tcp_port = port = (short)(port + 1);
            sock.close();
        }
        return retval;
    }

    public static String getUniqueClusterName(String base_name) {
        return base_name != null ? base_name + "-" + new UID().toString() : new UID().toString();
    }

    public static String getUniqueClusterName() {
        return ResourceManager.getUniqueClusterName(null);
    }

    public static void main(String[] args) throws Exception {
        List<Short> ports = ResourceManager.getNextTcpPorts(InetAddress.getByName("192.168.1.5"), 15);
        System.out.println("ports = " + ports);
        ports = ResourceManager.getNextTcpPorts(InetAddress.getByName("192.168.1.5"), 5);
        System.out.println("ports = " + ports);
    }

    static {
        String tmp_addr = System.getProperty("INITIAL_MCAST_ADDR", "230.1.1.1");
        mcast_port = Short.valueOf(System.getProperty("INITIAL_MCAST_PORT", "7000"));
        tcp_port = Short.valueOf(System.getProperty("INITIAL_TCP_PORT", "10000"));
        try {
            InetAddress tmp = InetAddress.getByName(tmp_addr);
            if (!tmp.isMulticastAddress()) {
                throw new IllegalArgumentException("initial multicast address " + tmp_addr + " is not a valid multicast (class D) address");
            }
            rep = new IpAddressRep(tmp_addr);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("initial multicast address " + tmp_addr + " is incorrect", e);
        }
    }

    static class IpAddressRep {
        short a = (short)225;
        short b = 1;
        short c = 1;
        short d = 1;
        private static final short MIN = 1;
        private static final short MAX = 250;
        private static final char DOT = '.';

        IpAddressRep(String initial_addr) {
            StringTokenizer tok = new StringTokenizer(initial_addr, ".", false);
            this.a = Short.valueOf(tok.nextToken());
            this.b = Short.valueOf(tok.nextToken());
            this.c = Short.valueOf(tok.nextToken());
            this.d = Short.valueOf(tok.nextToken());
        }

        synchronized String nextAddress() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.a).append('.').append(this.b).append('.').append(this.c).append('.').append(this.d);
            this.increment();
            return sb.toString();
        }

        private void increment() {
            this.d = (short)(this.d + 1);
            if (this.d > 250) {
                this.d = 1;
                this.c = (short)(this.c + 1);
                if (this.c > 250) {
                    this.c = 1;
                    this.b = (short)(this.b + 1);
                    if (this.b > 250) {
                        this.b = 1;
                        this.a = (short)(this.a + 1);
                        if (this.a > 250) {
                            this.a = (short)225;
                        }
                    }
                }
            }
        }
    }
}

