/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;

public class IllegalFieldValueException
extends IllegalArgumentException {
    private static final long serialVersionUID = 6305711765985447737L;
    private final DateTimeFieldType iDateTimeFieldType;
    private final DurationFieldType iDurationFieldType;
    private final String iFieldName;
    private final Number iNumberValue;
    private final String iStringValue;
    private final Number iLowerBound;
    private final Number iUpperBound;

    private static String createMessage(String fieldName, Number value, Number lowerBound, Number upperBound) {
        StringBuffer buf = new StringBuffer().append("Value ").append(value).append(" for ").append(fieldName).append(' ');
        if (lowerBound == null) {
            if (upperBound == null) {
                buf.append("is not supported");
            } else {
                buf.append("must not be larger than ").append(upperBound);
            }
        } else if (upperBound == null) {
            buf.append("must not be smaller than ").append(lowerBound);
        } else {
            buf.append("must be in the range [").append(lowerBound).append(',').append(upperBound).append(']');
        }
        return buf.toString();
    }

    private static String createMessage(String fieldName, String value) {
        StringBuffer buf = new StringBuffer().append("Value ");
        if (value == null) {
            buf.append("null");
        } else {
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
        buf.append(" for ").append(fieldName).append(' ').append("is not supported");
        return buf.toString();
    }

    public IllegalFieldValueException(DateTimeFieldType fieldType, Number value, Number lowerBound, Number upperBound) {
        super(IllegalFieldValueException.createMessage(fieldType.getName(), value, lowerBound, upperBound));
        this.iDateTimeFieldType = fieldType;
        this.iDurationFieldType = null;
        this.iFieldName = fieldType.getName();
        this.iNumberValue = value;
        this.iStringValue = null;
        this.iLowerBound = lowerBound;
        this.iUpperBound = upperBound;
    }

    public IllegalFieldValueException(DurationFieldType fieldType, Number value, Number lowerBound, Number upperBound) {
        super(IllegalFieldValueException.createMessage(fieldType.getName(), value, lowerBound, upperBound));
        this.iDateTimeFieldType = null;
        this.iDurationFieldType = fieldType;
        this.iFieldName = fieldType.getName();
        this.iNumberValue = value;
        this.iStringValue = null;
        this.iLowerBound = lowerBound;
        this.iUpperBound = upperBound;
    }

    public IllegalFieldValueException(String fieldName, Number value, Number lowerBound, Number upperBound) {
        super(IllegalFieldValueException.createMessage(fieldName, value, lowerBound, upperBound));
        this.iDateTimeFieldType = null;
        this.iDurationFieldType = null;
        this.iFieldName = fieldName;
        this.iNumberValue = value;
        this.iStringValue = null;
        this.iLowerBound = lowerBound;
        this.iUpperBound = upperBound;
    }

    public IllegalFieldValueException(DateTimeFieldType fieldType, String value) {
        super(IllegalFieldValueException.createMessage(fieldType.getName(), value));
        this.iDateTimeFieldType = fieldType;
        this.iDurationFieldType = null;
        this.iFieldName = fieldType.getName();
        this.iStringValue = value;
        this.iNumberValue = null;
        this.iLowerBound = null;
        this.iUpperBound = null;
    }

    public IllegalFieldValueException(DurationFieldType fieldType, String value) {
        super(IllegalFieldValueException.createMessage(fieldType.getName(), value));
        this.iDateTimeFieldType = null;
        this.iDurationFieldType = fieldType;
        this.iFieldName = fieldType.getName();
        this.iStringValue = value;
        this.iNumberValue = null;
        this.iLowerBound = null;
        this.iUpperBound = null;
    }

    public IllegalFieldValueException(String fieldName, String value) {
        super(IllegalFieldValueException.createMessage(fieldName, value));
        this.iDateTimeFieldType = null;
        this.iDurationFieldType = null;
        this.iFieldName = fieldName;
        this.iStringValue = value;
        this.iNumberValue = null;
        this.iLowerBound = null;
        this.iUpperBound = null;
    }

    public DateTimeFieldType getDateTimeFieldType() {
        return this.iDateTimeFieldType;
    }

    public DurationFieldType getDurationFieldType() {
        return this.iDurationFieldType;
    }

    public String getFieldName() {
        return this.iFieldName;
    }

    public Number getIllegalNumberValue() {
        return this.iNumberValue;
    }

    public String getIllegalStringValue() {
        return this.iStringValue;
    }

    public String getIllegalValueAsString() {
        String value = this.iStringValue;
        if (value == null) {
            value = String.valueOf(this.iNumberValue);
        }
        return value;
    }

    public Number getLowerBound() {
        return this.iLowerBound;
    }

    public Number getUpperBound() {
        return this.iUpperBound;
    }
}

