/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableInterval;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractInterval;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.field.FieldUtils;

public abstract class BaseInterval
extends AbstractInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 576586928732749278L;
    private Chronology iChronology;
    private long iStartMillis;
    private long iEndMillis;

    protected BaseInterval(long startInstant, long endInstant, Chronology chrono) {
        this.iChronology = DateTimeUtils.getChronology(chrono);
        this.checkInterval(startInstant, endInstant);
        this.iStartMillis = startInstant;
        this.iEndMillis = endInstant;
    }

    protected BaseInterval(ReadableInstant start, ReadableInstant end) {
        if (start == null && end == null) {
            this.iStartMillis = this.iEndMillis = DateTimeUtils.currentTimeMillis();
            this.iChronology = ISOChronology.getInstance();
        } else {
            this.iChronology = DateTimeUtils.getInstantChronology(start);
            this.iStartMillis = DateTimeUtils.getInstantMillis(start);
            this.iEndMillis = DateTimeUtils.getInstantMillis(end);
            this.checkInterval(this.iStartMillis, this.iEndMillis);
        }
    }

    protected BaseInterval(ReadableInstant start, ReadableDuration duration) {
        this.iChronology = DateTimeUtils.getInstantChronology(start);
        this.iStartMillis = DateTimeUtils.getInstantMillis(start);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        this.iEndMillis = FieldUtils.safeAdd(this.iStartMillis, durationMillis);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableDuration duration, ReadableInstant end) {
        this.iChronology = DateTimeUtils.getInstantChronology(end);
        this.iEndMillis = DateTimeUtils.getInstantMillis(end);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        this.iStartMillis = FieldUtils.safeAdd(this.iEndMillis, -durationMillis);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadableInstant start, ReadablePeriod period) {
        Chronology chrono;
        this.iChronology = chrono = DateTimeUtils.getInstantChronology(start);
        this.iStartMillis = DateTimeUtils.getInstantMillis(start);
        this.iEndMillis = period == null ? this.iStartMillis : chrono.add(period, this.iStartMillis, 1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(ReadablePeriod period, ReadableInstant end) {
        Chronology chrono;
        this.iChronology = chrono = DateTimeUtils.getInstantChronology(end);
        this.iEndMillis = DateTimeUtils.getInstantMillis(end);
        this.iStartMillis = period == null ? this.iEndMillis : chrono.add(period, this.iEndMillis, -1);
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    protected BaseInterval(Object interval, Chronology chrono) {
        IntervalConverter converter = ConverterManager.getInstance().getIntervalConverter(interval);
        if (converter.isReadableInterval(interval, chrono)) {
            ReadableInterval input = (ReadableInterval)interval;
            this.iChronology = chrono != null ? chrono : input.getChronology();
            this.iStartMillis = input.getStartMillis();
            this.iEndMillis = input.getEndMillis();
        } else if (this instanceof ReadWritableInterval) {
            converter.setInto((ReadWritableInterval)((Object)this), interval, chrono);
        } else {
            MutableInterval mi = new MutableInterval();
            converter.setInto(mi, interval, chrono);
            this.iChronology = mi.getChronology();
            this.iStartMillis = mi.getStartMillis();
            this.iEndMillis = mi.getEndMillis();
        }
        this.checkInterval(this.iStartMillis, this.iEndMillis);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public long getStartMillis() {
        return this.iStartMillis;
    }

    public long getEndMillis() {
        return this.iEndMillis;
    }

    protected void setInterval(long startInstant, long endInstant, Chronology chrono) {
        this.checkInterval(startInstant, endInstant);
        this.iStartMillis = startInstant;
        this.iEndMillis = endInstant;
        this.iChronology = DateTimeUtils.getChronology(chrono);
    }
}

