/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public class DelegatedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -4730164440214502503L;
    private final DateTimeField iField;
    private final DateTimeFieldType iType;

    public DelegatedDateTimeField(DateTimeField field) {
        this(field, null);
    }

    public DelegatedDateTimeField(DateTimeField field, DateTimeFieldType type) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        this.iField = field;
        this.iType = type == null ? field.getType() : type;
    }

    public final DateTimeField getWrappedField() {
        return this.iField;
    }

    public DateTimeFieldType getType() {
        return this.iType;
    }

    public String getName() {
        return this.iType.getName();
    }

    public boolean isSupported() {
        return this.iField.isSupported();
    }

    public boolean isLenient() {
        return this.iField.isLenient();
    }

    public int get(long instant) {
        return this.iField.get(instant);
    }

    public String getAsText(long instant, Locale locale) {
        return this.iField.getAsText(instant, locale);
    }

    public String getAsText(long instant) {
        return this.iField.getAsText(instant);
    }

    public String getAsText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.iField.getAsText(partial, fieldValue, locale);
    }

    public String getAsText(ReadablePartial partial, Locale locale) {
        return this.iField.getAsText(partial, locale);
    }

    public String getAsText(int fieldValue, Locale locale) {
        return this.iField.getAsText(fieldValue, locale);
    }

    public String getAsShortText(long instant, Locale locale) {
        return this.iField.getAsShortText(instant, locale);
    }

    public String getAsShortText(long instant) {
        return this.iField.getAsShortText(instant);
    }

    public String getAsShortText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.iField.getAsShortText(partial, fieldValue, locale);
    }

    public String getAsShortText(ReadablePartial partial, Locale locale) {
        return this.iField.getAsShortText(partial, locale);
    }

    public String getAsShortText(int fieldValue, Locale locale) {
        return this.iField.getAsShortText(fieldValue, locale);
    }

    public long add(long instant, int value) {
        return this.iField.add(instant, value);
    }

    public long add(long instant, long value) {
        return this.iField.add(instant, value);
    }

    public int[] add(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        return this.iField.add(instant, fieldIndex, values, valueToAdd);
    }

    public int[] addWrapPartial(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        return this.iField.addWrapPartial(instant, fieldIndex, values, valueToAdd);
    }

    public long addWrapField(long instant, int value) {
        return this.iField.addWrapField(instant, value);
    }

    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        return this.iField.addWrapField(instant, fieldIndex, values, valueToAdd);
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.iField.getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.iField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public long set(long instant, int value) {
        return this.iField.set(instant, value);
    }

    public long set(long instant, String text, Locale locale) {
        return this.iField.set(instant, text, locale);
    }

    public long set(long instant, String text) {
        return this.iField.set(instant, text);
    }

    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, int newValue) {
        return this.iField.set(instant, fieldIndex, values, newValue);
    }

    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, String text, Locale locale) {
        return this.iField.set(instant, fieldIndex, values, text, locale);
    }

    public DurationField getDurationField() {
        return this.iField.getDurationField();
    }

    public DurationField getRangeDurationField() {
        return this.iField.getRangeDurationField();
    }

    public boolean isLeap(long instant) {
        return this.iField.isLeap(instant);
    }

    public int getLeapAmount(long instant) {
        return this.iField.getLeapAmount(instant);
    }

    public DurationField getLeapDurationField() {
        return this.iField.getLeapDurationField();
    }

    public int getMinimumValue() {
        return this.iField.getMinimumValue();
    }

    public int getMinimumValue(long instant) {
        return this.iField.getMinimumValue(instant);
    }

    public int getMinimumValue(ReadablePartial instant) {
        return this.iField.getMinimumValue(instant);
    }

    public int getMinimumValue(ReadablePartial instant, int[] values) {
        return this.iField.getMinimumValue(instant, values);
    }

    public int getMaximumValue() {
        return this.iField.getMaximumValue();
    }

    public int getMaximumValue(long instant) {
        return this.iField.getMaximumValue(instant);
    }

    public int getMaximumValue(ReadablePartial instant) {
        return this.iField.getMaximumValue(instant);
    }

    public int getMaximumValue(ReadablePartial instant, int[] values) {
        return this.iField.getMaximumValue(instant, values);
    }

    public int getMaximumTextLength(Locale locale) {
        return this.iField.getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.iField.getMaximumShortTextLength(locale);
    }

    public long roundFloor(long instant) {
        return this.iField.roundFloor(instant);
    }

    public long roundCeiling(long instant) {
        return this.iField.roundCeiling(instant);
    }

    public long roundHalfFloor(long instant) {
        return this.iField.roundHalfFloor(instant);
    }

    public long roundHalfCeiling(long instant) {
        return this.iField.roundHalfCeiling(instant);
    }

    public long roundHalfEven(long instant) {
        return this.iField.roundHalfEven(instant);
    }

    public long remainder(long instant) {
        return this.iField.remainder(instant);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

