/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.assignment;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.User;
import org.jbpm.identity.assignment.ExpressionAssignmentException;
import org.jbpm.identity.assignment.ExpressionSession;
import org.jbpm.identity.assignment.TermTokenizer;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.security.SecurityHelper;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;

public class ExpressionAssignmentHandler
implements AssignmentHandler {
    private static final long serialVersionUID = 1L;
    protected String expression;
    protected ExecutionContext executionContext = null;
    protected ExpressionSession expressionSession = null;
    protected TermTokenizer tokenizer;
    protected Entity entity = null;
    private static final Log log = LogFactory.getLog(ExpressionAssignmentHandler.class);

    public void assign(Assignable assignable, ExecutionContext executionContext) {
        try {
            this.expressionSession = this.getExpressionSession();
            if (this.expressionSession == null) {
                throw new NullPointerException("getIdentitySession returned null");
            }
            this.tokenizer = new TermTokenizer(this.expression);
            this.executionContext = executionContext;
            this.entity = this.resolveFirstTerm(this.tokenizer.nextTerm());
            while (this.tokenizer.hasMoreTerms() && this.entity != null) {
                this.entity = this.resolveNextTerm(this.tokenizer.nextTerm());
            }
            if (this.entity == null) {
                throw new RuntimeException("couldn't resolve assignment expression '" + this.expression + "'");
            }
            if (this.entity instanceof User) {
                assignable.setActorId(this.entity.getName());
            } else if (this.entity instanceof Group) {
                assignable.setPooledActors(new String[]{this.entity.getName()});
            }
        }
        catch (RuntimeException e) {
            throw new ExpressionAssignmentException("couldn't resolve assignment expression '" + this.expression + "'", e);
        }
    }

    protected ExpressionSession getExpressionSession() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new RuntimeException("no active JbpmContext for resolving assignment expression'" + this.expression + "'");
        }
        return new IdentitySession(jbpmContext.getSession());
    }

    protected Entity resolveFirstTerm(String term) {
        Entity entity = null;
        log.debug((Object)("resolving first term '" + term + "'"));
        if (term.equalsIgnoreCase("previous")) {
            String userName = SecurityHelper.getAuthenticatedActorId();
            entity = this.getUserByName(userName);
        } else if (term.startsWith("swimlane(") && term.endsWith(")")) {
            String swimlaneName = term.substring(9, term.length() - 1).trim();
            String userName = this.getSwimlaneActorId(swimlaneName);
            entity = this.getUserByName(userName);
        } else if (term.startsWith("variable(") && term.endsWith(")")) {
            String variableName = term.substring(9, term.length() - 1).trim();
            Object value = this.getVariable(variableName);
            if (value == null) {
                throw new ExpressionAssignmentException("variable '" + variableName + "' is null");
            }
            if (value instanceof String) {
                entity = this.getUserByName((String)value);
            } else if (value instanceof Entity) {
                entity = (Entity)value;
            }
        } else if (term.startsWith("user(") && term.endsWith(")")) {
            String userName = term.substring(5, term.length() - 1).trim();
            entity = this.getUserByName(userName);
        } else if (term.startsWith("group(") && term.endsWith(")")) {
            String groupName = term.substring(6, term.length() - 1).trim();
            entity = this.getGroupByName(groupName);
        } else {
            throw new ExpressionAssignmentException("couldn't interpret first term in expression '" + this.expression + "'");
        }
        return entity;
    }

    protected Entity resolveNextTerm(String term) {
        log.debug((Object)("resolving next term '" + term + "'"));
        if (term.startsWith("group(") && term.endsWith(")")) {
            User user = (User)this.entity;
            String groupType = term.substring(6, term.length() - 1).trim();
            Set groups = user.getGroupsForGroupType(groupType);
            if (groups.size() == 0) {
                throw new ExpressionAssignmentException("no groups for group-type '" + groupType + "'");
            }
            this.entity = (Entity)groups.iterator().next();
        } else if (term.startsWith("member(") && term.endsWith(")")) {
            String role = term.substring(7, term.length() - 1).trim();
            Group group = (Group)this.entity;
            this.entity = this.expressionSession.getUserByGroupAndRole(group.getName(), role);
            if (this.entity == null) {
                throw new ExpressionAssignmentException("no users in role '" + role + "'");
            }
        } else {
            throw new ExpressionAssignmentException("couldn't interpret term '" + term + "' in expression '" + this.expression + "'");
        }
        return this.entity;
    }

    protected Object getVariable(String variableName) {
        Token token = this.executionContext.getToken();
        return this.executionContext.getContextInstance().getVariable(variableName, token);
    }

    protected Entity getGroupByName(String groupName) {
        Group group = null;
        group = this.expressionSession.getGroupByName(groupName);
        if (group == null) {
            throw new ExpressionAssignmentException("group '" + groupName + "' couldn't be fetched from the user db");
        }
        return group;
    }

    protected Entity getUserByName(String userName) {
        User user = null;
        user = this.expressionSession.getUserByName(userName);
        if (user == null) {
            throw new ExpressionAssignmentException("user '" + userName + "' couldn't be fetched from the user db");
        }
        return user;
    }

    protected String getSwimlaneActorId(String swimlaneName) {
        SwimlaneInstance swimlaneInstance = this.executionContext.getTaskMgmtInstance().getSwimlaneInstance(swimlaneName);
        if (swimlaneInstance == null) {
            throw new ExpressionAssignmentException("no swimlane instance '" + swimlaneName + "'");
        }
        return swimlaneInstance.getActorId();
    }
}

