/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.TOC;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFSettings;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CommentsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.DocumentDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.EndnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocProtect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFDocument
extends POIXMLDocument
implements Document,
IBody {
    private CTDocument1 ctDocument;
    private XWPFSettings settings;
    protected List<XWPFFooter> footers;
    protected List<XWPFHeader> headers;
    protected List<XWPFComment> comments;
    protected List<XWPFHyperlink> hyperlinks;
    protected List<XWPFParagraph> paragraphs;
    protected List<XWPFTable> tables;
    protected List<IBodyElement> bodyElements;
    protected List<XWPFPictureData> pictures;
    protected Map<Integer, XWPFFootnote> footnotes;
    protected Map<Integer, XWPFFootnote> endnotes;
    protected XWPFNumbering numbering;
    protected XWPFStyles styles;
    private XWPFHeaderFooterPolicy headerFooterPolicy;

    public XWPFDocument(OPCPackage pkg) throws IOException {
        super(pkg);
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument(InputStream is) throws IOException {
        super(PackageHelper.open(is));
        this.load(XWPFFactory.getInstance());
    }

    public XWPFDocument() {
        super(XWPFDocument.newPackage());
        this.onDocumentCreate();
    }

    @Override
    protected void onDocumentRead() throws IOException {
        this.hyperlinks = new ArrayList<XWPFHyperlink>();
        this.comments = new ArrayList<XWPFComment>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        this.bodyElements = new ArrayList<IBodyElement>();
        this.footers = new ArrayList<XWPFFooter>();
        this.headers = new ArrayList<XWPFHeader>();
        this.footnotes = new HashMap<Integer, XWPFFootnote>();
        this.endnotes = new HashMap<Integer, XWPFFootnote>();
        try {
            DocumentDocument doc = DocumentDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
            this.ctDocument = doc.getDocument();
            this.initFootnotes();
            XmlCursor cursor = this.ctDocument.getBody().newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o = cursor.getObject();
                if (o instanceof CTP) {
                    XWPFParagraph xWPFParagraph = new XWPFParagraph((CTP)o, this);
                    this.bodyElements.add(xWPFParagraph);
                    this.paragraphs.add(xWPFParagraph);
                }
                if (!(o instanceof CTTbl)) continue;
                XWPFTable xWPFTable = new XWPFTable((CTTbl)o, this);
                this.bodyElements.add(xWPFTable);
                this.tables.add(xWPFTable);
            }
            if (doc.getDocument().getBody().getSectPr() != null) {
                this.headerFooterPolicy = new XWPFHeaderFooterPolicy(this);
            }
            for (POIXMLDocumentPart pOIXMLDocumentPart : this.getRelations()) {
                String relation = pOIXMLDocumentPart.getPackageRelationship().getRelationshipType();
                if (relation.equals(XWPFRelation.STYLES.getRelation())) {
                    this.styles = (XWPFStyles)pOIXMLDocumentPart;
                    continue;
                }
                if (relation.equals(XWPFRelation.NUMBERING.getRelation())) {
                    this.numbering = (XWPFNumbering)pOIXMLDocumentPart;
                    continue;
                }
                if (relation.equals(XWPFRelation.FOOTER.getRelation())) {
                    this.footers.add((XWPFFooter)pOIXMLDocumentPart);
                    continue;
                }
                if (relation.equals(XWPFRelation.HEADER.getRelation())) {
                    this.headers.add((XWPFHeader)pOIXMLDocumentPart);
                    continue;
                }
                if (relation.equals(XWPFRelation.COMMENT.getRelation())) {
                    CommentsDocument cmntdoc = CommentsDocument.Factory.parse((InputStream)pOIXMLDocumentPart.getPackagePart().getInputStream());
                    for (CTComment ctcomment : cmntdoc.getComments().getCommentList()) {
                        this.comments.add(new XWPFComment(ctcomment));
                    }
                    continue;
                }
                if (!relation.equals(XWPFRelation.SETTINGS.getRelation())) continue;
                this.settings = (XWPFSettings)pOIXMLDocumentPart;
            }
            this.initHyperlinks();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.getAllPictures();
    }

    private void initHyperlinks() {
        try {
            for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation())) {
                this.hyperlinks.add(new XWPFHyperlink(rel.getId(), rel.getTargetURI().toString()));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private void initFootnotes() throws XmlException, IOException {
        for (POIXMLDocumentPart p : this.getRelations()) {
            String relation = p.getPackageRelationship().getRelationshipType();
            if (relation.equals(XWPFRelation.FOOTNOTE.getRelation())) {
                FootnotesDocument footnotesDocument = FootnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
                for (CTFtnEdn ctFtnEdn : footnotesDocument.getFootnotes().getFootnoteList()) {
                    this.footnotes.put(ctFtnEdn.getId().intValue(), new XWPFFootnote(this, ctFtnEdn));
                }
                continue;
            }
            if (!relation.equals(XWPFRelation.ENDNOTE.getRelation())) continue;
            EndnotesDocument endnotesDocument = EndnotesDocument.Factory.parse((InputStream)p.getPackagePart().getInputStream());
            for (CTFtnEdn ctFtnEdn : endnotesDocument.getEndnotes().getEndnoteList()) {
                this.endnotes.put(ctFtnEdn.getId().intValue(), new XWPFFootnote(this, ctFtnEdn));
            }
        }
    }

    protected static OPCPackage newPackage() {
        try {
            OPCPackage pkg = OPCPackage.create(new ByteArrayOutputStream());
            PackagePartName corePartName = PackagingURIHelper.createPartName(XWPFRelation.DOCUMENT.getDefaultFileName());
            pkg.addRelationship(corePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
            pkg.createPart(corePartName, XWPFRelation.DOCUMENT.getContentType());
            pkg.getPackageProperties().setCreatorProperty("Apache POI");
            return pkg;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    protected void onDocumentCreate() {
        this.hyperlinks = new ArrayList<XWPFHyperlink>();
        this.comments = new ArrayList<XWPFComment>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        this.tables = new ArrayList<XWPFTable>();
        this.ctDocument = CTDocument1.Factory.newInstance();
        this.ctDocument.addNewBody();
        this.settings = (XWPFSettings)this.createRelationship(XWPFRelation.SETTINGS, XWPFFactory.getInstance());
        POIXMLProperties.ExtendedProperties expProps = this.getProperties().getExtendedProperties();
        expProps.getUnderlyingProperties().setApplication("Apache POI");
    }

    @Internal
    public CTDocument1 getDocument() {
        return this.ctDocument;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    @Override
    public List<XWPFTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public XWPFTable getTableArray(int pos) {
        if (pos > 0 && pos < this.tables.size()) {
            return this.tables.get(pos);
        }
        return null;
    }

    public List<XWPFFooter> getFooterList() {
        return Collections.unmodifiableList(this.footers);
    }

    public XWPFFooter getFooterArray(int pos) {
        return this.footers.get(pos);
    }

    public List<XWPFHeader> getHeaderList() {
        return Collections.unmodifiableList(this.headers);
    }

    public XWPFHeader getHeaderArray(int pos) {
        return this.headers.get(pos);
    }

    public String getTblStyle(XWPFTable table) {
        return table.getStyleID();
    }

    public XWPFHyperlink getHyperlinkByID(String id) {
        for (XWPFHyperlink link : this.hyperlinks) {
            if (!link.getId().equals(id)) continue;
            return link;
        }
        return null;
    }

    public XWPFFootnote getFootnoteByID(int id) {
        return this.footnotes.get(id);
    }

    public XWPFFootnote getEndnoteByID(int id) {
        return this.endnotes.get(id);
    }

    public Collection<XWPFFootnote> getFootnotes() {
        return Collections.unmodifiableCollection(this.footnotes == null ? new ArrayList() : this.footnotes.values());
    }

    public XWPFHyperlink[] getHyperlinks() {
        return this.hyperlinks.toArray(new XWPFHyperlink[this.hyperlinks.size()]);
    }

    public XWPFComment getCommentByID(String id) {
        for (XWPFComment comment : this.comments) {
            if (!comment.getId().equals(id)) continue;
            return comment;
        }
        return null;
    }

    public XWPFComment[] getComments() {
        return this.comments.toArray(new XWPFComment[this.comments.size()]);
    }

    public PackagePart getPartById(String id) {
        try {
            return this.getTargetPart(this.getCorePart().getRelationship(id));
        }
        catch (InvalidFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XWPFHeaderFooterPolicy getHeaderFooterPolicy() {
        return this.headerFooterPolicy;
    }

    @Internal
    public CTStyles getStyle() throws XmlException, IOException {
        PackagePart[] parts;
        try {
            parts = this.getRelatedByType(XWPFRelation.STYLES.getRelation());
        }
        catch (InvalidFormatException e) {
            throw new IllegalStateException(e);
        }
        if (parts.length != 1) {
            throw new IllegalStateException("Expecting one Styles document part, but found " + parts.length);
        }
        StylesDocument sd = StylesDocument.Factory.parse((InputStream)parts[0].getInputStream());
        return sd.getStyles();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        LinkedList<PackagePart> embedds = new LinkedList<PackagePart>();
        for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject")) {
            embedds.add(this.getTargetPart(rel));
        }
        for (PackageRelationship rel : this.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package")) {
            embedds.add(this.getTargetPart(rel));
        }
        return embedds;
    }

    public int getParagraphPos(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size() && this.bodyElements.get(pos).getElementType() == BodyElementType.PARAGRAPH) {
            int startPos = pos < this.paragraphs.size() ? pos : this.paragraphs.size();
            for (int i = startPos; i < 0; --i) {
                if (this.paragraphs.get(i) != this.bodyElements.get(pos)) continue;
                return i;
            }
        }
        if (this.paragraphs.size() == 0) {
            return 0;
        }
        return -1;
    }

    public int getTablePos(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size() && this.bodyElements.get(pos).getElementType() == BodyElementType.TABLE) {
            int startPos = pos < this.tables.size() ? pos : this.tables.size();
            for (int i = startPos; i > 0; --i) {
                if (this.tables.get(i) != this.bodyElements.get(pos)) continue;
                return i;
            }
        }
        if (this.tables.size() == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i = 0;
            cursor.toCursor(p.newCursor());
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newP);
            cursor.toCursor(p.newCursor());
            cursor.toEndToken();
            return newP;
        }
        return null;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, this);
            cursor.removeXmlContents();
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            cursor = t.newCursor();
            while (cursor.toPrevSibling()) {
                o = cursor.getObject();
                if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                ++i;
            }
            this.bodyElements.add(i, newT);
            cursor = t.newCursor();
            cursor.toEndToken();
            return newT;
        }
        return null;
    }

    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        if (verify.getObject() == this.ctDocument.getBody()) {
            return true;
        }
        XmlObject o = verify.getObject();
        return false;
    }

    public Integer getPosOfParagraph(XWPFParagraph p) {
        int pos = 0;
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            if (!(this.bodyElements.get(i) instanceof XWPFParagraph)) continue;
            if (this.bodyElements.get(i).equals(p)) {
                return pos;
            }
            ++pos;
        }
        return null;
    }

    public Integer getPosOfTable(XWPFTable t) {
        int pos = 0;
        for (int i = 0; i < this.bodyElements.size(); ++i) {
            if (this.bodyElements.get(i).getElementType() != BodyElementType.TABLE) continue;
            if (this.bodyElements.get(i) == t) {
                return pos;
            }
            ++pos;
        }
        return null;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTDocument1.type.getName().getNamespaceURI(), "document"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        map.put("urn:schemas-microsoft-com:office:office", "o");
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("urn:schemas-microsoft-com:vml", "v");
        map.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        map.put("urn:schemas-microsoft-com:office:word", "w10");
        map.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctDocument.save(out, xmlOptions);
        out.close();
    }

    public XWPFParagraph createParagraph() {
        return new XWPFParagraph(this.ctDocument.getBody().addNewP(), this);
    }

    public boolean removeBodyElement(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size()) {
            if (this.bodyElements.get(pos).getElementType() == BodyElementType.TABLE) {
                this.bodyElements.remove(pos);
                Integer tablePos = this.getTablePos(pos);
                this.tables.remove(tablePos);
                this.ctDocument.getBody().removeTbl(tablePos.intValue());
                return true;
            }
            if (this.bodyElements.get(pos).getElementType() == BodyElementType.PARAGRAPH) {
                this.bodyElements.remove(pos);
                Integer paraPos = this.getParagraphPos(pos);
                this.paragraphs.remove(paraPos);
                this.ctDocument.getBody().removeP(paraPos.intValue());
                return true;
            }
        }
        return false;
    }

    public void setParagraph(XWPFParagraph paragraph, int pos) {
        this.paragraphs.set(pos, paragraph);
        this.ctDocument.getBody().setPArray(pos, paragraph.getCTP());
    }

    public XWPFParagraph getLastParagraph() {
        int lastPos = this.paragraphs.toArray().length - 1;
        return this.paragraphs.get(lastPos);
    }

    public XWPFTable createTable() {
        return new XWPFTable(this.ctDocument.getBody().addNewTbl(), this);
    }

    public XWPFTable createTable(int rows, int cols) {
        return new XWPFTable(this.ctDocument.getBody().addNewTbl(), this, rows, cols);
    }

    public void createTOC() {
        CTSdtBlock block = this.getDocument().getBody().addNewSdt();
        TOC toc = new TOC(block);
        for (XWPFParagraph par : this.paragraphs) {
            String parStyle = par.getStyle();
            if (parStyle == null || !parStyle.substring(0, 7).equals("Heading")) continue;
            try {
                int level = Integer.valueOf(parStyle.substring("Heading".length()));
                toc.addRow(level, par.getText(), 1, "112723803");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void setTable(int pos, XWPFTable table) {
        this.tables.set(pos, table);
        this.ctDocument.getBody().setTblArray(pos, table.getCTTbl());
    }

    public boolean isEnforcedReadonlyProtection() {
        return this.settings.isEnforcedWith(STDocProtect.READ_ONLY);
    }

    public boolean isEnforcedFillingFormsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.FORMS);
    }

    public boolean isEnforcedCommentsProtection() {
        return this.settings.isEnforcedWith(STDocProtect.COMMENTS);
    }

    public boolean isEnforcedTrackedChangesProtection() {
        return this.settings.isEnforcedWith(STDocProtect.TRACKED_CHANGES);
    }

    public void enforceReadonlyProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.READ_ONLY);
    }

    public void enforceFillingFormsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.FORMS);
    }

    public void enforceCommentsProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.COMMENTS);
    }

    public void enforceTrackedChangesProtection() {
        this.settings.setEnforcementEditValue(STDocProtect.TRACKED_CHANGES);
    }

    public void removeProtectionEnforcement() {
        this.settings.removeEnforcement();
    }

    @Override
    public void insertTable(int pos, XWPFTable table) {
        CTTbl tbl;
        int i;
        this.bodyElements.add(pos, table);
        for (i = 0; i < this.ctDocument.getBody().getTblList().size() && (tbl = this.ctDocument.getBody().getTblArray(i)) != table.getCTTbl(); ++i) {
        }
        this.tables.add(i, table);
    }

    public List<XWPFPictureData> getAllPictures() {
        if (this.pictures == null) {
            this.pictures = new ArrayList<XWPFPictureData>();
            for (POIXMLDocumentPart poixmlDocumentPart : this.getRelations()) {
                if (!(poixmlDocumentPart instanceof XWPFPictureData)) continue;
                this.pictures.add((XWPFPictureData)poixmlDocumentPart);
            }
        }
        return this.pictures;
    }

    public List<XWPFPictureData> getAllPackagePictures() {
        ArrayList<XWPFPictureData> pkgpictures = new ArrayList<XWPFPictureData>();
        pkgpictures.addAll(this.getAllPictures());
        for (POIXMLDocumentPart poixmlDocumentPart : this.getRelations()) {
            if (!(poixmlDocumentPart instanceof XWPFHeaderFooter)) continue;
            pkgpictures.addAll(((XWPFHeaderFooter)poixmlDocumentPart).getAllPictures());
        }
        return pkgpictures;
    }

    public int addPicture(InputStream is, int format) throws IOException, InvalidFormatException {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, true);
        OutputStream out = img.getPackagePart().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        this.pictures.add(img);
        return this.getAllPictures().size() - 1;
    }

    public int addPicture(byte[] pictureData, int format) throws InvalidFormatException {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        this.pictures.add(img);
        return this.getAllPictures().size() - 1;
    }

    public int getNextPicNameNumber(int format) throws InvalidFormatException {
        int img = this.getAllPackagePictures().size() + 1;
        String proposal = XWPFPictureData.RELATIONS[format].getFileName(img);
        PackagePartName createPartName = PackagingURIHelper.createPartName(proposal);
        while (this.getPackage().getPart(createPartName) != null) {
            proposal = XWPFPictureData.RELATIONS[format].getFileName(++img);
            createPartName = PackagingURIHelper.createPartName(proposal);
        }
        return img;
    }

    public XWPFPictureData getPictureDataByID(String blipID) {
        for (POIXMLDocumentPart part : this.getRelations()) {
            if (part.getPackageRelationship() == null || part.getPackageRelationship().getId() == null || !part.getPackageRelationship().getId().equals(blipID)) continue;
            return (XWPFPictureData)part;
        }
        return null;
    }

    public PackageRelationship addPictureReference(byte[] pictureData, int format) throws InvalidFormatException {
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        PackageRelationship rel = null;
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
            rel = img.getPackageRelationship();
            this.pictures.add(img);
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        return rel;
    }

    public PackageRelationship addPictureReference(InputStream is, int format) throws InvalidFormatException, IOException {
        PackageRelationship rel = null;
        int imageNumber = this.getNextPicNameNumber(format);
        XWPFPictureData img = (XWPFPictureData)this.createRelationship(XWPFPictureData.RELATIONS[format], XWPFFactory.getInstance(), imageNumber, false);
        OutputStream out = img.getPackagePart().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
        rel = img.getPackageRelationship();
        this.pictures.add(img);
        return rel;
    }

    public XWPFNumbering getNumbering() {
        return this.numbering;
    }

    public XWPFStyles getStyles() {
        return this.styles;
    }

    @Override
    public XWPFParagraph getParagraph(CTP p) {
        for (int i = 0; i < this.getParagraphs().size(); ++i) {
            if (this.getParagraphs().get(i).getCTP() != p) continue;
            return this.getParagraphs().get(i);
        }
        return null;
    }

    @Override
    public XWPFTable getTable(CTTbl ctTbl) {
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.getTables().get(i).getCTTbl() != ctTbl) continue;
            return this.getTables().get(i);
        }
        return null;
    }

    public Iterator<XWPFTable> getTablesIterator() {
        return this.tables.iterator();
    }

    public Iterator<XWPFParagraph> getParagraphsIterator() {
        return this.paragraphs.iterator();
    }

    @Override
    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    @Override
    public IBody getPart() {
        return this;
    }

    @Override
    public BodyType getPartType() {
        return BodyType.DOCUMENT;
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cell) {
        XmlCursor cursor = cell.newCursor();
        cursor.toParent();
        XmlObject o = cursor.getObject();
        if (!(o instanceof CTRow)) {
            return null;
        }
        CTRow row = (CTRow)o;
        cursor.toParent();
        o = cursor.getObject();
        if (!(o instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (row == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }
}

