/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.portlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LazyDashboardFilter
implements Filter {
    private static final Pattern PATTERN_DASHBOARD_PATH = Pattern.compile("/user/([^/]*)/dashboard");
    private ServletContext servletContext;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Matcher matcher;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String pathInfo = httpServletRequest.getPathInfo();
        if (pathInfo != null && (matcher = PATTERN_DASHBOARD_PATH.matcher(pathInfo)).matches()) {
            WebFrameworkServiceRegistry serviceRegistry;
            RequestContext context;
            try {
                context = RequestContextUtil.initRequestContext((ApplicationContext)this.getApplicationContext(), (HttpServletRequest)((HttpServletRequest)request));
            }
            catch (RequestContextException e) {
                throw new ServletException((Throwable)e);
            }
            String userid = context.getUserId();
            if (userid != null && userid.equals(URLDecoder.decode((String)matcher.group(1))) && (serviceRegistry = context.getServiceRegistry()).getModelObjectService().getPage("user/" + userid + "/dashboard") == null) {
                HashMap<String, String> tokens = new HashMap<String, String>();
                tokens.put("userid", userid);
                serviceRegistry.getPresetsManager().constructPreset("user-dashboard", tokens);
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    public void destroy() {
    }

    private ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
    }
}

