/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment;

import org.alfresco.deployment.DeploymentReceiverTransport;
import org.alfresco.deployment.impl.DeploymentException;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

public class ShutdownImpl {
    private int registryPort = 44100;
    private String serviceName = "deployment";
    private String hostName = "localhost";
    private String user = "admin";
    private char[] password = "password".toCharArray();

    public void init() {
        DeploymentReceiverTransport service = this.getTransport();
        try {
            service.shutDown(this.getUser(), this.getPassword());
            service = null;
        }
        catch (Exception e) {
            service = null;
        }
    }

    private DeploymentReceiverTransport getTransport() {
        try {
            RmiProxyFactoryBean factory = new RmiProxyFactoryBean();
            factory.setRefreshStubOnConnectFailure(true);
            factory.setServiceInterface(DeploymentReceiverTransport.class);
            factory.setServiceUrl("rmi://" + this.hostName + ":" + this.registryPort + "/" + this.serviceName);
            factory.afterPropertiesSet();
            DeploymentReceiverTransport transport = (DeploymentReceiverTransport)factory.getObject();
            return transport;
        }
        catch (Exception e) {
            throw new DeploymentException("Could not connect to " + this.hostName + " at " + this.registryPort, e);
        }
    }

    public void setRegistryPort(int servicePort) {
        this.registryPort = servicePort;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public char[] getPassword() {
        return this.password;
    }
}

