/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.jbpm.JbpmException;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ConstructorInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    BeanInfo beanInfo = null;
    String className = null;
    String factoryRefName = null;
    String factoryClassName = null;
    String factoryMethodName = null;
    String[] parameterClassNames = null;
    ObjectInfo[] parameterInfos = null;

    public ConstructorInfo(Element constructorElement, ObjectFactoryParser configParser) {
        if (constructorElement.hasAttribute("class")) {
            this.className = constructorElement.getAttribute("class");
        }
        if (constructorElement.hasAttribute("factory")) {
            this.factoryRefName = constructorElement.getAttribute("factory");
            if (!constructorElement.hasAttribute("method")) {
                throw new JbpmException("factory element in constructor requires method attribute in constructor: " + XmlUtil.toString(constructorElement));
            }
            this.factoryMethodName = constructorElement.getAttribute("method");
        } else if (constructorElement.hasAttribute("factory-class")) {
            this.factoryClassName = constructorElement.getAttribute("factory-class");
            if (!constructorElement.hasAttribute("method")) {
                throw new JbpmException("factory-class element in constructor requires method attribute in constructor: " + XmlUtil.toString(constructorElement));
            }
            this.factoryMethodName = constructorElement.getAttribute("method");
        } else if (constructorElement.hasAttribute("method")) {
            throw new JbpmException("'method' element in constructor requires 'factory' of 'factory-class' attribute in constructor: " + XmlUtil.toString(constructorElement));
        }
        List parameterElements = XmlUtil.elements(constructorElement, "parameter");
        this.parameterClassNames = new String[parameterElements.size()];
        this.parameterInfos = new ObjectInfo[parameterElements.size()];
        for (int i = 0; i < parameterElements.size(); ++i) {
            Element parameterElement = (Element)parameterElements.get(i);
            if (!parameterElement.hasAttribute("class")) {
                throw new JbpmException("parameter element must have a class attribute: " + XmlUtil.toString(parameterElement));
            }
            this.parameterClassNames[i] = parameterElement.getAttribute("class");
            Element parameterInfoElement = XmlUtil.element(parameterElement);
            if (parameterInfoElement == null) {
                throw new JbpmException("parameter element must have exactly 1 child element: " + XmlUtil.toString(parameterElement));
            }
            this.parameterInfos[i] = configParser.parse(parameterInfoElement);
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        Object newObject = null;
        Object[] args = this.getArgs(objectFactory);
        Class[] parameterTypes = this.getParameterTypes(objectFactory);
        if (this.factoryRefName != null || this.factoryClassName != null) {
            Object factory = null;
            Class<?> factoryClass = null;
            if (this.factoryRefName != null) {
                factory = objectFactory.getObject(this.factoryRefName);
                factoryClass = factory.getClass();
            } else {
                factoryClass = ClassLoaderUtil.loadClass(this.factoryClassName);
            }
            try {
                Method factoryMethod = this.findMethod(factoryClass, parameterTypes);
                newObject = factoryMethod.invoke(factory, args);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't create new bean with factory method '" + factoryClass.getName() + "." + this.factoryMethodName, e);
            }
        }
        String className = this.className != null ? this.className : this.beanInfo.getClassName();
        Class clazz = objectFactory.loadClass(className);
        try {
            Constructor constructor = clazz.getDeclaredConstructor(parameterTypes);
            newObject = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't instantiate new '" + className + "' with constructor", e);
        }
        return newObject;
    }

    protected Class[] getParameterTypes(ObjectFactoryImpl objectFactory) {
        int nbrOfParameters = this.parameterClassNames != null ? this.parameterClassNames.length : 0;
        Class[] parameterTypes = new Class[nbrOfParameters];
        for (int i = 0; i < nbrOfParameters; ++i) {
            parameterTypes[i] = objectFactory.loadClass(this.parameterClassNames[i]);
        }
        return parameterTypes;
    }

    protected Object[] getArgs(ObjectFactoryImpl objectFactory) {
        int nbrOfParameters = this.parameterClassNames != null ? this.parameterClassNames.length : 0;
        Object[] args = new Object[nbrOfParameters];
        for (int i = 0; i < nbrOfParameters; ++i) {
            args[i] = objectFactory.getObject(this.parameterInfos[i]);
        }
        return args;
    }

    public Method findMethod(Class clazz, Class[] parameterTypes) {
        Method method = null;
        Class candidateClass = clazz;
        while (candidateClass != null && method == null) {
            try {
                method = clazz.getDeclaredMethod(this.factoryMethodName, parameterTypes);
            }
            catch (NoSuchMethodException e1) {
                candidateClass = candidateClass.getSuperclass();
            }
        }
        if (method == null) {
            throw new JbpmException("couldn't find factory method '" + this.factoryMethodName + "' in class '" + clazz.getName() + "'");
        }
        return method;
    }
}

