/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;

public class JbpmSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    Configuration configuration = null;
    Settings settings;
    Mapping mapping = null;
    String[] createSql = null;
    String[] dropSql = null;
    String[] cleanSql = null;
    ConnectionProvider connectionProvider = null;
    Connection connection = null;
    Statement statement = null;
    static String sqlDelimiter = null;
    private static final Log log = LogFactory.getLog(JbpmSchema.class);

    public JbpmSchema(Configuration configuration) {
        this.configuration = configuration;
        this.settings = configuration.buildSettings();
        this.mapping = configuration.buildMapping();
    }

    public String[] getCreateSql() {
        if (this.createSql == null) {
            this.createSql = this.configuration.generateSchemaCreationScript(this.settings.getDialect());
        }
        return this.createSql;
    }

    public String[] getDropSql() {
        if (this.dropSql == null) {
            this.dropSql = this.configuration.generateDropSchemaScript(this.settings.getDialect());
        }
        return this.dropSql;
    }

    public String[] getCleanSql() {
        if (this.cleanSql == null) {
            new SchemaExport(this.configuration);
            Dialect dialect = this.settings.getDialect();
            String catalog = this.settings.getDefaultCatalogName();
            String schema = this.settings.getDefaultSchemaName();
            ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
            ArrayList<String> createForeignKeysSql = new ArrayList<String>();
            Iterator iter = this.configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    String sqlDropString = fk.sqlDropString(dialect, catalog, schema);
                    dropForeignKeysSql.add(sqlDropString);
                    String sqlCreateString = fk.sqlCreateString(dialect, this.mapping, catalog, schema);
                    createForeignKeysSql.add(sqlCreateString);
                }
            }
            ArrayList<String> deleteSql = new ArrayList<String>();
            iter = this.configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                deleteSql.add("delete from " + table.getName());
            }
            ArrayList<String> cleanSqlList = new ArrayList<String>();
            cleanSqlList.addAll(dropForeignKeysSql);
            cleanSqlList.addAll(deleteSql);
            cleanSqlList.addAll(createForeignKeysSql);
            this.cleanSql = cleanSqlList.toArray(new String[cleanSqlList.size()]);
        }
        return this.cleanSql;
    }

    public boolean hasJbpmTables() {
        return this.getJbpmTables().size() > 0;
    }

    public List getJbpmTables() {
        ArrayList<String> jbpmTableNames = new ArrayList<String>();
        Iterator iter = this.configuration.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!table.isPhysicalTable()) continue;
            jbpmTableNames.add(table.getName());
        }
        return jbpmTableNames;
    }

    public Map getJbpmTablesRecordCount() {
        HashMap<String, Integer> recordCounts = new HashMap<String, Integer>();
        String sql = null;
        try {
            Iterator iter = this.getJbpmTables().iterator();
            this.createConnection();
            while (iter.hasNext()) {
                this.statement = this.connection.createStatement();
                String tableName = (String)iter.next();
                sql = "SELECT COUNT(*) FROM " + tableName;
                ResultSet resultSet = this.statement.executeQuery(sql);
                resultSet.next();
                int count = resultSet.getInt(1);
                resultSet.close();
                this.statement.close();
                recordCounts.put(tableName, count);
            }
        }
        catch (SQLException e) {
            throw new JbpmException("couldn't execute sql '" + sql + "'", e);
        }
        finally {
            this.closeConnection();
        }
        return recordCounts;
    }

    public void dropSchema() {
        this.execute(this.getDropSql());
    }

    public void createSchema() {
        this.execute(this.getCreateSql());
    }

    public void cleanSchema() {
        if (this.getJbpmTables().size() > 0) {
            this.execute(this.getCleanSql());
        }
    }

    public void saveSqlScripts(String dir, String prefix) {
        try {
            new File(dir).mkdirs();
            this.saveSqlScript(dir + "/" + prefix + ".drop.sql", this.getDropSql());
            this.saveSqlScript(dir + "/" + prefix + ".create.sql", this.getCreateSql());
            this.saveSqlScript(dir + "/" + prefix + ".clean.sql", this.getCleanSql());
            new SchemaExport(this.configuration).setDelimiter(this.getSqlDelimiter()).setOutputFile(dir + "/" + prefix + ".drop.create.sql").create(true, false);
        }
        catch (IOException e) {
            throw new JbpmException("couldn't generate scripts", e);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            JbpmSchema.syntax();
        } else if ("create".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).createSchema();
        } else if ("drop".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).dropSchema();
        } else if ("clean".equalsIgnoreCase(args[0]) && args.length <= 3) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 1);
            new JbpmSchema(configuration).cleanSchema();
        } else if ("scripts".equalsIgnoreCase(args[0]) && args.length >= 3 && args.length <= 5) {
            Configuration configuration = JbpmSchema.createConfiguration(args, 3);
            new JbpmSchema(configuration).saveSqlScripts(args[1], args[2]);
        } else {
            JbpmSchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("syntax:");
        System.err.println("JbpmSchema create [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema drop [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema clean [<hibernate.cfg.xml> [<hibernate.properties>]]");
        System.err.println("JbpmSchema scripts <dir> <prefix> [<hibernate.cfg.xml> [<hibernate.properties>]]");
    }

    static Configuration createConfiguration(String[] args, int index) {
        String hibernateCfgXml = args.length > index ? args[index] : "hibernate.cfg.xml";
        String hibernateProperties = args.length > index + 1 ? args[index + 1] : null;
        Configuration configuration = new Configuration();
        configuration.configure(new File(hibernateCfgXml));
        if (hibernateProperties != null) {
            try {
                Properties properties = new Properties();
                FileInputStream inputStream = new FileInputStream(hibernateProperties);
                properties.load(inputStream);
                configuration.setProperties(properties);
            }
            catch (IOException e) {
                throw new JbpmException("couldn't load hibernate configuration", e);
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveSqlScript(String fileName, String[] sql) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        try {
            PrintStream printStream = new PrintStream(fileOutputStream);
            for (int i = 0; i < sql.length; ++i) {
                printStream.println(sql[i] + this.getSqlDelimiter());
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                log.debug((Object)"failed to close file", (Throwable)e);
            }
        }
    }

    public void execute(String[] sqls) {
        String sql = null;
        boolean showSql = this.settings.isShowSqlEnabled();
        try {
            this.createConnection();
            this.statement = this.connection.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                sql = sqls[i];
                if (showSql) {
                    log.debug((Object)sql);
                }
                this.statement.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            throw new JbpmException("couldn't execute sql '" + sql + "'", e);
        }
        finally {
            this.closeConnection();
        }
    }

    void closeConnection() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.debug((Object)"could not close jdbc statement", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                JDBCExceptionReporter.logWarnings((SQLWarning)this.connection.getWarnings());
                this.connection.clearWarnings();
                this.connectionProvider.closeConnection(this.connection);
                this.connectionProvider.close();
            }
            catch (SQLException e) {
                log.debug((Object)"could not close jdbc connection", (Throwable)e);
            }
        }
    }

    void createConnection() throws SQLException {
        this.connectionProvider = this.settings.getConnectionProvider();
        this.connection = this.connectionProvider.getConnection();
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    synchronized String getSqlDelimiter() {
        if (sqlDelimiter == null) {
            sqlDelimiter = this.getProperties().getProperty("jbpm.sql.delimiter", ";");
        }
        return sqlDelimiter;
    }
}

