/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import bsh.Interpreter;
import bsh.TargetError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Script
extends Action
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected String expression = null;
    protected Set variableAccesses = null;
    private static final Log log = LogFactory.getLog(Script.class);

    public void read(Element scriptElement, JpdlXmlReader jpdlReader) {
        if (scriptElement.isTextOnly()) {
            this.expression = scriptElement.getText();
        } else {
            this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(scriptElement));
            this.expression = scriptElement.element("expression").getText();
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        Map outputMap = this.eval(executionContext);
        this.setVariables(outputMap, executionContext);
    }

    public Map eval(Token token) throws Exception {
        return this.eval(new ExecutionContext(token));
    }

    public Map eval(ExecutionContext executionContext) throws Exception {
        Map inputMap = this.createInputMap(executionContext);
        Set outputNames = this.getOutputNames();
        return this.eval(inputMap, outputNames);
    }

    public Map createInputMap(ExecutionContext executionContext) {
        HashMap<String, Object> inputMap;
        block3: {
            ContextInstance contextInstance;
            Token token;
            block2: {
                token = executionContext.getToken();
                inputMap = new HashMap<String, Object>();
                inputMap.put("executionContext", executionContext);
                inputMap.put("token", token);
                inputMap.put("node", executionContext.getNode());
                inputMap.put("task", executionContext.getTask());
                inputMap.put("taskInstance", executionContext.getTaskInstance());
                contextInstance = executionContext.getContextInstance();
                if (this.hasReadableVariable()) break block2;
                Map variables = contextInstance.getVariables(token);
                if (variables == null) break block3;
                for (Map.Entry entry : variables.entrySet()) {
                    String variableName = (String)entry.getKey();
                    Object variableValue = entry.getValue();
                    inputMap.put(variableName, variableValue);
                }
                break block3;
            }
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                String mappedName = variableAccess.getMappedName();
                Object variableValue = contextInstance.getVariable(variableName, token);
                inputMap.put(mappedName, variableValue);
            }
        }
        return inputMap;
    }

    public Map eval(Map inputMap, Set outputNames) throws Exception {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            log.debug((Object)("script input: " + inputMap));
            Interpreter interpreter = new Interpreter();
            for (String inputName : inputMap.keySet()) {
                Object inputValue = inputMap.get(inputName);
                interpreter.set(inputName, inputValue);
            }
            interpreter.eval(this.expression);
            for (String outputName : outputNames) {
                Object outputValue = interpreter.get(outputName);
                outputMap.put(outputName, outputValue);
            }
            log.debug((Object)("script output: " + outputMap));
        }
        catch (TargetError e) {
            throw new DelegationException("script evaluation exception", e.getTarget());
        }
        catch (Exception e) {
            log.warn((Object)"exception during evaluation of script expression", (Throwable)e);
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
        return outputMap;
    }

    public void addVariableAccess(VariableAccess variableAccess) {
        if (this.variableAccesses == null) {
            this.variableAccesses = new HashSet();
        }
        this.variableAccesses.add(variableAccess);
    }

    Set getOutputNames() {
        HashSet<String> outputNames = new HashSet<String>();
        if (this.variableAccesses != null) {
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isWritable()) continue;
                outputNames.add(variableAccess.getMappedName());
            }
        }
        return outputNames;
    }

    boolean hasReadableVariable() {
        if (this.variableAccesses == null) {
            return false;
        }
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isReadable()) continue;
            return true;
        }
        return false;
    }

    void setVariables(Map outputMap, ExecutionContext executionContext) {
        if (outputMap != null && !outputMap.isEmpty() && executionContext != null) {
            Map variableNames = this.getVariableNames();
            ContextInstance contextInstance = executionContext.getContextInstance();
            Token token = executionContext.getToken();
            for (String mappedName : outputMap.keySet()) {
                String variableName = (String)variableNames.get(mappedName);
                contextInstance.setVariable(variableName, outputMap.get(mappedName), token);
            }
        }
    }

    Map getVariableNames() {
        HashMap<String, String> variableNames = new HashMap<String, String>();
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isWritable()) continue;
            variableNames.put(variableAccess.getMappedName(), variableAccess.getVariableName());
        }
        return variableNames;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Set getVariableAccesses() {
        return this.variableAccesses;
    }

    public void setVariableAccesses(Set variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

