/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.filesystem.server.LogReader;

public class AccessLogParser
implements LogReader.LogParser {
    private static Pattern regPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)\\] \"(.*)\" (\\d+) ([\\-\\d]+) \"(.*)\" \"(.*)\" (\\d+)");

    public LogReader.Log nextLog(BufferedReader dataIS) throws IOException {
        String line = dataIS.readLine();
        if (line == null) {
            return null;
        }
        try {
            Matcher m = regPattern.matcher(line);
            if (m.matches()) {
                LogReader.Log log = new LogReader.Log();
                log.ip = m.group(1);
                log.date = m.group(3);
                String request = m.group(4);
                log.returnCode = this.parse(m.group(5));
                log.sizeBytes = this.parseLong(m.group(6));
                log.referrer = m.group(7);
                log.client = m.group(8);
                log.msecs = this.parseLong(m.group(9));
                String[] reqss = request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0];
                    log.path = reqss[1];
                    log.http = reqss[2];
                }
                return log;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cant parse " + line);
        }
        return null;
    }

    private int parse(String s) {
        if (s.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private long parseLong(String s) {
        if (s.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s);
    }
}

