/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thredds.filesystem.server.AccessLogParser;
import ucar.unidata.util.StringUtil;

public class LogReader {
    private int maxLines = -1;
    private LogParser parser;

    public LogReader(LogParser parser) {
        this.parser = parser;
    }

    public void readAll(File dir, FileFilter ff, Closure closure, LogFilter logf, Stats stat) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            System.out.printf("Dir has no files= %s%n", dir);
            return;
        }
        List<File> list = Arrays.asList(files);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            File f = list.get(i);
            if (ff != null && !ff.accept(f)) continue;
            if (f.isDirectory()) {
                this.readAll(f, ff, closure, logf, stat);
                continue;
            }
            this.scanLogFile(f, closure, logf, stat);
        }
    }

    public void scanLogFile(File file, Closure closure, LogFilter logf, Stats stat) throws IOException {
        Log log;
        FileInputStream ios = new FileInputStream(file);
        System.out.printf("-----Reading %s %n", file.getPath());
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios), 40000);
        int total = 0;
        int count = 0;
        while ((this.maxLines < 0 || count < this.maxLines) && (log = this.parser.nextLog(dataIS)) != null) {
            ++total;
            if (logf != null && !logf.pass(log)) continue;
            closure.process(log);
            ++count;
        }
        if (stat != null) {
            stat.total += (long)total;
            stat.passed += (long)count;
        }
        ((InputStream)ios).close();
        System.out.printf("----- %s total requests=%d passed=%d %n", file.getPath(), total, count);
    }

    public static void main(String[] args) throws IOException {
        LogReader reader = new LogReader(new AccessLogParser());
        long startElapsed = System.nanoTime();
        Stats stats = new Stats();
        reader.readAll(new File("d:/motherlode/logs/all/"), new MyFF(), new Closure(){
            long count = 0L;

            public void process(Log log) throws IOException {
                if (this.count % 1000L == 0L) {
                    System.out.printf("%s %s %s%n", log.path, log.client, log.ip);
                }
                ++this.count;
            }
        }, new MyFilter(), stats);
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.printf(" total= %d passed=%d%n", stats.total, stats.passed);
        System.out.printf(" elapsed=%d secs%n", elapsedTime / 1000000000L);
    }

    static class MyFF
    implements FileFilter {
        MyFF() {
        }

        public boolean accept(File f) {
            return f.getPath().endsWith(".log");
        }
    }

    static class MyFilter
    implements LogFilter {
        MyFilter() {
        }

        public boolean pass(Log log) {
            return log.path.startsWith("/thredds/catalog/");
        }
    }

    public static class Stats {
        public long total;
        public long passed;
    }

    public static interface LogFilter {
        public boolean pass(Log var1);
    }

    public static interface Closure {
        public void process(Log var1) throws IOException;
    }

    public static class Log {
        String ip;
        String date;
        String referrer;
        String client;
        int returnCode;
        long msecs;
        long sizeBytes;
        String verb;
        String path;
        String http;

        public String getIp() {
            return this.ip;
        }

        public String getDate() {
            return this.date;
        }

        public String getReferrer() {
            return this.referrer;
        }

        public String getClient() {
            return this.client;
        }

        public int getStatus() {
            return this.returnCode;
        }

        public long getMsecs() {
            return this.msecs;
        }

        public long getBytes() {
            return this.sizeBytes;
        }

        public String getPath() {
            return this.path == null ? null : StringUtil.unescape(this.path);
        }

        public String toCSV() {
            return this.ip + "," + this.date + "," + this.verb + ",\"" + this.getPath() + "\"," + this.returnCode + "," + this.sizeBytes + ",\"" + this.referrer + "\",\"" + this.client + "\"," + this.msecs;
        }

        public String toString() {
            return this.ip + " [" + this.date + "] " + this.verb + " " + this.getPath() + " " + this.http + " " + this.returnCode + " " + this.sizeBytes + " " + this.referrer + " " + this.client + " " + this.msecs;
        }
    }

    public static interface LogParser {
        public Log nextLog(BufferedReader var1) throws IOException;
    }
}

