/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;

public class ArraySequence
extends ArrayStructure {
    private StructureDataIterator iter;
    private int count;

    protected ArraySequence(StructureMembers sm, int[] shape) {
        super(sm, shape);
    }

    public ArraySequence(StructureMembers members, StructureDataIterator iter, int count) {
        super(members, new int[]{0});
        this.iter = iter;
        this.count = count;
    }

    public Class getElementType() {
        return StructureDataIterator.class;
    }

    public StructureDataIterator getStructureDataIterator() throws IOException {
        this.iter = this.iter.reset();
        return this.iter;
    }

    public int getStructureDataCount() {
        return this.count;
    }

    public long getSizeBytes() {
        return this.count * this.members.getStructureSize();
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    public Array extractMemberArray(StructureMembers.Member m) throws IOException {
        Array result;
        if (m.getDataArray() != null) {
            return m.getDataArray();
        }
        DataType dataType = m.getDataType();
        boolean isScalar = m.getSize() == 1 || dataType == DataType.SEQUENCE;
        int[] mshape = m.getShape();
        int rrank = 1 + mshape.length;
        int[] rshape = new int[rrank];
        rshape[0] = this.count;
        System.arraycopy(mshape, 0, rshape, 1, mshape.length);
        if (dataType == DataType.STRUCTURE) {
            StructureMembers membersw = new StructureMembers(m.getStructureMembers());
            result = new ArrayStructureW(membersw, rshape);
        } else {
            result = Array.factory(dataType.getPrimitiveClassType(), rshape);
        }
        StructureDataIterator sdataIter = this.getStructureDataIterator();
        IndexIterator resultIter = result.getIndexIterator();
        while (sdataIter.hasNext()) {
            Object[] data;
            StructureData sdata = sdataIter.next();
            if (isScalar) {
                if (dataType == DataType.DOUBLE) {
                    resultIter.setDoubleNext(sdata.getScalarDouble(m));
                    continue;
                }
                if (dataType == DataType.FLOAT) {
                    resultIter.setFloatNext(sdata.getScalarFloat(m));
                    continue;
                }
                if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                    resultIter.setByteNext(sdata.getScalarByte(m));
                    continue;
                }
                if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                    resultIter.setShortNext(sdata.getScalarShort(m));
                    continue;
                }
                if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                    resultIter.setIntNext(sdata.getScalarInt(m));
                    continue;
                }
                if (dataType == DataType.LONG) {
                    resultIter.setLongNext(sdata.getScalarLong(m));
                    continue;
                }
                if (dataType == DataType.CHAR) {
                    resultIter.setCharNext(sdata.getScalarChar(m));
                    continue;
                }
                if (dataType == DataType.STRING) {
                    resultIter.setObjectNext(sdata.getScalarString(m));
                    continue;
                }
                if (dataType == DataType.STRUCTURE) {
                    resultIter.setObjectNext(sdata.getScalarStructure(m));
                    continue;
                }
                if (dataType != DataType.SEQUENCE) continue;
                resultIter.setObjectNext(sdata.getArraySequence(m));
                continue;
            }
            if (dataType == DataType.DOUBLE) {
                for (double aData : data = sdata.getJavaArrayDouble(m)) {
                    resultIter.setDoubleNext(aData);
                }
                continue;
            }
            if (dataType == DataType.FLOAT) {
                for (double aData : data = (Object[])sdata.getJavaArrayFloat(m)) {
                    resultIter.setFloatNext((float)aData);
                }
                continue;
            }
            if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                for (double aData : data = (Object[])sdata.getJavaArrayByte(m)) {
                    resultIter.setByteNext((byte)aData);
                }
                continue;
            }
            if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                for (double aData : data = (Object[])sdata.getJavaArrayShort(m)) {
                    resultIter.setShortNext((short)aData);
                }
                continue;
            }
            if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                for (double aData : data = (Object[])sdata.getJavaArrayInt(m)) {
                    resultIter.setIntNext((int)aData);
                }
                continue;
            }
            if (dataType == DataType.LONG) {
                for (double aData : data = (Object[])sdata.getJavaArrayLong(m)) {
                    resultIter.setLongNext((long)aData);
                }
                continue;
            }
            if (dataType == DataType.CHAR) {
                for (double aData : data = (Object[])sdata.getJavaArrayChar(m)) {
                    resultIter.setCharNext((char)aData);
                }
                continue;
            }
            if (dataType == DataType.STRING) {
                for (double aData : data = (Object[])sdata.getJavaArrayString(m)) {
                    resultIter.setObjectNext(aData);
                }
                continue;
            }
            if (dataType != DataType.STRUCTURE) continue;
            ArrayStructure as = sdata.getArrayStructure(m);
            StructureDataIterator innerIter = as.getStructureDataIterator();
            while (innerIter.hasNext()) {
                resultIter.setObjectNext(innerIter.next());
            }
        }
        return result;
    }

    public String toString() {
        return "Seq@" + this.hashCode();
    }
}

