/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAdapter;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public abstract class OneNestedPointCollectionImpl
implements NestedPointFeatureCollection {
    private String name;
    private FeatureType collectionFeatureType;
    protected int npts;

    protected OneNestedPointCollectionImpl(String name, FeatureType collectionFeatureType) {
        this.name = name;
        this.collectionFeatureType = collectionFeatureType;
        this.npts = -1;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.npts;
    }

    protected void setSize(int npts) {
        this.npts = npts;
    }

    public boolean isMultipleNested() {
        return false;
    }

    public FeatureType getCollectionFeatureType() {
        return this.collectionFeatureType;
    }

    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " (single nested) PointFeatureCollection does not implement getNestedPointFeatureCollectionIterator()");
    }

    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return new NestedPointFeatureCollectionFlatten(this, boundingBox, dateRange);
    }

    private class NestedPointFeatureCollectionFlatten
    extends PointCollectionImpl {
        protected OneNestedPointCollectionImpl from;
        protected LatLonRect boundingBox;
        protected DateRange dateRange;

        NestedPointFeatureCollectionFlatten(OneNestedPointCollectionImpl from, LatLonRect filter_bb, DateRange filter_date) {
            super(from.getName());
            this.from = from;
            this.boundingBox = filter_bb;
            this.dateRange = filter_date;
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorAdapter(this.from.getPointFeatureCollectionIterator(bufferSize), this.boundingBox, this.dateRange);
        }
    }
}

