/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class Ndbc
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        if (!ds.findAttValueIgnoreCase(null, "Conventions", "").equalsIgnoreCase("COARDS")) {
            return false;
        }
        String dataProvider = ds.findAttValueIgnoreCase(null, "data_provider", null);
        if (dataProvider == null) {
            dataProvider = ds.findAttValueIgnoreCase(null, "institution", "");
        }
        if (!dataProvider.contains("National Data Buoy Center")) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "station", null)) {
            return false;
        }
        if (null == ds.findAttValueIgnoreCase(null, "location", null)) {
            return false;
        }
        return ds.hasUnlimitedDimension();
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        boolean isPsuedo;
        CoordinateAxis axis;
        Dimension obsDim = ds.getUnlimitedDimension();
        if (obsDim == null && (axis = CoordSysEvaluator.findCoordByType(ds, AxisType.Time)) != null && axis.isScalar()) {
            obsDim = axis.getDimension(0);
        }
        if (obsDim == null) {
            errlog.format("Must have an Observation dimension: unlimited dimension, or from Time Coordinate", new Object[0]);
            return null;
        }
        boolean bl = isPsuedo = !obsDim.isUnlimited();
        if (wantFeatureType == FeatureType.POINT) {
            TableConfig nt = new TableConfig(Table.Type.Structure, isPsuedo ? obsDim.getName() : "record");
            nt.structName = "record";
            nt.isPsuedoStructure = isPsuedo;
            nt.featureType = FeatureType.POINT;
            CoordSysEvaluator.findCoords(nt, ds);
            return nt;
        }
        TableConfig nt = new TableConfig(Table.Type.Top, "station");
        nt.featureType = FeatureType.STATION;
        nt.lat = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lat);
        nt.lon = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lon);
        nt.stnId = ds.findAttValueIgnoreCase(null, "station", null);
        nt.stnDesc = ds.findAttValueIgnoreCase(null, "description", null);
        if (nt.stnDesc == null) {
            nt.stnDesc = ds.findAttValueIgnoreCase(null, "comment", null);
        }
        TableConfig obs = new TableConfig(Table.Type.Structure, isPsuedo ? obsDim.getName() : "record");
        obs.structName = "record";
        obs.isPsuedoStructure = isPsuedo;
        obs.dim = obsDim;
        obs.time = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Time);
        nt.addChild(obs);
        return nt;
    }
}

