/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dorade;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.DoradeSweep;
import ucar.atd.dorade.ScanMode;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.dorade.Doradeheader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Doradeiosp
extends AbstractIOServiceProvider {
    protected boolean readonly;
    private RandomAccessFile myRaf;
    protected Doradeheader headerParser;
    public DoradeSweep mySweep = null;
    boolean littleEndian;
    protected boolean fill;
    protected HashMap dimHash = new HashMap(50);

    public boolean isValidFile(RandomAccessFile raf) {
        return Doradeheader.isValidFile(raf);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.myRaf = raf;
        try {
            this.mySweep = new DoradeSweep(raf.getRandomAccessFile());
        }
        catch (DoradeSweep.DoradeSweepException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.mySweep.getScanMode(0) != ScanMode.MODE_SUR) {
            System.err.println("ScanMode is : " + this.mySweep.getScanMode(0).getName());
        }
        try {
            this.headerParser = new Doradeheader();
            this.headerParser.read(this.mySweep, ncfile, null);
        }
        catch (DoradeSweep.DoradeSweepException e) {
            e.printStackTrace();
        }
        ncfile.finish();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Array outputData;
        int nSensor = this.mySweep.getNSensors();
        int nRays = this.mySweep.getNRays();
        if (v2.getName().equals("elevation")) {
            float[] elev = this.mySweep.getElevations();
            outputData = this.readData1(v2, section, elev);
        } else if (v2.getName().equals("rays_time")) {
            Date[] dd = this.mySweep.getTimes();
            double[] d = new double[dd.length];
            for (int i = 0; i < dd.length; ++i) {
                d[i] = dd[i].getTime();
            }
            outputData = this.readData2(v2, section, d);
        } else if (v2.getName().equals("azimuth")) {
            float[] azim = this.mySweep.getAzimuths();
            outputData = this.readData1(v2, section, azim);
        } else if (v2.getName().startsWith("latitudes_")) {
            float[] allLats = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] lats = this.mySweep.getLatitudes(i);
                System.arraycopy(lats, 0, allLats, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allLats);
        } else if (v2.getName().startsWith("longitudes_")) {
            float[] allLons = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] lons = this.mySweep.getLongitudes(i);
                System.arraycopy(lons, 0, allLons, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allLons);
        } else if (v2.getName().startsWith("altitudes_")) {
            float[] allAlts = new float[nSensor * nRays];
            for (int i = 0; i < nSensor; ++i) {
                float[] alts = this.mySweep.getAltitudes(i);
                System.arraycopy(alts, 0, allAlts, i * nRays, nRays);
            }
            outputData = this.readData1(v2, section, allAlts);
        } else if (v2.getName().startsWith("distance_")) {
            int j = 0;
            for (int i = 0; i < nSensor; ++i) {
                String t = "" + i;
                if (!v2.getName().endsWith(t)) continue;
                j = i;
                break;
            }
            int nc = this.mySweep.getNCells(j);
            Array data = Array.makeArray(DataType.FLOAT, nc, this.mySweep.getRangeToFirstCell(j), this.mySweep.getCellSpacing(j));
            float[] dist = (float[])data.get1DJavaArray(Float.class);
            outputData = this.readData1(v2, section, dist);
        } else if (v2.isScalar()) {
            float d = 0.0f;
            if (v2.getName().equals("Range_to_First_Cell")) {
                d = this.mySweep.getRangeToFirstCell(0);
            } else if (v2.getName().equals("Cell_Spacing")) {
                d = this.mySweep.getCellSpacing(0);
            } else if (v2.getName().equals("Fixed_Angle")) {
                d = this.mySweep.getFixedAngle();
            } else if (v2.getName().equals("Nyquist_Velocity")) {
                d = this.mySweep.getUnambiguousVelocity(0);
            } else if (v2.getName().equals("Unambiguous_Range")) {
                d = this.mySweep.getunambiguousRange(0);
            } else if (v2.getName().equals("Radar_Constant")) {
                d = this.mySweep.getradarConstant(0);
            } else if (v2.getName().equals("rcvr_gain")) {
                d = this.mySweep.getrcvrGain(0);
            } else if (v2.getName().equals("ant_gain")) {
                d = this.mySweep.getantennaGain(0);
            } else if (v2.getName().equals("sys_gain")) {
                d = this.mySweep.getsystemGain(0);
            } else if (v2.getName().equals("bm_width")) {
                d = this.mySweep.gethBeamWidth(0);
            }
            float[] dd = new float[]{d};
            outputData = Array.factory(v2.getDataType().getPrimitiveClassType(), v2.getShape(), (Object)dd);
        } else {
            Range radialRange = section.getRange(0);
            Range gateRange = section.getRange(1);
            Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
            IndexIterator ii = data.getIndexIterator();
            DoradePARM dp = this.mySweep.lookupParamIgnoreCase(v2.getName());
            int ncells = dp.getNCells();
            float[] rayValues = new float[ncells];
            for (int r = radialRange.first(); r <= radialRange.last(); r += radialRange.stride()) {
                try {
                    rayValues = this.mySweep.getRayData(dp, r, rayValues);
                }
                catch (DoradeSweep.DoradeSweepException ex) {
                    ex.printStackTrace();
                }
                for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
                    ii.setFloatNext(rayValues[i]);
                }
            }
            return data;
        }
        return outputData;
    }

    public Array readData1(Variable v2, Section section, float[] values) {
        Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        Range radialRange = section.getRange(0);
        for (int r = radialRange.first(); r <= radialRange.last(); r += radialRange.stride()) {
            ii.setFloatNext(values[r]);
        }
        return data;
    }

    public Array readData2(Variable v2, Section section, double[] values) {
        Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        Range radialRange = section.getRange(0);
        for (int r = radialRange.first(); r <= radialRange.last(); r += radialRange.stride()) {
            ii.setDoubleNext(values[r]);
        }
        return data;
    }

    public void flush() throws IOException {
        this.myRaf.flush();
    }

    public void close() throws IOException {
        this.myRaf.close();
    }

    public static void main(String[] args) throws IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/dorade/swp.1020511015815.SP0L.573.1.2_SUR_v1";
        NetcdfFile.registerIOProvider(Doradeiosp.class);
        NetcdfFile ncf = NetcdfFile.open(fileIn);
        RandomAccessFile file = new RandomAccessFile(fileIn, "r");
    }
}

