/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.fysat;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.fysat.AwxFileFirstHeader;
import ucar.nc2.iosp.fysat.AwxFileGeoSatelliteSecondHeader;
import ucar.nc2.iosp.fysat.AwxFileGridProductSecondHeader;
import ucar.nc2.iosp.fysat.AwxFileSecondHeader;
import ucar.nc2.iosp.fysat.UnsupportedDatasetException;
import ucar.nc2.iosp.fysat.util.EndianByteBuffer;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public final class FysatHeader {
    private boolean debug = false;
    private boolean debugPos = false;
    private boolean debugString = false;
    private boolean debugHeaderSize = false;
    private RandomAccessFile raf;
    private NetcdfFile ncfile;
    private static Logger log = LoggerFactory.getLogger(FysatHeader.class);
    int numrecs = 0;
    int recsize = 0;
    int recStart = 0;
    int FY_AWX_PIB_LEN = 40;
    double DEG_TO_RAD = 0.017453292;
    double EARTH_RAD_KMETERS = 6371.2;
    byte Z_DEFLATED = (byte)8;
    byte DEF_WBITS = (byte)15;
    private long actualSize;
    private long calcSize;
    protected int Z_type = 0;
    private AwxFileFirstHeader firstHeader;
    private AwxFileSecondHeader secondHeader;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            this.actualSize = raf.length();
        }
        catch (IOException e) {
            return false;
        }
        if (!raf.getLocation().endsWith(".AWX") && !raf.getLocation().endsWith(".awx")) {
            return false;
        }
        try {
            return this.readPIB(raf);
        }
        catch (IOException e) {
            return false;
        }
    }

    boolean readPIB(RandomAccessFile raf) throws IOException {
        this.firstHeader = new AwxFileFirstHeader();
        this.raf = raf;
        int pos = 0;
        raf.seek(pos);
        byte[] buf = new byte[this.FY_AWX_PIB_LEN];
        int count = raf.read(buf);
        EndianByteBuffer byteBuffer = null;
        if (count == this.FY_AWX_PIB_LEN) {
            byteBuffer = new EndianByteBuffer(buf);
            this.firstHeader.fillHeader(byteBuffer);
            if (this.firstHeader.byteOrder != EndianByteBuffer.LITTLE_ENDIAN) {
                byteBuffer = new EndianByteBuffer(buf, EndianByteBuffer.BIG_ENDIAN);
            }
        } else {
            return false;
        }
        if (!this.firstHeader.fileName.endsWith(".AWX") && !this.firstHeader.fileName.endsWith(".awx") || this.firstHeader.firstHeaderLength != this.FY_AWX_PIB_LEN) {
            return false;
        }
        buf = new byte[this.firstHeader.secondHeaderLength];
        raf.read(buf);
        byteBuffer = new EndianByteBuffer(buf, this.firstHeader.byteOrder);
        switch (this.firstHeader.typeOfProduct) {
            case 0: {
                throw new UnsupportedDatasetException();
            }
            case 1: {
                this.secondHeader = new AwxFileGeoSatelliteSecondHeader();
                this.secondHeader.fillHeader(byteBuffer);
                break;
            }
            case 2: {
                throw new UnsupportedDatasetException();
            }
            case 3: {
                this.secondHeader = new AwxFileGridProductSecondHeader();
                this.secondHeader.fillHeader(byteBuffer);
                break;
            }
            case 4: {
                throw new UnsupportedDatasetException();
            }
            case 5: {
                throw new UnsupportedDatasetException();
            }
        }
        return true;
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        if (this.firstHeader == null && this.secondHeader == null) {
            this.readPIB(raf);
        }
        this.actualSize = raf.length();
        Attribute att = new Attribute("version", this.firstHeader.version);
        this.ncfile.addAttribute(null, att);
        switch (this.firstHeader.typeOfProduct) {
            case 0: {
                throw new UnsupportedDatasetException();
            }
            case 1: {
                Dimension dimY;
                Dimension dimX;
                double lon0;
                double lat0;
                AwxFileGeoSatelliteSecondHeader geoSatelliteSecondHeader = (AwxFileGeoSatelliteSecondHeader)this.secondHeader;
                att = new Attribute("satellite_name", geoSatelliteSecondHeader.satelliteName);
                this.ncfile.addAttribute(null, att);
                SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                dformat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Calendar cal = Calendar.getInstance();
                cal.set(geoSatelliteSecondHeader.year, geoSatelliteSecondHeader.month - 1, geoSatelliteSecondHeader.day, geoSatelliteSecondHeader.hour, geoSatelliteSecondHeader.minute);
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                String dstring = dformat.format(cal.getTime());
                this.ncfile.addAttribute(null, new Attribute("time_coverage", dstring));
                int nz = 1;
                Dimension dimT = new Dimension("time", nz, true, false, false);
                ncfile.addDimension(null, dimT);
                String timeCoordName = "time";
                Variable taxis = new Variable(ncfile, null, null, timeCoordName);
                taxis.setDataType(DataType.DOUBLE);
                taxis.setDimensions("time");
                taxis.addAttribute(new Attribute("long_name", "time since base date"));
                taxis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                double[] tdata = new double[]{cal.getTimeInMillis()};
                Array dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{1}, (Object)tdata);
                taxis.setCachedData(dataA, false);
                DateFormatter formatter = new DateFormatter();
                taxis.addAttribute(new Attribute("units", "msecs since " + formatter.toDateTimeStringISO(new Date(0L))));
                ncfile.addVariable(null, taxis);
                Integer ni = new Integer(geoSatelliteSecondHeader.widthOfImage);
                att = new Attribute("NX", ni);
                this.ncfile.addAttribute(null, att);
                ni = new Integer(geoSatelliteSecondHeader.heightOfImage);
                att = new Attribute("NY", ni);
                this.ncfile.addAttribute(null, att);
                String vname = this.getGeoSatelliteProductName(geoSatelliteSecondHeader.channel);
                if (vname == null) {
                    throw new UnsupportedDatasetException("Unsupported GeoSatellite Procuct Dataset");
                }
                ProjectionImpl projection = null;
                double dxKm = 0.0;
                double dyKm = 0.0;
                short nv = geoSatelliteSecondHeader.flagOfProjection;
                att = new Attribute("ProjIndex", nv);
                this.ncfile.addAttribute(null, att);
                short proj = nv;
                if (proj == 2) {
                    att = new Attribute("ProjName", "MERCATOR");
                    lat0 = geoSatelliteSecondHeader.centerLatitudeOfProjection;
                    lon0 = geoSatelliteSecondHeader.centerLongitudeOfProjection;
                    double par = geoSatelliteSecondHeader.standardLatitude1;
                    dxKm = geoSatelliteSecondHeader.horizontalResolution;
                    dyKm = geoSatelliteSecondHeader.verticalResolution;
                    projection = new Mercator(lon0, par);
                } else if (proj == 1) {
                    att = new Attribute("ProjName", "LAMBERT_CONFORNAL");
                    lat0 = geoSatelliteSecondHeader.centerLatitudeOfProjection;
                    lon0 = geoSatelliteSecondHeader.centerLongitudeOfProjection;
                    double par1 = geoSatelliteSecondHeader.standardLatitude1;
                    double par2 = geoSatelliteSecondHeader.standardLatitude2;
                    dxKm = geoSatelliteSecondHeader.horizontalResolution / 100;
                    dyKm = geoSatelliteSecondHeader.verticalResolution / 100;
                    projection = new LambertConformal(lat0, lon0, par1, par2);
                } else if (proj == 3) {
                    att = new Attribute("ProjName", "POLARSTEREOGRAPHIC");
                    double latt = geoSatelliteSecondHeader.centerLatitudeOfProjection;
                    double lont = geoSatelliteSecondHeader.centerLongitudeOfProjection;
                    double scale = (1.0 + Math.sin(this.DEG_TO_RAD * latt)) / 2.0;
                    dxKm = geoSatelliteSecondHeader.horizontalResolution;
                    dyKm = geoSatelliteSecondHeader.verticalResolution;
                    projection = new Stereographic(90.0, lont, scale);
                } else if (proj == 4) {
                    att = new Attribute("ProjName", "LatLonProjection");
                    projection = new LatLonProjection();
                }
                this.ncfile.addAttribute(null, att);
                if (proj != 4) {
                    // empty if block
                }
                this.ncfile.addAttribute(null, new Attribute("channel", geoSatelliteSecondHeader.channel));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", new Float(geoSatelliteSecondHeader.latitudeOfSouth)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", new Float(geoSatelliteSecondHeader.latitudeOfNorth)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", new Float(geoSatelliteSecondHeader.longitudeOfWest)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", new Float(geoSatelliteSecondHeader.longitudeOfEast)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_min", new Float(0.0)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_max", new Float(0.0)));
                this.ncfile.addAttribute(null, new Attribute("sample_ratio", geoSatelliteSecondHeader.sampleRatio));
                att = new Attribute("horizontal_resolution", geoSatelliteSecondHeader.horizontalResolution);
                this.ncfile.addAttribute(null, att);
                att = new Attribute("vertical_resolution", geoSatelliteSecondHeader.verticalResolution);
                this.ncfile.addAttribute(null, att);
                Variable var = new Variable(ncfile, ncfile.getRootGroup(), null, vname);
                var.addAttribute(new Attribute("long_name", vname));
                boolean isRecord = false;
                short nx = geoSatelliteSecondHeader.widthOfImage;
                short ny = geoSatelliteSecondHeader.heightOfImage;
                if (proj != 4) {
                    dimX = new Dimension("x", nx, true, false, false);
                    dimY = new Dimension("y", ny, true, false, false);
                } else {
                    dimX = new Dimension("lon", nx, true, false, false);
                    dimY = new Dimension("lat", ny, true, false, false);
                }
                ncfile.addDimension(null, dimY);
                ncfile.addDimension(null, dimX);
                int byteAmountofData = 1;
                int velems = dimX.getLength() * dimY.getLength() * byteAmountofData;
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                dims.add(dimT);
                dims.add(dimY);
                dims.add(dimX);
                var.setDimensions(dims);
                Class dataType = null;
                switch (byteAmountofData) {
                    case 1: {
                        var.setDataType(DataType.BYTE);
                        dataType = DataType.BYTE.getPrimitiveClassType();
                        break;
                    }
                    case 2: {
                        var.setDataType(DataType.SHORT);
                        dataType = DataType.SHORT.getPrimitiveClassType();
                        break;
                    }
                    case 4: {
                        var.setDataType(DataType.INT);
                        dataType = DataType.INT.getPrimitiveClassType();
                        break;
                    }
                    default: {
                        System.out.println("Unsupported Grid Procuct Dataset!");
                        throw new UnsupportedDatasetException("Unsupported Grid Procuct Dataset");
                    }
                }
                var.addAttribute(new Attribute("coordinates", "Lon Lat"));
                var.addAttribute(new Attribute("_unsigned", "false"));
                var.addAttribute(new Attribute("units", "percent"));
                if (var.getDataType() == DataType.BYTE) {
                    var.addAttribute(new Attribute("_missing_value", new Byte(-1)));
                    var.addAttribute(new Attribute("scale_factor", new Byte(1)));
                    var.addAttribute(new Attribute("add_offset", new Byte(0)));
                } else {
                    var.addAttribute(new Attribute("_missing_value", new Short(-1)));
                    var.addAttribute(new Attribute("scale_factor", new Short(1)));
                    var.addAttribute(new Attribute("add_offset", new Short(0)));
                }
                int vsize = velems;
                long begin = this.firstHeader.recordsOfHeader * this.firstHeader.recoderLength;
                if (this.debug) {
                    log.warn(" name= " + vname + " vsize=" + vsize + " velems=" + velems + " begin= " + begin + " isRecord=" + isRecord + "\n");
                }
                var.setSPobject(new Vinfo(vsize, begin, isRecord, nx, ny, dataType, this.firstHeader.byteOrder));
                String coordinates = proj != 4 ? "x y time" : "Lon Lat time";
                var.addAttribute(new Attribute("_CoordinateAxes", coordinates));
                ncfile.addVariable(ncfile.getRootGroup(), var);
                LatLonPointImpl startPnt = new LatLonPointImpl(geoSatelliteSecondHeader.latitudeOfNorth, geoSatelliteSecondHeader.longitudeOfWest);
                LatLonPointImpl endPnt = new LatLonPointImpl(geoSatelliteSecondHeader.latitudeOfSouth, geoSatelliteSecondHeader.longitudeOfEast);
                if (this.debug) {
                    System.out.println("start at geo coord :" + startPnt);
                }
                if (proj != 4) {
                    ProjectionPointImpl start = (ProjectionPointImpl)projection.latLonToProj(new LatLonPointImpl(geoSatelliteSecondHeader.latitudeOfSouth, geoSatelliteSecondHeader.longitudeOfWest));
                    double startx = start.getX();
                    double starty = start.getY();
                    Variable xaxis = new Variable(ncfile, null, null, "x");
                    xaxis.setDataType(DataType.DOUBLE);
                    xaxis.setDimensions("x");
                    xaxis.addAttribute(new Attribute("long_name", "projection x coordinate"));
                    xaxis.addAttribute(new Attribute("units", "km"));
                    xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
                    double[] data = new double[nx];
                    if (proj == 2) {
                        double lon_1 = geoSatelliteSecondHeader.longitudeOfEast;
                        double lon_2 = geoSatelliteSecondHeader.longitudeOfWest;
                        if (lon_1 < 0.0) {
                            lon_1 += 360.0;
                        }
                        if (lon_2 < 0.0) {
                            lon_2 += 360.0;
                        }
                        double dx = (lon_1 - lon_2) / (double)(nx - 1);
                        for (int i = 0; i < data.length; ++i) {
                            double ln = lon_2 + (double)i * dx;
                            ProjectionPointImpl pt = (ProjectionPointImpl)projection.latLonToProj(new LatLonPointImpl(geoSatelliteSecondHeader.latitudeOfSouth, ln));
                            data[i] = pt.getX();
                        }
                    } else {
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = startx + (double)i * dxKm;
                        }
                    }
                    dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{nx}, (Object)data);
                    xaxis.setCachedData(dataA, false);
                    ncfile.addVariable(null, xaxis);
                    Variable yaxis = new Variable(ncfile, null, null, "y");
                    yaxis.setDataType(DataType.DOUBLE);
                    yaxis.setDimensions("y");
                    yaxis.addAttribute(new Attribute("long_name", "projection y coordinate"));
                    yaxis.addAttribute(new Attribute("units", "km"));
                    yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
                    data = new double[ny];
                    double endy = starty + dyKm * (double)(data.length - 1);
                    double lat2 = geoSatelliteSecondHeader.latitudeOfNorth;
                    double lat1 = geoSatelliteSecondHeader.latitudeOfSouth;
                    if (proj == 2) {
                        double dy = (lat2 - lat1) / (double)(ny - 1);
                        for (int i = 0; i < data.length; ++i) {
                            double la = lat2 - (double)i * dy;
                            ProjectionPointImpl pt = (ProjectionPointImpl)projection.latLonToProj(new LatLonPointImpl(la, geoSatelliteSecondHeader.longitudeOfWest));
                            data[i] = pt.getY();
                        }
                    } else {
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = endy - (double)i * dyKm;
                        }
                    }
                    dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{ny}, (Object)data);
                    yaxis.setCachedData(dataA, false);
                    ncfile.addVariable(null, yaxis);
                    Variable ct = new Variable(ncfile, null, null, projection.getClassName());
                    ct.setDataType(DataType.CHAR);
                    ct.setDimensions("");
                    List<Parameter> params = projection.getProjectionParameters();
                    for (int i = 0; i < params.size(); ++i) {
                        Parameter p = params.get(i);
                        ct.addAttribute(new Attribute(p));
                    }
                    ct.addAttribute(new Attribute("_CoordinateTransformType", "Projection"));
                    ct.addAttribute(new Attribute("_CoordinateAxes", "x, y"));
                    dataA = Array.factory(DataType.CHAR.getPrimitiveClassType(), new int[0]);
                    dataA.setChar(dataA.getIndex(), ' ');
                    ct.setCachedData(dataA, false);
                    ncfile.addVariable(null, ct);
                    ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
                    break;
                }
                Variable yaxis = new Variable(ncfile, null, null, "lat");
                yaxis.setDataType(DataType.DOUBLE);
                yaxis.setDimensions("lat");
                yaxis.addAttribute(new Attribute("long_name", "latitude"));
                yaxis.addAttribute(new Attribute("units", "degree"));
                yaxis.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
                double[] data = new double[ny];
                double dy = (endPnt.getLatitude() - startPnt.getLatitude()) / (double)(ny - 1);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = startPnt.getLatitude() + (double)i * dy;
                }
                dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{ny}, (Object)data);
                yaxis.setCachedData(dataA, false);
                ncfile.addVariable(null, yaxis);
                Variable xaxis = new Variable(ncfile, null, null, "lon");
                xaxis.setDataType(DataType.DOUBLE);
                xaxis.setDimensions("lon");
                xaxis.addAttribute(new Attribute("long_name", "longitude"));
                xaxis.addAttribute(new Attribute("units", "degree"));
                xaxis.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
                data = new double[nx];
                double dx = (endPnt.getLongitude() - startPnt.getLongitude()) / (double)(nx - 1);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = startPnt.getLongitude() + (double)i * dx;
                }
                dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{nx}, (Object)data);
                xaxis.setCachedData(dataA, false);
                ncfile.addVariable(null, xaxis);
                break;
            }
            case 2: {
                throw new UnsupportedDatasetException();
            }
            case 3: {
                AwxFileGridProductSecondHeader gridprocuctSecondHeader = (AwxFileGridProductSecondHeader)this.secondHeader;
                att = new Attribute("satellite_name", gridprocuctSecondHeader.satelliteName);
                this.ncfile.addAttribute(null, att);
                att = new Attribute("grid_feature", gridprocuctSecondHeader.gridFeature);
                this.ncfile.addAttribute(null, att);
                att = new Attribute("byte_amount_of_data", gridprocuctSecondHeader.byteAmountofData);
                this.ncfile.addAttribute(null, att);
                att = new Attribute("data_scale", gridprocuctSecondHeader.dataScale);
                this.ncfile.addAttribute(null, att);
                SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                dformat.setTimeZone(TimeZone.getTimeZone("GMT"));
                Calendar cal = Calendar.getInstance();
                cal.set(gridprocuctSecondHeader.startYear, gridprocuctSecondHeader.startMonth - 1, gridprocuctSecondHeader.startDay, gridprocuctSecondHeader.startHour, gridprocuctSecondHeader.startMinute, 0);
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                String dstring = dformat.format(cal.getTime());
                this.ncfile.addAttribute(null, new Attribute("time_coverage_start", dstring));
                int nz = 1;
                Dimension dimT = new Dimension("time", nz, true, false, false);
                ncfile.addDimension(null, dimT);
                String timeCoordName = "time";
                Variable taxis = new Variable(ncfile, null, null, timeCoordName);
                taxis.setDataType(DataType.DOUBLE);
                taxis.setDimensions("time");
                taxis.addAttribute(new Attribute("long_name", "time since base date"));
                taxis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                double[] tdata = new double[]{cal.getTimeInMillis()};
                Array dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{1}, (Object)tdata);
                taxis.setCachedData(dataA, false);
                DateFormatter formatter = new DateFormatter();
                taxis.addAttribute(new Attribute("units", "msecs since " + formatter.toDateTimeStringISO(new Date(0L))));
                ncfile.addVariable(null, taxis);
                cal.set(gridprocuctSecondHeader.endYear, gridprocuctSecondHeader.endMonth - 1, gridprocuctSecondHeader.endDay, gridprocuctSecondHeader.endHour, gridprocuctSecondHeader.endMinute, 0);
                dstring = dformat.format(cal.getTime());
                this.ncfile.addAttribute(null, new Attribute("time_coverage_end", dstring));
                Integer ni = new Integer(gridprocuctSecondHeader.amountofHorizontalSpacing);
                att = new Attribute("NX", ni);
                this.ncfile.addAttribute(null, att);
                ni = new Integer(gridprocuctSecondHeader.amountofVerticalSpacing);
                att = new Attribute("NY", ni);
                this.ncfile.addAttribute(null, att);
                Byte nv = 0;
                att = new Attribute("ProjIndex", nv);
                this.ncfile.addAttribute(null, att);
                int proj = nv.intValue();
                if (proj == 1) {
                    att = new Attribute("ProjName", "MERCATOR");
                } else if (proj == 3) {
                    att = new Attribute("ProjName", "LAMBERT_CONFORNAL");
                } else if (proj == 5) {
                    att = new Attribute("ProjName", "POLARSTEREOGRAPGIC");
                }
                this.ncfile.addAttribute(null, att);
                Object projection = null;
                double dxKm = 0.0;
                double dyKm = 0.0;
                this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", new Float(gridprocuctSecondHeader.rightBottomLat)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", new Float(gridprocuctSecondHeader.leftTopLat)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", new Float(gridprocuctSecondHeader.leftTopLon)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", new Float(gridprocuctSecondHeader.rightBottomLon)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_min", new Float(0.0)));
                this.ncfile.addAttribute(null, new Attribute("geospatial_vertical_max", new Float(0.0)));
                this.ncfile.addAttribute(null, new Attribute("spacing_unit", gridprocuctSecondHeader.getSpacingUnit()));
                this.ncfile.addAttribute(null, new Attribute("horizontal_spacing", gridprocuctSecondHeader.horizontalSpacing));
                this.ncfile.addAttribute(null, new Attribute("vertical_spacing", gridprocuctSecondHeader.verticalSpacing));
                this.ncfile.addAttribute(null, new Attribute("amount_of_horizontal_spacing", gridprocuctSecondHeader.amountofHorizontalSpacing));
                this.ncfile.addAttribute(null, new Attribute("amount_of_vertical_spacing", gridprocuctSecondHeader.amountofVerticalSpacing));
                String vname = this.getGridProductName(gridprocuctSecondHeader.gridFeature);
                if (vname == null) {
                    throw new UnsupportedDatasetException("Unsupported Grid Procuct Dataset");
                }
                Variable var = new Variable(ncfile, ncfile.getRootGroup(), null, vname);
                var.addAttribute(new Attribute("long_name", vname));
                var.addAttribute(new Attribute("units", this.getPhysElemUnits(gridprocuctSecondHeader.gridFeature)));
                boolean isRecord = false;
                short nx = gridprocuctSecondHeader.amountofHorizontalSpacing;
                short ny = gridprocuctSecondHeader.amountofVerticalSpacing;
                Dimension dimX = new Dimension("lon", nx, true, false, false);
                Dimension dimY = new Dimension("lat", ny, true, false, false);
                ncfile.addDimension(null, dimY);
                ncfile.addDimension(null, dimX);
                int velems = dimX.getLength() * dimY.getLength() * gridprocuctSecondHeader.byteAmountofData;
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                dims.add(dimT);
                dims.add(dimY);
                dims.add(dimX);
                var.setDimensions(dims);
                Class dataType = null;
                switch (gridprocuctSecondHeader.byteAmountofData) {
                    case 1: {
                        var.setDataType(DataType.BYTE);
                        dataType = DataType.BYTE.getPrimitiveClassType();
                        break;
                    }
                    case 2: {
                        var.setDataType(DataType.SHORT);
                        dataType = DataType.SHORT.getPrimitiveClassType();
                        break;
                    }
                    case 4: {
                        var.setDataType(DataType.INT);
                        dataType = DataType.INT.getPrimitiveClassType();
                        break;
                    }
                    default: {
                        System.out.println("Unsupported Grid Procuct Dataset!");
                        throw new UnsupportedDatasetException("Unsupported Grid Procuct Dataset");
                    }
                }
                var.addAttribute(new Attribute("coordinates", "lon lat"));
                var.addAttribute(new Attribute("_Unsigned", "true"));
                if (var.getDataType() == DataType.BYTE) {
                    var.addAttribute(new Attribute("_missing_value", new Byte(-1)));
                    var.addAttribute(new Attribute("add_offset", gridprocuctSecondHeader.dataBaseValue));
                    var.addAttribute(new Attribute("scale_factor", gridprocuctSecondHeader.dataBaseValue));
                } else {
                    var.addAttribute(new Attribute("_missing_value", new Short(-1)));
                    var.addAttribute(new Attribute("add_offset", gridprocuctSecondHeader.dataBaseValue));
                    var.addAttribute(new Attribute("scale_factor", gridprocuctSecondHeader.dataScale));
                }
                int vsize = velems;
                long begin = this.firstHeader.recordsOfHeader * this.firstHeader.recoderLength;
                if (this.debug) {
                    log.warn(" name= " + vname + " vsize=" + vsize + " velems=" + velems + " begin= " + begin + " isRecord=" + isRecord + "\n");
                }
                var.setSPobject(new Vinfo(vsize, begin, isRecord, nx, ny, dataType, this.firstHeader.byteOrder));
                String coordinates = "lon lat time";
                var.addAttribute(new Attribute("_CoordinateAxes", coordinates));
                ncfile.addVariable(ncfile.getRootGroup(), var);
                LatLonPointImpl startPnt = new LatLonPointImpl(gridprocuctSecondHeader.leftTopLat, gridprocuctSecondHeader.leftTopLon);
                LatLonPointImpl endPnt = new LatLonPointImpl(gridprocuctSecondHeader.rightBottomLat, gridprocuctSecondHeader.rightBottomLon);
                if (this.debug) {
                    System.out.println("start at geo coord :" + startPnt);
                }
                Variable yaxis = new Variable(ncfile, null, null, "lat");
                yaxis.setDataType(DataType.DOUBLE);
                yaxis.setDimensions("lat");
                yaxis.addAttribute(new Attribute("long_name", "latitude"));
                yaxis.addAttribute(new Attribute("units", "degree_north"));
                yaxis.addAttribute(new Attribute("_CoordinateAxisType", "latitude"));
                double[] data = new double[ny];
                double dy = (endPnt.getLatitude() - startPnt.getLatitude()) / (double)(ny - 1);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = startPnt.getLatitude() + (double)i * dy;
                }
                dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{ny}, (Object)data);
                yaxis.setCachedData(dataA, false);
                ncfile.addVariable(null, yaxis);
                Variable xaxis = new Variable(ncfile, null, null, "lon");
                xaxis.setDataType(DataType.DOUBLE);
                xaxis.setDimensions("lon");
                xaxis.addAttribute(new Attribute("long_name", "longitude"));
                xaxis.addAttribute(new Attribute("units", "degree_east"));
                xaxis.addAttribute(new Attribute("_CoordinateAxisType", "longitude"));
                data = new double[nx];
                double dx = (endPnt.getLongitude() - startPnt.getLongitude()) / (double)(nx - 1);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = startPnt.getLongitude() + (double)i * dx;
                }
                dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{nx}, (Object)data);
                xaxis.setCachedData(dataA, false);
                ncfile.addVariable(null, xaxis);
                break;
            }
            case 4: {
                throw new UnsupportedDatasetException();
            }
            case 5: {
                throw new UnsupportedDatasetException();
            }
        }
        ncfile.finish();
    }

    String getGeoSatelliteProductName(int channel) {
        String vname;
        switch (channel) {
            case 1: {
                vname = "IR";
                break;
            }
            case 2: {
                vname = "WV";
                break;
            }
            case 3: {
                vname = "IR_WV";
                break;
            }
            case 4: {
                vname = "VIS";
                break;
            }
            case 34: {
                vname = "DST";
                break;
            }
            default: {
                System.out.println("Unsupported GeoSatellite Procuct Dataset!");
                return null;
            }
        }
        return vname;
    }

    String getGridProductName(int feature) {
        String vname;
        switch (feature) {
            case 1: {
                vname = "SST";
                break;
            }
            case 2: {
                vname = "SeaICE";
                break;
            }
            case 3: {
                vname = "SeaICEDensity";
                break;
            }
            case 4: {
                vname = "LongWaveRadiation";
                break;
            }
            case 5: {
                vname = "plantIdx";
                break;
            }
            case 6: {
                vname = "plantIdxRatio";
                break;
            }
            case 7: {
                vname = "snow";
                break;
            }
            case 8: {
                vname = "soilHumidity";
                break;
            }
            case 9: {
                vname = "sunshine";
                break;
            }
            case 10: {
                vname = "cloudTopHeight";
                break;
            }
            case 11: {
                vname = "cloudTopTemp";
                break;
            }
            case 12: {
                vname = "lowCloudVolume";
                break;
            }
            case 13: {
                vname = "highCloudVolume";
                break;
            }
            case 14: {
                vname = "precipIdx1hour";
                break;
            }
            case 15: {
                vname = "precipIdx6hour";
                break;
            }
            case 16: {
                vname = "precipIdx12hour";
                break;
            }
            case 17: {
                vname = "precipIdx24hour";
                break;
            }
            case 18: {
                vname = "waterVapor";
                break;
            }
            case 19: {
                vname = "cloudTemp";
                break;
            }
            case 501: {
                vname = "TOVS";
                break;
            }
            case 502: {
                vname = "TOVS";
                break;
            }
            case 503: {
                vname = "TOVS";
                break;
            }
            case 504: {
                vname = "TOVS";
                break;
            }
            case 505: {
                vname = "TOVS";
                break;
            }
            case 506: {
                vname = "TOVS";
                break;
            }
            case 507: {
                vname = "TOVS";
                break;
            }
            default: {
                System.out.println("Unsupported Satellite Grid Procuct Dataset!");
                return null;
            }
        }
        return vname;
    }

    String getPhysElemUnits(int feature) {
        String unit;
        switch (feature) {
            case 1: {
                unit = "K";
                break;
            }
            case 2: {
                unit = "";
                break;
            }
            case 3: {
                unit = "";
                break;
            }
            case 4: {
                unit = "W/m2";
                break;
            }
            case 5: {
                unit = "";
                break;
            }
            case 6: {
                unit = "";
                break;
            }
            case 7: {
                unit = "";
                break;
            }
            case 8: {
                unit = "kg/m3";
                break;
            }
            case 9: {
                unit = "hour";
                break;
            }
            case 10: {
                unit = "hPa";
                break;
            }
            case 11: {
                unit = "K";
                break;
            }
            case 12: {
                unit = "";
                break;
            }
            case 13: {
                unit = "";
                break;
            }
            case 14: {
                unit = "mm/hour";
                break;
            }
            case 15: {
                unit = "mm/(6 hour)";
                break;
            }
            case 16: {
                unit = "mm/(12 hour)";
                break;
            }
            case 17: {
                unit = "mm/(24 hour)";
                break;
            }
            case 18: {
                unit = "";
                break;
            }
            case 19: {
                unit = "K";
                break;
            }
            case 501: {
                unit = "";
                break;
            }
            case 502: {
                unit = "mm";
                break;
            }
            case 503: {
                unit = "Db";
                break;
            }
            case 504: {
                unit = "W/m2";
                break;
            }
            case 505: {
                unit = "hPa";
                break;
            }
            case 506: {
                unit = "K";
                break;
            }
            case 507: {
                unit = "";
                break;
            }
            default: {
                System.out.println("Unsupported Satellite Grid Procuct Dataset!");
                return null;
            }
        }
        return unit;
    }

    int getCompressType() {
        return this.Z_type;
    }

    class Vinfo {
        int vsize;
        long begin;
        boolean isRecord;
        int nx;
        int ny;
        Class classType;
        short byteOrder;

        Vinfo(int vsize, long begin, boolean isRecord, int x, int y, Class dt, short byteOrder) {
            this.vsize = vsize;
            this.begin = begin;
            this.isRecord = isRecord;
            this.nx = x;
            this.ny = y;
            this.classType = dt;
            this.byteOrder = byteOrder;
        }
    }
}

