/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.types.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttributedURI
extends URI {
    public AttributedURI(URI uri) {
        super(uri);
    }

    public AttributedURI(String uri) throws URI.MalformedURIException {
        this(new URI(uri));
    }

    public AttributedURI() {
    }

    public AttributedURI(SOAPHeaderElement el) throws Exception {
        super(new URI(TextExtractor.getText((SOAPElement)el)));
    }

    public void append(Element parent, String elementName) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElementNS(AddressingUtils.getAddressingNamespaceURI(), elementName);
        child.appendChild(doc.createTextNode(this.toString()));
        parent.appendChild(child);
    }

    protected SOAPHeaderElement toSOAPHeaderElement(SOAPEnvelope env, String actorURI, String name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("A null value for the name parameter is not allowed.");
        }
        Name qname = env.createName(name, "wsa", AddressingUtils.getAddressingNamespaceURI());
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        SOAPHeaderElement headerElement = header.addHeaderElement(qname);
        headerElement.setActor(actorURI);
        headerElement.addTextNode(this.toString());
        return headerElement;
    }
}

