/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiterIterator;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameDelimiter
extends AbstractFilenameComposite {
    private AbstractFilenameComposite afterComposite = null;
    private AbstractFilenameComposite beforeComposite = null;
    private String delimiter = null;

    public FilenameDelimiter() {
    }

    public FilenameDelimiter(FilenameDelimiter copyObject) {
        super(copyObject);
        this.delimiter = copyObject.delimiter;
        this.afterComposite = (AbstractFilenameComposite)TagUtility.copyObject(copyObject.afterComposite);
        this.beforeComposite = (AbstractFilenameComposite)TagUtility.copyObject(copyObject.beforeComposite);
    }

    public void setAfterComposite(AbstractFilenameComposite afterComposite) {
        this.afterComposite = afterComposite;
    }

    public AbstractFilenameComposite getAfterComposite() {
        return this.afterComposite;
    }

    public void setBeforeComposite(AbstractFilenameComposite beforeComposite) {
        this.beforeComposite = beforeComposite;
    }

    public AbstractFilenameComposite getBeforeComposite() {
        return this.beforeComposite;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (frame != null) {
            if (this.beforeComposite != null) {
                this.beforeComposite.setFrame(frame);
            }
            if (this.afterComposite != null) {
                this.afterComposite.setFrame(frame);
            }
        }
    }

    public String composeFilename() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.beforeComposite != null) {
            stringBuffer.append(this.beforeComposite.composeFilename());
        }
        stringBuffer.append(this.delimiter);
        stringBuffer.append(' ');
        if (this.afterComposite != null) {
            stringBuffer.append(this.afterComposite.composeFilename());
        }
        return stringBuffer.toString();
    }

    public ID3v2_4 createId3Tag() {
        ID3v2_4 newTag = null;
        if (this.beforeComposite != null) {
            newTag = this.beforeComposite.createId3Tag();
        }
        if (this.afterComposite != null) {
            if (newTag != null) {
                newTag.append(this.afterComposite.createId3Tag());
            } else {
                newTag = this.afterComposite.createId3Tag();
            }
        }
        return newTag;
    }

    public Iterator iterator() {
        return new FilenameDelimiterIterator(this);
    }

    public void matchAgainstKeyword(Class id3v2FrameBodyClass) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(id3v2FrameBodyClass)) {
            if (this.beforeComposite != null) {
                this.beforeComposite.matchAgainstKeyword(id3v2FrameBodyClass);
            }
            if (this.afterComposite != null) {
                this.afterComposite.matchAgainstKeyword(id3v2FrameBodyClass);
            }
        }
    }

    public void matchAgainstTag(AbstractMP3Tag matchTag) {
        if (matchTag != null) {
            if (this.beforeComposite != null) {
                this.beforeComposite.matchAgainstTag(matchTag);
            }
            if (this.afterComposite != null) {
                this.afterComposite.matchAgainstTag(matchTag);
            }
        }
    }
}

