/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameTag
extends AbstractMP3Tag {
    private AbstractFilenameComposite composite = null;
    private ID3v2_4 id3tag = null;
    private MP3File mp3file = null;
    private String extension = null;

    public FilenameTag(FilenameTag copyObject) {
        super(copyObject);
        this.composite = (AbstractFilenameComposite)TagUtility.copyObject(copyObject.composite);
        this.id3tag = new ID3v2_4(copyObject.id3tag);
        this.mp3file = new MP3File(copyObject.mp3file);
        this.extension = copyObject.extension;
    }

    protected FilenameTag() {
    }

    public void setComposite(AbstractFilenameComposite composite) {
        this.composite = composite;
    }

    public AbstractFilenameComposite getComposite() {
        return this.composite;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (frame != null) {
            if (this.id3tag == null) {
                this.id3tag = new ID3v2_4();
            }
            this.id3tag.setFrame(frame);
            if (this.composite != null) {
                this.composite.setFrame(frame);
            }
        }
    }

    public AbstractID3v2Frame getFrame(String identifier) {
        AbstractID3v2Frame frame = null;
        if (this.id3tag != null) {
            frame = this.id3tag.getFrame(identifier);
        }
        return frame;
    }

    public Iterator getFrameOfType(String identifier) {
        return this.id3tag.getFrameOfType(identifier);
    }

    public void setId3tag(ID3v2_4 id3tag) {
        this.id3tag = id3tag;
        if (id3tag != null) {
            Iterator iterator = id3tag.iterator();
            while (iterator.hasNext()) {
                this.composite.setFrame((AbstractID3v2Frame)iterator.next());
            }
            if (this.composite != null) {
                this.composite.matchAgainstTag(id3tag);
            }
        }
    }

    public ID3v2_4 getId3tag() {
        return this.id3tag;
    }

    public String getIdentifier() {
        return "FilenameTagv1.00";
    }

    public void setMp3file(MP3File mp3file) {
        this.mp3file = mp3file;
    }

    public MP3File getMp3file() {
        return this.mp3file;
    }

    public int getSize() {
        return this.composeFilename().length();
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public void append(RandomAccessFile file) {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public String composeFilename() {
        StringBuffer filename = new StringBuffer(128);
        if (this.composite != null) {
            filename.append(this.composite.composeFilename().trim());
            filename.append('.');
            filename.append(this.extension);
        }
        return filename.toString();
    }

    public void delete(RandomAccessFile file) {
        throw new UnsupportedOperationException("Method delete() not yet implemented.");
    }

    public boolean hasFrame(String identifier) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrame(identifier);
        }
        return false;
    }

    public boolean hasFrameOfType(String identifier) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrameOfType(identifier);
        }
        return false;
    }

    public Iterator iterator() {
        Iterator iterator = null;
        if (this.composite != null) {
            iterator = this.composite.iterator();
        }
        return iterator;
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method overwrite() not yet implemented.");
    }

    public void overwrite(RandomAccessFile file) throws TagException, IOException {
        this.write(file);
    }

    public void read(RandomAccessFile file) {
        throw new UnsupportedOperationException("Method read() not yet implemented.");
    }

    public boolean seek(RandomAccessFile file) {
        throw new UnsupportedOperationException("Method seek() not yet implemented.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        return stringBuffer.toString();
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        throw new UnsupportedOperationException("Method write() not yet implemented.");
    }

    public void write(RandomAccessFile file) throws IOException, TagException {
        File originalFile = this.getMp3file().getMp3file();
        File newFile = new File(originalFile.getParentFile(), this.composeFilename());
        if (!newFile.getName().equals(originalFile.getName())) {
            file.getFD().sync();
            file.getChannel().close();
            file.close();
            TagUtility.copyFile(originalFile, newFile);
            if (!originalFile.delete()) {
                throw new TagException("Unable to delete original file: " + originalFile.getName());
            }
        }
    }

    public String getSongTitle() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TIT2");
        if (frame != null) {
            FrameBodyTIT2 body = (FrameBodyTIT2)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getLeadArtist() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TPE1");
        if (frame != null) {
            FrameBodyTPE1 body = (FrameBodyTPE1)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getAlbumTitle() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TALB");
        if (frame != null) {
            FrameBodyTALB body = (FrameBodyTALB)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getYearReleased() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TDRC");
        if (frame != null) {
            FrameBodyTDRC body = (FrameBodyTDRC)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongComment() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("COMM");
        if (frame != null) {
            FrameBodyCOMM body = (FrameBodyCOMM)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongGenre() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TCON");
        if (frame != null) {
            FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getTrackNumberOnAlbum() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TRCK");
        if (frame != null) {
            FrameBodyTRCK body = (FrameBodyTRCK)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongLyric() {
        AbstractID3v2FrameBody body;
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("SYLT");
        if (frame != null) {
            body = (FrameBodySYLT)frame.getBody();
            text = ((FrameBodySYLT)body).getLyric();
        }
        if (text == null && (frame = this.getFrame("USLT")) != null) {
            body = (FrameBodyUSLT)frame.getBody();
            text = ((FrameBodyUSLT)body).getLyric();
        }
        return text.trim();
    }

    public String getAuthorComposer() {
        String text = null;
        AbstractID3v2Frame frame = this.getFrame("TCOM");
        if (frame != null) {
            FrameBodyTCOM body = (FrameBodyTCOM)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public void setSongTitle(String songTitle) {
        AbstractID3v2Frame field = this.getFrame("TIT2");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTIT2(0, songTitle.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTIT2)field.getBody()).setText(songTitle.trim());
        }
    }

    public void setLeadArtist(String leadArtist) {
        AbstractID3v2Frame field = this.getFrame("TPE1");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTPE1(0, leadArtist.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTPE1)field.getBody()).setText(leadArtist.trim());
        }
    }

    public void setAlbumTitle(String albumTitle) {
        AbstractID3v2Frame field = this.getFrame("TALB");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTALB(0, albumTitle.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTALB)field.getBody()).setText(albumTitle.trim());
        }
    }

    public void setYearReleased(String yearReleased) {
        AbstractID3v2Frame field = this.getFrame("TDRC");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTDRC(0, yearReleased.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTDRC)field.getBody()).setText(yearReleased.trim());
        }
    }

    public void setSongComment(String songComment) {
        AbstractID3v2Frame field = this.getFrame("COMM");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyCOMM(0, "ENG", "", songComment.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyCOMM)field.getBody()).setText(songComment.trim());
        }
    }

    public void setSongGenre(String songGenre) {
        AbstractID3v2Frame field = this.getFrame("TCON");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTCON(0, songGenre.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTCON)field.getBody()).setText(songGenre.trim());
        }
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        AbstractID3v2Frame field = this.getFrame("TRCK");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTRCK(0, trackNumberOnAlbum.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTRCK)field.getBody()).setText(trackNumberOnAlbum.trim());
        }
    }

    public void setSongLyric(String songLyrics) {
        AbstractID3v2Frame field = this.getFrame("SYLT");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyUSLT(0, "ENG", "", songLyrics.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyUSLT)field.getBody()).setLyric(songLyrics.trim());
        }
    }

    public void setAuthorComposer(String authorComposer) {
        AbstractID3v2Frame field = this.getFrame("TCOM");
        if (field == null) {
            field = new ID3v2_3Frame(new FrameBodyTCOM(0, authorComposer.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTCOM)field.getBody()).setText(authorComposer.trim());
        }
    }
}

