/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;

public abstract class AbstractID3v2
extends AbstractID3 {
    private static int paddingCounter = 0;
    private Map frameMap = new HashMap();
    private String duplicateFrameId = null;
    private byte majorVersion = 0;
    private byte revision = 0;
    private int duplicateBytes = 0;
    private int emptyFrameBytes = 0;
    private int fileReadSize = 0;
    private int invalidFrameBytes = 0;
    private int padding = 0;

    protected AbstractID3v2() {
    }

    protected AbstractID3v2(AbstractID3v2 copyObject) {
        super(copyObject);
        this.duplicateFrameId = copyObject.duplicateFrameId;
        this.majorVersion = copyObject.majorVersion;
        this.revision = copyObject.revision;
        this.duplicateBytes = copyObject.duplicateBytes;
        this.emptyFrameBytes = copyObject.emptyFrameBytes;
        this.fileReadSize = copyObject.fileReadSize;
        this.invalidFrameBytes = copyObject.invalidFrameBytes;
        this.padding = copyObject.padding;
        for (String identifier : copyObject.frameMap.keySet()) {
            AbstractID3v2Frame newFrame = (AbstractID3v2Frame)TagUtility.copyObject(copyObject.frameMap.get(identifier));
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (frame.getBody() != null) {
            this.frameMap.put(frame.getIdentifier(), frame);
        }
    }

    public AbstractID3v2Frame getFrame(String identifier) {
        return (AbstractID3v2Frame)this.frameMap.get(identifier);
    }

    public int getFrameCount() {
        int size = 0;
        if (this.frameMap != null) {
            size = this.frameMap.size();
        }
        return size;
    }

    public void clearFrameMap() {
        this.frameMap.clear();
    }

    public Iterator getFrameIterator() {
        return this.frameMap.values().iterator();
    }

    public Iterator getFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        HashSet result = new HashSet(this.frameMap.size());
        while (iterator.hasNext()) {
            String hashSetKey = (String)iterator.next();
            if (!hashSetKey.startsWith(identifier)) continue;
            result.add(this.frameMap.get(hashSetKey));
        }
        return result.iterator();
    }

    public boolean hasFrame(String identifier) {
        return this.frameMap.containsKey(identifier);
    }

    public boolean hasFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String hashMapKey = (String)iterator.next();
            if (!hashMapKey.startsWith(identifier)) continue;
            found = true;
        }
        return found;
    }

    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String identifier) {
        this.frameMap.remove(identifier);
    }

    public void removeFrameOfType(String identifier) {
        Iterator iterator = this.getFrameOfType(identifier);
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            this.frameMap.remove(frame.getIdentifier());
        }
    }

    public Collection values() {
        return this.frameMap.values();
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 oldTag = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 newTag = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = newTag.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                if (oldTag.hasFrame(frame.getIdentifier())) continue;
                oldTag.setFrame(frame);
            }
        }
    }

    public void append(RandomAccessFile file) throws IOException, TagException {
        try {
            ID3v2_4 oldTag = new ID3v2_4(file);
            ((AbstractID3v2)oldTag).append(this);
            ((AbstractMP3FileItem)oldTag).write(file);
        }
        catch (TagNotFoundException ex) {
            try {
                ID3v2_3 oldTag = new ID3v2_3(file);
                ((AbstractID3v2)oldTag).append(this);
                ((AbstractMP3FileItem)oldTag).write(file);
            }
            catch (TagNotFoundException ex2) {
                try {
                    ID3v2_2 oldTag = new ID3v2_2(file);
                    ((AbstractID3v2)oldTag).append(this);
                    ((AbstractMP3FileItem)oldTag).write(file);
                }
                catch (TagNotFoundException ex3) {
                    this.write(file);
                }
            }
        }
    }

    public void delete(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        if (this.seek(file)) {
            file.seek(0L);
            file.write(buffer);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2)) {
            return false;
        }
        AbstractID3v2 abstractID3v2 = (AbstractID3v2)obj;
        if (!((Object)this.frameMap).equals(abstractID3v2.frameMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 oldTag = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 newTag = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = newTag.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                oldTag.setFrame(frame);
            }
        }
    }

    public void overwrite(RandomAccessFile file) throws IOException, TagException {
        try {
            ID3v2_4 oldTag = new ID3v2_4(file);
            ((AbstractID3v2)oldTag).overwrite(this);
            ((AbstractMP3FileItem)oldTag).write(file);
        }
        catch (TagNotFoundException ex) {
            try {
                ID3v2_3 oldTag = new ID3v2_3(file);
                ((AbstractID3v2)oldTag).overwrite(this);
                ((AbstractMP3FileItem)oldTag).write(file);
            }
            catch (TagNotFoundException ex2) {
                try {
                    ID3v2_2 oldTag = new ID3v2_2(file);
                    ((AbstractID3v2)oldTag).overwrite(this);
                    ((AbstractMP3FileItem)oldTag).write(file);
                }
                catch (TagNotFoundException ex3) {
                    this.write(file);
                }
            }
        }
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 oldTag = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 newTag = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = newTag.getFrameIterator();
            oldTag.frameMap.clear();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                oldTag.setFrame(frame);
            }
        }
    }

    protected static int byteArrayToSize(byte[] buffer) {
        return (buffer[0] << 21) + (buffer[1] << 14) + (buffer[2] << 7) + buffer[3];
    }

    protected static byte[] sizeToByteArray(int size) {
        byte[] buffer = new byte[]{(byte)((size & 0xFE00000) >> 21), (byte)((size & 0x1FC000) >> 14), (byte)((size & 0x3F80) >> 7), (byte)(size & 0x7F)};
        return buffer;
    }

    protected static void resetPaddingCounter() {
        paddingCounter = 0;
    }

    protected static void incrementPaddingCounter() {
        ++paddingCounter;
    }

    protected static void decrementPaddingCounter() {
        --paddingCounter;
    }

    protected static int getPaddingCounter() {
        return paddingCounter;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getRevision() {
        return this.revision;
    }

    protected void setRevision(byte revision) {
        this.revision = revision;
    }

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    protected void setFileReadBytes(int fileReadSize) {
        this.fileReadSize = fileReadSize;
    }

    protected void setPaddingSize(int paddingSize) {
        this.padding = paddingSize;
    }

    protected void incrementDuplicateBytes(int duplicateBytes) {
        this.duplicateBytes += duplicateBytes;
    }

    protected void incrementEmptyFrameBytes(int emptyFrameBytes) {
        this.emptyFrameBytes += emptyFrameBytes;
    }

    protected void incrementInvalidFrameBytes() {
        ++this.invalidFrameBytes;
    }

    protected void appendDuplicateFrameId(String duplicateFrameId) {
        this.duplicateFrameId = this.duplicateFrameId + duplicateFrameId;
    }

    public int getInvalidFrameBytes() {
        return this.invalidFrameBytes;
    }

    public int getPaddingSize() {
        return this.padding;
    }
}

