/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.AbstractMP3Fragment;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyAPIC;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyENCR;
import org.farng.mp3.id3.FrameBodyGEOB;
import org.farng.mp3.id3.FrameBodyGRID;
import org.farng.mp3.id3.FrameBodyMCDI;
import org.farng.mp3.id3.FrameBodyPCNT;
import org.farng.mp3.id3.FrameBodyPOPM;
import org.farng.mp3.id3.FrameBodyPRIV;
import org.farng.mp3.id3.FrameBodyRVAD;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTBPM;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTCOP;
import org.farng.mp3.id3.FrameBodyTDAT;
import org.farng.mp3.id3.FrameBodyTDEN;
import org.farng.mp3.id3.FrameBodyTDLY;
import org.farng.mp3.id3.FrameBodyTDOR;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTDRL;
import org.farng.mp3.id3.FrameBodyTDTG;
import org.farng.mp3.id3.FrameBodyTENC;
import org.farng.mp3.id3.FrameBodyTEXT;
import org.farng.mp3.id3.FrameBodyTFLT;
import org.farng.mp3.id3.FrameBodyTIME;
import org.farng.mp3.id3.FrameBodyTIPL;
import org.farng.mp3.id3.FrameBodyTIT1;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTIT3;
import org.farng.mp3.id3.FrameBodyTKEY;
import org.farng.mp3.id3.FrameBodyTLAN;
import org.farng.mp3.id3.FrameBodyTLEN;
import org.farng.mp3.id3.FrameBodyTMCL;
import org.farng.mp3.id3.FrameBodyTMED;
import org.farng.mp3.id3.FrameBodyTMOO;
import org.farng.mp3.id3.FrameBodyTOAL;
import org.farng.mp3.id3.FrameBodyTOFN;
import org.farng.mp3.id3.FrameBodyTOLY;
import org.farng.mp3.id3.FrameBodyTOPE;
import org.farng.mp3.id3.FrameBodyTORY;
import org.farng.mp3.id3.FrameBodyTOWN;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTPE2;
import org.farng.mp3.id3.FrameBodyTPE3;
import org.farng.mp3.id3.FrameBodyTPE4;
import org.farng.mp3.id3.FrameBodyTPOS;
import org.farng.mp3.id3.FrameBodyTPRO;
import org.farng.mp3.id3.FrameBodyTPUB;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.FrameBodyTRDA;
import org.farng.mp3.id3.FrameBodyTRSN;
import org.farng.mp3.id3.FrameBodyTRSO;
import org.farng.mp3.id3.FrameBodyTSIZ;
import org.farng.mp3.id3.FrameBodyTSOA;
import org.farng.mp3.id3.FrameBodyTSOP;
import org.farng.mp3.id3.FrameBodyTSOT;
import org.farng.mp3.id3.FrameBodyTSRC;
import org.farng.mp3.id3.FrameBodyTSSE;
import org.farng.mp3.id3.FrameBodyTSST;
import org.farng.mp3.id3.FrameBodyTXXX;
import org.farng.mp3.id3.FrameBodyTYER;
import org.farng.mp3.id3.FrameBodyUFID;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.FrameBodyUnsupported;
import org.farng.mp3.id3.FrameBodyWCOM;
import org.farng.mp3.id3.FrameBodyWCOP;
import org.farng.mp3.id3.FrameBodyWOAF;
import org.farng.mp3.id3.FrameBodyWOAR;
import org.farng.mp3.id3.FrameBodyWOAS;
import org.farng.mp3.id3.FrameBodyWORS;
import org.farng.mp3.id3.FrameBodyWPAY;
import org.farng.mp3.id3.FrameBodyWPUB;
import org.farng.mp3.id3.FrameBodyWXXX;

public abstract class AbstractID3v2Frame
extends AbstractMP3Fragment {
    protected AbstractID3v2Frame() {
    }

    protected AbstractID3v2Frame(AbstractID3v2FrameBody body) {
        super(body);
    }

    protected AbstractID3v2Frame(AbstractID3v2Frame frame) {
        super(frame);
    }

    public String getIdentifier() {
        String identifier = "";
        if (this.getBody() != null) {
            identifier = this.getBody().getIdentifier();
        }
        return identifier;
    }

    public static boolean isValidID3v2FrameIdentifier(String identifier) {
        boolean valid = true;
        for (int i = 0; i < identifier.length(); ++i) {
            char character = identifier.charAt(i);
            if (character >= 'A' && character <= 'Z' || character >= '0' && character <= '9') continue;
            valid = false;
        }
        return valid;
    }

    public String toString() {
        String string = "";
        if (this.getBody() != null) {
            string = this.getBody().toString();
        }
        return string;
    }

    protected static AbstractID3v2FrameBody readBody(String identifier, RandomAccessFile file) throws IOException, InvalidTagException {
        String frameIdentifier = TagUtility.isID3v2_2FrameIdentifier(identifier) ? TagUtility.convertFrameID2_2to2_4(identifier) : identifier;
        AbstractID3v2FrameBody newBody = "APIC".equals(frameIdentifier) ? new FrameBodyAPIC(file) : ("COMM".equals(frameIdentifier) ? new FrameBodyCOMM(file) : ("ENCR".equals(frameIdentifier) ? new FrameBodyENCR(file) : ("GEOB".equals(frameIdentifier) ? new FrameBodyGEOB(file) : ("GRID".equals(frameIdentifier) ? new FrameBodyGRID(file) : ("MCDI".equals(frameIdentifier) ? new FrameBodyMCDI(file) : ("PCNT".equals(frameIdentifier) ? new FrameBodyPCNT(file) : ("POPM".equals(frameIdentifier) ? new FrameBodyPOPM(file) : ("PRIV".equals(frameIdentifier) ? new FrameBodyPRIV(file) : ("RVAD".equals(frameIdentifier) ? new FrameBodyRVAD(file) : ("SYLT".equals(frameIdentifier) ? new FrameBodySYLT(file) : ("TALB".equals(frameIdentifier) ? new FrameBodyTALB(file) : ("TBPM".equals(frameIdentifier) ? new FrameBodyTBPM(file) : ("TCOM".equals(frameIdentifier) ? new FrameBodyTCOM(file) : ("TCON".equals(frameIdentifier) ? new FrameBodyTCON(file) : ("TCOP".equals(frameIdentifier) ? new FrameBodyTCOP(file) : ("TDAT".equals(frameIdentifier) ? new FrameBodyTDAT(file) : ("TDEN".equals(frameIdentifier) ? new FrameBodyTDEN(file) : ("TDLY".equals(frameIdentifier) ? new FrameBodyTDLY(file) : ("TDOR".equals(frameIdentifier) ? new FrameBodyTDOR(file) : ("TDRC".equals(frameIdentifier) ? new FrameBodyTDRC(file) : ("TDRL".equals(frameIdentifier) ? new FrameBodyTDRL(file) : ("TDTG".equals(frameIdentifier) ? new FrameBodyTDTG(file) : ("TENC".equals(frameIdentifier) ? new FrameBodyTENC(file) : ("TEXT".equals(frameIdentifier) ? new FrameBodyTEXT(file) : ("TFLT".equals(frameIdentifier) ? new FrameBodyTFLT(file) : ("TIME".equals(frameIdentifier) ? new FrameBodyTIME(file) : ("TIPL".equals(frameIdentifier) ? new FrameBodyTIPL(file) : ("TIT1".equals(frameIdentifier) ? new FrameBodyTIT1(file) : ("TIT2".equals(frameIdentifier) ? new FrameBodyTIT2(file) : ("TIT3".equals(frameIdentifier) ? new FrameBodyTIT3(file) : ("TKEY".equals(frameIdentifier) ? new FrameBodyTKEY(file) : ("TLAN".equals(frameIdentifier) ? new FrameBodyTLAN(file) : ("TLEN".equals(frameIdentifier) ? new FrameBodyTLEN(file) : ("TMCL".equals(frameIdentifier) ? new FrameBodyTMCL(file) : ("TMED".equals(frameIdentifier) ? new FrameBodyTMED(file) : ("TMOO".equals(frameIdentifier) ? new FrameBodyTMOO(file) : ("TOAL".equals(frameIdentifier) ? new FrameBodyTOAL(file) : ("TOFN".equals(frameIdentifier) ? new FrameBodyTOFN(file) : ("TOLY".equals(frameIdentifier) ? new FrameBodyTOLY(file) : ("TOPE".equals(frameIdentifier) ? new FrameBodyTOPE(file) : ("TORY".equals(frameIdentifier) ? new FrameBodyTORY(file) : ("TOWN".equals(frameIdentifier) ? new FrameBodyTOWN(file) : ("TPE1".equals(frameIdentifier) ? new FrameBodyTPE1(file) : ("TPE2".equals(frameIdentifier) ? new FrameBodyTPE2(file) : ("TPE3".equals(frameIdentifier) ? new FrameBodyTPE3(file) : ("TPE4".equals(frameIdentifier) ? new FrameBodyTPE4(file) : ("TPOS".equals(frameIdentifier) ? new FrameBodyTPOS(file) : ("TPRO".equals(frameIdentifier) ? new FrameBodyTPRO(file) : ("TPUB".equals(frameIdentifier) ? new FrameBodyTPUB(file) : ("TRCK".equals(frameIdentifier) ? new FrameBodyTRCK(file) : ("TRDA".equals(frameIdentifier) ? new FrameBodyTRDA(file) : ("TRSN".equals(frameIdentifier) ? new FrameBodyTRSN(file) : ("TRSO".equals(frameIdentifier) ? new FrameBodyTRSO(file) : ("TSIZ".equals(frameIdentifier) ? new FrameBodyTSIZ(file) : ("TSOA".equals(frameIdentifier) ? new FrameBodyTSOA(file) : ("TSOP".equals(frameIdentifier) ? new FrameBodyTSOP(file) : ("TSOT".equals(frameIdentifier) ? new FrameBodyTSOT(file) : ("TSRC".equals(frameIdentifier) ? new FrameBodyTSRC(file) : ("TSSE".equals(frameIdentifier) ? new FrameBodyTSSE(file) : ("TSST".equals(frameIdentifier) ? new FrameBodyTSST(file) : ("TXXX".equals(frameIdentifier) ? new FrameBodyTXXX(file) : ("TYER".equals(frameIdentifier) ? new FrameBodyTYER(file) : ("UFID".equals(frameIdentifier) ? new FrameBodyUFID(file) : ("USLT".equals(frameIdentifier) ? new FrameBodyUSLT(file) : ("WCOM".equals(frameIdentifier) ? new FrameBodyWCOM(file) : ("WCOP".equals(frameIdentifier) ? new FrameBodyWCOP(file) : ("WOAF".equals(frameIdentifier) ? new FrameBodyWOAF(file) : ("WOAR".equals(frameIdentifier) ? new FrameBodyWOAR(file) : ("WOAS".equals(frameIdentifier) ? new FrameBodyWOAS(file) : ("WORS".equals(frameIdentifier) ? new FrameBodyWORS(file) : ("WPAY".equals(frameIdentifier) ? new FrameBodyWPAY(file) : ("WPUB".equals(frameIdentifier) ? new FrameBodyWPUB(file) : ("WXXX".equals(frameIdentifier) ? new FrameBodyWXXX(file) : new FrameBodyUnsupported(file))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        return newBody;
    }
}

