/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.FrameBodyTYER;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_2Frame;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;

public class ID3v2_2
extends AbstractID3v2 {
    protected boolean compression = false;
    protected boolean unsynchronization = false;

    public ID3v2_2() {
        this.setMajorVersion((byte)2);
        this.setRevision((byte)2);
    }

    public ID3v2_2(ID3v2_2 copyObject) {
        super(copyObject);
        this.compression = copyObject.compression;
        this.unsynchronization = copyObject.unsynchronization;
    }

    public ID3v2_2(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v2_3) && mp3tag instanceof ID3v2_2) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v2_4 convertedTag = mp3tag instanceof ID3v2_4 ? (ID3v2_4)mp3tag : new ID3v2_4(mp3tag);
            this.compression = convertedTag.compression;
            this.unsynchronization = convertedTag.unsynchronization;
            ID3v2_4 id3tag = convertedTag;
            Iterator iterator = id3tag.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                ID3v2_2Frame newFrame = new ID3v2_2Frame(frame);
                this.setFrame(newFrame);
            }
        }
    }

    public ID3v2_2(RandomAccessFile file) throws TagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "ID3v2_2.20";
    }

    public int getSize() {
        int size = 10;
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            size += frame.getSize();
        }
        return size;
    }

    public void append(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.append(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_2)) {
            return false;
        }
        ID3v2_2 id3v2_2 = (ID3v2_2)obj;
        if (this.compression != id3v2_2.compression) {
            return false;
        }
        if (this.unsynchronization != id3v2_2.unsynchronization) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.overwrite(tag);
    }

    public void read(RandomAccessFile file) throws TagException, IOException {
        byte[] buffer = new byte[4];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v2.20 tag not found");
        }
        file.read(buffer, 0, 3);
        if (buffer[0] != 2 || buffer[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.setMajorVersion(buffer[0]);
        this.setRevision(buffer[1]);
        this.unsynchronization = (buffer[2] & 0x80) != 0;
        this.compression = (buffer[2] & 0x80) != 0;
        file.read(buffer, 0, 4);
        int size = ID3v2_2.byteArrayToSize(buffer);
        this.clearFrameMap();
        long filePointer = file.getFilePointer();
        this.setFileReadBytes(size);
        ID3v2_2.resetPaddingCounter();
        while (file.getFilePointer() - filePointer <= (long)size) {
            try {
                ID3v2_2Frame next = new ID3v2_2Frame(file);
                String id = next.getIdentifier();
                if (this.hasFrame(id)) {
                    this.appendDuplicateFrameId(id + "; ");
                    this.incrementDuplicateBytes(this.getFrame(id).getSize());
                }
                this.setFrame(next);
            }
            catch (InvalidTagException ex) {
                if (ex.getMessage().equals("Found empty frame")) {
                    this.incrementEmptyFrameBytes(10);
                    continue;
                }
                this.incrementInvalidFrameBytes();
            }
        }
        this.setPaddingSize(ID3v2_2.getPaddingCounter());
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        file.seek(0L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        if (!tag.equals("ID3")) {
            return false;
        }
        file.read(buffer, 0, 2);
        file.seek(file.getFilePointer() - 2L);
        return buffer[0] == 2 && buffer[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.getFrameIterator();
        String str = this.getIdentifier() + " - " + this.getSize() + " bytes\n";
        str = str + "compression        = " + this.compression + "\n";
        str = str + "unsynchronization  = " + this.unsynchronization + "\n";
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            str = str + frame.toString() + "\n";
        }
        return str + "\n";
    }

    public void write(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_2) {
            this.unsynchronization = ((ID3v2_2)tag).unsynchronization;
            this.compression = ((ID3v2_2)tag).compression;
        }
        super.write(tag);
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[6];
        MP3File mp3 = new MP3File();
        mp3.seekMP3Frame(file);
        long mp3start = file.getFilePointer();
        file.seek(0L);
        String str = "ID3";
        for (int i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        buffer[3] = 2;
        buffer[4] = 0;
        if (this.unsynchronization) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        if (this.compression) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        file.write(buffer);
        file.write(ID3v2_2.sizeToByteArray((int)mp3start - 10));
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            ID3v2_2Frame frame = (ID3v2_2Frame)iterator.next();
            frame.write(file);
        }
    }

    public String getSongTitle() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TIT2");
        if (frame != null) {
            FrameBodyTIT2 body = (FrameBodyTIT2)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getLeadArtist() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TPE1");
        if (frame != null) {
            FrameBodyTPE1 body = (FrameBodyTPE1)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getAlbumTitle() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TALB");
        if (frame != null) {
            FrameBodyTALB body = (FrameBodyTALB)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getYearReleased() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TYER");
        if (frame != null) {
            FrameBodyTYER body = (FrameBodyTYER)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongComment() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("COMM\u0000eng\u0000");
        if (frame != null) {
            FrameBodyCOMM body = (FrameBodyCOMM)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongGenre() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TCON");
        if (frame != null) {
            FrameBodyTCON body = (FrameBodyTCON)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getTrackNumberOnAlbum() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TRCK");
        if (frame != null) {
            FrameBodyTRCK body = (FrameBodyTRCK)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public String getSongLyric() {
        AbstractID3v2FrameBody body;
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("SYLT");
        if (frame != null) {
            body = (FrameBodySYLT)frame.getBody();
            text = ((FrameBodySYLT)body).getLyric();
        }
        if (text == "" && (frame = this.getFrame("USLT\u0000eng\u0000")) != null) {
            body = (FrameBodyUSLT)frame.getBody();
            text = ((FrameBodyUSLT)body).getLyric();
        }
        return text.trim();
    }

    public String getAuthorComposer() {
        String text = "";
        AbstractID3v2Frame frame = this.getFrame("TCOM");
        if (frame != null) {
            FrameBodyTCOM body = (FrameBodyTCOM)frame.getBody();
            text = body.getText();
        }
        return text.trim();
    }

    public void setSongTitle(String songTitle) {
        AbstractID3v2Frame field = this.getFrame("TIT2");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTIT2(0, songTitle.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTIT2)field.getBody()).setText(songTitle.trim());
        }
    }

    public void setLeadArtist(String leadArtist) {
        AbstractID3v2Frame field = this.getFrame("TPE1");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTPE1(0, leadArtist.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTPE1)field.getBody()).setText(leadArtist.trim());
        }
    }

    public void setAlbumTitle(String albumTitle) {
        AbstractID3v2Frame field = this.getFrame("TALB");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTALB(0, albumTitle.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTALB)field.getBody()).setText(albumTitle.trim());
        }
    }

    public void setYearReleased(String yearReleased) {
        AbstractID3v2Frame field = this.getFrame("TYER");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTYER(0, yearReleased.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTYER)field.getBody()).setText(yearReleased.trim());
        }
    }

    public void setSongComment(String songComment) {
        AbstractID3v2Frame field = this.getFrame("COMM");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyCOMM(0, "eng", "", songComment.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyCOMM)field.getBody()).setText(songComment.trim());
        }
    }

    public void setSongGenre(String songGenre) {
        AbstractID3v2Frame field = this.getFrame("TCON");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTCON(0, songGenre.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTCON)field.getBody()).setText(songGenre.trim());
        }
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        AbstractID3v2Frame field = this.getFrame("TRCK");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTRCK(0, trackNumberOnAlbum.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTRCK)field.getBody()).setText(trackNumberOnAlbum.trim());
        }
    }

    public void setSongLyric(String songLyrics) {
        AbstractID3v2Frame field = this.getFrame("USLT");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyUSLT(0, "ENG", "", songLyrics.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyUSLT)field.getBody()).setLyric(songLyrics.trim());
        }
    }

    public void setAuthorComposer(String authorComposer) {
        AbstractID3v2Frame field = this.getFrame("TCOM");
        if (field == null) {
            field = new ID3v2_2Frame(new FrameBodyTCOM(0, authorComposer.trim()));
            this.setFrame(field);
        } else {
            ((FrameBodyTCOM)field.getBody()).setText(authorComposer.trim());
        }
    }
}

