/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class ID3v2_2Frame
extends AbstractID3v2Frame {
    public ID3v2_2Frame() {
    }

    public ID3v2_2Frame(AbstractID3v2FrameBody body) {
        super(body);
    }

    public ID3v2_2Frame(ID3v2_2Frame frame) {
        super(frame);
    }

    public ID3v2_2Frame(AbstractID3v2Frame frame) {
        if (frame.getBody() != null && TagUtility.isID3v2_2FrameIdentifier(frame.getIdentifier())) {
            this.setBody((AbstractID3v2FrameBody)TagUtility.copyObject(frame.getBody()));
        }
    }

    public ID3v2_2Frame(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public int getSize() {
        return this.getBody().getSize() + 3 + 3;
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        long filePointer;
        byte b;
        byte[] buffer = new byte[3];
        do {
            filePointer = file.getFilePointer();
            b = file.readByte();
            AbstractID3v2.incrementPaddingCounter();
        } while (b == 0);
        file.seek(filePointer);
        AbstractID3v2.decrementPaddingCounter();
        file.read(buffer, 0, 3);
        String identifier = new String(buffer, 0, 3);
        if (!ID3v2_2Frame.isValidID3v2FrameIdentifier(identifier)) {
            file.seek(file.getFilePointer() - 2L);
            throw new InvalidTagException(identifier + " is not a valid ID3v2.20 frame");
        }
        this.setBody(ID3v2_2Frame.readBody(identifier, file));
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[4];
        String str = TagUtility.truncate(this.getIdentifier(), 3);
        for (int i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, str.length());
        this.getBody().write(file);
    }
}

