/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class FieldBodyLYR
extends AbstractLyrics3v2FieldBody {
    private ArrayList lines = new ArrayList();

    public FieldBodyLYR() {
    }

    public FieldBodyLYR(FieldBodyLYR copyObject) {
        super(copyObject);
        for (int i = 0; i < copyObject.lines.size(); ++i) {
            ObjectLyrics3Line oldObject = (ObjectLyrics3Line)copyObject.lines.get(i);
            ObjectLyrics3Line newObject = new ObjectLyrics3Line(oldObject);
            this.lines.add(newObject);
        }
    }

    public FieldBodyLYR(String line) {
        this.readString(line);
    }

    public FieldBodyLYR(FrameBodySYLT sync) {
        this.addLyric(sync);
    }

    public FieldBodyLYR(FrameBodyUSLT unsync) {
        this.addLyric(unsync);
    }

    public FieldBodyLYR(RandomAccessFile file) throws InvalidTagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "LYR";
    }

    public void setLyric(String str) {
        this.readString(str);
    }

    public String getLyric() {
        return this.writeString();
    }

    public int getSize() {
        int size = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            ObjectLyrics3Line line = (ObjectLyrics3Line)this.lines.get(i);
            size += line.getSize() + 2;
        }
        return size;
    }

    public boolean isSubsetOf(Object object) {
        if (!(object instanceof FieldBodyLYR)) {
            return false;
        }
        ArrayList superset = ((FieldBodyLYR)object).lines;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (superset.contains(this.lines.get(i))) continue;
            return false;
        }
        return super.isSubsetOf(object);
    }

    public void addLyric(FrameBodySYLT sync) {
        Iterator iterator = sync.iterator();
        HashMap<String, ObjectLyrics3Line> lineMap = new HashMap<String, ObjectLyrics3Line>();
        while (iterator.hasNext()) {
            ObjectLyrics3Line newLine;
            ObjectID3v2LyricLine currentLine = (ObjectID3v2LyricLine)iterator.next();
            currentLine = new ObjectID3v2LyricLine(currentLine);
            ObjectLyrics3TimeStamp timeStamp = new ObjectLyrics3TimeStamp("Time Stamp");
            timeStamp.setTimeStamp(currentLine.getTimeStamp(), sync.getTimeStampFormat());
            if (lineMap.containsKey(currentLine.getText())) {
                newLine = (ObjectLyrics3Line)lineMap.get(currentLine.getText());
                newLine.addTimeStamp(timeStamp);
                continue;
            }
            newLine = new ObjectLyrics3Line("Lyric Line");
            newLine.setLyric(currentLine);
            newLine.setTimeStamp(timeStamp);
            lineMap.put(currentLine.getText(), newLine);
            this.lines.add(newLine);
        }
    }

    public void addLyric(FrameBodyUSLT unsync) {
        ObjectLyrics3Line line = new ObjectLyrics3Line("Lyric Line");
        line.setLyric(new String(unsync.getLyric()));
        this.lines.add(line);
        this.appendToObjectList(line);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldBodyLYR)) {
            return false;
        }
        FieldBodyLYR fieldBodyLYR = (FieldBodyLYR)obj;
        if (!this.lines.equals(fieldBodyLYR.lines)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasTimeStamp() {
        boolean present = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!((ObjectLyrics3Line)this.lines.get(i)).hasTimeStamp()) continue;
            present = true;
        }
        return present;
    }

    public Iterator iterator() {
        return this.lines.iterator();
    }

    protected void setupObjectList() {
    }

    public void read(RandomAccessFile file) throws InvalidTagException, IOException {
        byte[] buffer = new byte[5];
        file.read(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        buffer = new byte[size];
        file.read(buffer);
        String lineString = new String(buffer);
        this.readString(lineString);
    }

    public String toString() {
        String str = this.getIdentifier() + " : ";
        for (int i = 0; i < this.lines.size(); ++i) {
            str = str + this.lines.get(i).toString();
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[5];
        int size = this.getSize();
        String str = Integer.toString(size);
        for (i = 0; i < 5 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 5 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        file.write(buffer, 0, 5);
        if (size > 0) {
            str = this.writeString();
            buffer = new byte[str.length()];
            for (i = 0; i < str.length(); ++i) {
                buffer[i] = (byte)str.charAt(i);
            }
            file.write(buffer);
        }
    }

    private void readString(String lineString) {
        ObjectLyrics3Line line;
        String token;
        int offset = 0;
        int delim = lineString.indexOf(TagConstant.SEPERATOR_LINE);
        this.lines = new ArrayList();
        while (delim >= 0) {
            token = lineString.substring(offset, delim);
            line = new ObjectLyrics3Line("Lyric Line");
            line.setLyric(token);
            this.lines.add(line);
            this.appendToObjectList(line);
            offset = delim + TagConstant.SEPERATOR_LINE.length();
            delim = lineString.indexOf(TagConstant.SEPERATOR_LINE, offset);
        }
        if (offset < lineString.length()) {
            token = lineString.substring(offset);
            line = new ObjectLyrics3Line("Lyric Line");
            line.setLyric(token);
            this.lines.add(line);
            this.appendToObjectList(line);
        }
    }

    private String writeString() {
        String str = "";
        for (int i = 0; i < this.lines.size(); ++i) {
            ObjectLyrics3Line line = (ObjectLyrics3Line)this.lines.get(i);
            str = str + line.writeString() + TagConstant.SEPERATOR_LINE;
        }
        return str;
    }
}

