/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.lyrics3.FieldBodyAUT;
import org.farng.mp3.lyrics3.FieldBodyEAL;
import org.farng.mp3.lyrics3.FieldBodyEAR;
import org.farng.mp3.lyrics3.FieldBodyETT;
import org.farng.mp3.lyrics3.FieldBodyIND;
import org.farng.mp3.lyrics3.FieldBodyINF;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v1;
import org.farng.mp3.lyrics3.Lyrics3v2Field;

public class Lyrics3v2
extends AbstractLyrics3 {
    private Map fieldMap = new HashMap(8);

    public Lyrics3v2() {
    }

    public Lyrics3v2(Lyrics3v2 copyObject) {
        super(copyObject);
        Iterator iterator = copyObject.fieldMap.keySet().iterator();
        while (iterator.hasNext()) {
            String oldIdentifier;
            String newIdentifier = oldIdentifier = iterator.next().toString();
            Lyrics3v2Field newObject = new Lyrics3v2Field((Lyrics3v2Field)copyObject.fieldMap.get(newIdentifier));
            this.fieldMap.put(newIdentifier, newObject);
        }
    }

    public Lyrics3v2(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof Lyrics3v2) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            if (mp3tag instanceof Lyrics3v1) {
                Lyrics3v1 lyricOld = (Lyrics3v1)mp3tag;
                Lyrics3v2Field newField = new Lyrics3v2Field(new FieldBodyLYR(lyricOld.getLyric()));
                this.fieldMap.put(newField.getIdentifier(), newField);
            } else {
                Iterator iterator = new ID3v2_4(mp3tag).iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field newField = new Lyrics3v2Field((AbstractID3v2Frame)iterator.next());
                        this.fieldMap.put(newField.getIdentifier(), newField);
                    }
                    catch (TagException ex) {}
                }
            }
        }
    }

    public Lyrics3v2(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public void setField(Lyrics3v2Field field) {
        if (field.getBody() != null) {
            this.fieldMap.put(field.getIdentifier(), field);
        }
    }

    public Lyrics3v2Field getField(String identifier) {
        return (Lyrics3v2Field)this.fieldMap.get(identifier);
    }

    public int getFieldCount() {
        return this.fieldMap.size();
    }

    public String getIdentifier() {
        return "Lyrics3v2.00";
    }

    public int getSize() {
        int size = 0;
        for (Lyrics3v2Field field : this.fieldMap.values()) {
            size += field.getSize();
        }
        return 11 + size;
    }

    public void append(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        if (tag != null) {
            Lyrics3v2 newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            for (Lyrics3v2Field field : newTag.fieldMap.values()) {
                if (!oldTag.hasField(field.getIdentifier())) {
                    oldTag.setField(field);
                    continue;
                }
                AbstractLyrics3v2FieldBody body = (AbstractLyrics3v2FieldBody)oldTag.getField(field.getIdentifier()).getBody();
                boolean save = TagOptionSingleton.getInstance().getLyrics3SaveField(field.getIdentifier());
                if (body.getSize() != 0 || !save) continue;
                oldTag.setField(field);
            }
            for (String id : oldTag.fieldMap.keySet()) {
                TagOptionSingleton.getInstance().setLyrics3SaveField(id, true);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v2)) {
            return false;
        }
        Lyrics3v2 lyrics3v2 = (Lyrics3v2)obj;
        if (!((Object)this.fieldMap).equals(lyrics3v2.fieldMap)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean hasField(String identifier) {
        return this.fieldMap.containsKey(identifier);
    }

    public Iterator iterator() {
        return this.fieldMap.values().iterator();
    }

    public void overwrite(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        if (tag != null) {
            Lyrics3v2 newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            for (Lyrics3v2Field field : newTag.fieldMap.values()) {
                if (!TagOptionSingleton.getInstance().getLyrics3SaveField(field.getIdentifier())) continue;
                oldTag.setField(field);
            }
            for (String id : oldTag.fieldMap.keySet()) {
                TagOptionSingleton.getInstance().setLyrics3SaveField(id, true);
            }
        }
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        if (!this.seek(file)) {
            throw new TagNotFoundException("Lyrics3v2.00 Tag Not Found");
        }
        int lyricSize = this.seekSize(file);
        this.seek(file);
        long filePointer = file.getFilePointer();
        this.fieldMap = new HashMap();
        while (file.getFilePointer() - filePointer < (long)(lyricSize - 11)) {
            try {
                Lyrics3v2Field lyric = new Lyrics3v2Field(file);
                this.setField(lyric);
            }
            catch (InvalidTagException ex) {}
        }
    }

    public void removeField(String identifier) {
        this.fieldMap.remove(identifier);
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        long filePointer;
        byte[] buffer = new byte[11];
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        String lyricEnd = new String(buffer, 0, 9);
        if (lyricEnd.equals("LYRICS200")) {
            filePointer = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricEnd = new String(buffer, 0, 9);
            if (lyricEnd.equals("LYRICS200")) {
                filePointer = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(filePointer -= 15L);
        file.read(buffer, 0, 6);
        long lyricSize = Integer.parseInt(new String(buffer, 0, 6));
        file.seek(filePointer - lyricSize);
        file.read(buffer, 0, 11);
        String lyricStart = new String(buffer, 0, 11);
        return lyricStart.equals("LYRICSBEGIN");
    }

    public String toString() {
        Iterator iterator = this.fieldMap.values().iterator();
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        while (iterator.hasNext()) {
            Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
            str = str + field.toString() + "\n";
        }
        return str;
    }

    public void updateField(String identifier) {
        if (identifier.equals("IND")) {
            Lyrics3v2Field lyrField;
            boolean lyricsPresent = this.fieldMap.containsKey("LYR");
            boolean timeStampPresent = false;
            if (lyricsPresent) {
                lyrField = (Lyrics3v2Field)this.fieldMap.get("LYR");
                FieldBodyLYR lyrBody = (FieldBodyLYR)lyrField.getBody();
                timeStampPresent = lyrBody.hasTimeStamp();
            }
            lyrField = new Lyrics3v2Field(new FieldBodyIND(lyricsPresent, timeStampPresent));
            this.setField(lyrField);
        }
    }

    public void write(AbstractMP3Tag tag) {
        Lyrics3v2 oldTag = this;
        if (tag != null) {
            Lyrics3v2 newTag = tag instanceof Lyrics3v2 ? (Lyrics3v2)tag : new Lyrics3v2(tag);
            Iterator iterator = newTag.fieldMap.values().iterator();
            oldTag.fieldMap.clear();
            while (iterator.hasNext()) {
                Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                oldTag.setField(field);
            }
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[15];
        ID3v1 id3v1tag = new ID3v1();
        id3v1tag = id3v1tag.getID3tag(file);
        this.delete(file);
        file.seek(file.length());
        long filePointer = file.getFilePointer();
        String str = "LYRICSBEGIN";
        for (int i2 = 0; i2 < str.length(); ++i2) {
            buffer[i2] = (byte)str.charAt(i2);
        }
        file.write(buffer, 0, str.length());
        this.updateField("IND");
        Lyrics3v2Field field2 = (Lyrics3v2Field)this.fieldMap.get("IND");
        field2.write(file);
        for (Lyrics3v2Field field2 : this.fieldMap.values()) {
            String id = field2.getIdentifier();
            boolean save = TagOptionSingleton.getInstance().getLyrics3SaveField(id);
            if (id.equals("IND") || !save) continue;
            field2.write(file);
        }
        long size = file.getFilePointer() - filePointer;
        str = Long.toString(size);
        for (i = 0; i < 6 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 6 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        str = "LYRICS200";
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, offset += str.length());
        if (id3v1tag != null) {
            id3v1tag.write(file);
        }
    }

    private int seekSize(RandomAccessFile file) throws IOException {
        long filePointer;
        byte[] buffer = new byte[11];
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        String lyricEnd = new String(buffer, 0, 9);
        if (lyricEnd.equals("LYRICS200")) {
            filePointer = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricEnd = new String(buffer, 0, 9);
            if (lyricEnd.equals("LYRICS200")) {
                filePointer = file.getFilePointer();
            } else {
                return -1;
            }
        }
        file.seek(filePointer -= 15L);
        file.read(buffer, 0, 6);
        return Integer.parseInt(new String(buffer, 0, 6));
    }

    public String getSongTitle() {
        String title = "";
        Lyrics3v2Field field = this.getField("ETT");
        if (field != null) {
            FieldBodyETT body = (FieldBodyETT)field.getBody();
            title = body.getTitle();
        }
        return title.trim();
    }

    public String getLeadArtist() {
        String artist = "";
        Lyrics3v2Field field = this.getField("EAR");
        if (field != null) {
            FieldBodyEAR body = (FieldBodyEAR)field.getBody();
            artist = body.getArtist();
        }
        return artist.trim();
    }

    public String getAlbumTitle() {
        String album = "";
        Lyrics3v2Field field = this.getField("EAL");
        if (field != null) {
            FieldBodyEAL body = (FieldBodyEAL)field.getBody();
            album = body.getAlbum();
        }
        return album.trim();
    }

    public String getYearReleased() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongComment() {
        String additionalInformation = "";
        Lyrics3v2Field field = this.getField("INF");
        if (field != null) {
            FieldBodyINF body = (FieldBodyINF)field.getBody();
            additionalInformation = body.getAdditionalInformation();
        }
        return additionalInformation.trim();
    }

    public String getSongGenre() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getTrackNumberOnAlbum() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongLyric() {
        String lyrics = "";
        Lyrics3v2Field field = this.getField("LYR");
        if (field != null) {
            FieldBodyLYR body = (FieldBodyLYR)field.getBody();
            lyrics = body.getLyric();
        }
        return lyrics.trim().trim();
    }

    public String getAuthorComposer() {
        String author = "";
        Lyrics3v2Field field = this.getField("AUT");
        if (field != null) {
            FieldBodyAUT body = (FieldBodyAUT)field.getBody();
            author = body.getAuthor();
        }
        return author.trim();
    }

    public void setSongTitle(String songTitle) {
        Lyrics3v2Field field = this.getField("ETT");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyETT(songTitle.trim()));
            this.setField(field);
        } else {
            ((FieldBodyETT)field.getBody()).setTitle(songTitle.trim());
        }
    }

    public void setLeadArtist(String leadArtist) {
        Lyrics3v2Field field = this.getField("EAR");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyEAR(leadArtist.trim()));
            this.setField(field);
        } else {
            ((FieldBodyEAR)field.getBody()).setArtist(leadArtist.trim());
        }
    }

    public void setAlbumTitle(String albumTitle) {
        Lyrics3v2Field field = this.getField("EAL");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyEAL(albumTitle.trim()));
            this.setField(field);
        } else {
            ((FieldBodyEAL)field.getBody()).setAlbum(albumTitle.trim());
        }
    }

    public void setYearReleased(String yearReleased) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongComment(String songComment) {
        Lyrics3v2Field field = this.getField("INF");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyINF(songComment.trim()));
            this.setField(field);
        } else {
            ((FieldBodyINF)field.getBody()).setAdditionalInformation(songComment.trim());
        }
    }

    public void setSongGenre(String songGenre) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongLyric(String songLyrics) {
        Lyrics3v2Field field = this.getField("LYR");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyLYR(songLyrics.trim()));
            this.setField(field);
        } else {
            ((FieldBodyLYR)field.getBody()).setLyric(songLyrics.trim());
        }
    }

    public void setAuthorComposer(String authorComposer) {
        Lyrics3v2Field field = this.getField("AUT");
        if (field == null) {
            field = new Lyrics3v2Field(new FieldBodyAUT(authorComposer.trim()));
            this.setField(field);
        } else {
            ((FieldBodyAUT)field.getBody()).setAuthor(authorComposer.trim());
        }
    }
}

