/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.Arrays;

public abstract class AbstractMP3Object {
    protected Object value = null;
    protected String identifier = "";

    public AbstractMP3Object() {
        this.value = null;
        this.identifier = "";
    }

    public AbstractMP3Object(AbstractMP3Object copyObject) {
        this.identifier = new String(copyObject.identifier);
        if (copyObject.value == null) {
            this.value = null;
        } else if (copyObject.value instanceof String) {
            this.value = new String((String)copyObject.value);
        } else if (copyObject.value instanceof Boolean) {
            this.value = new Boolean((Boolean)copyObject.value);
        } else if (copyObject.value instanceof Byte) {
            this.value = new Byte((Byte)copyObject.value);
        } else if (copyObject.value instanceof Character) {
            this.value = new Character(((Character)copyObject.value).charValue());
        } else if (copyObject.value instanceof Double) {
            this.value = new Double((Double)copyObject.value);
        } else if (copyObject.value instanceof Float) {
            this.value = new Float(((Float)copyObject.value).floatValue());
        } else if (copyObject.value instanceof Integer) {
            this.value = new Integer((Integer)copyObject.value);
        } else if (copyObject.value instanceof Long) {
            this.value = new Long((Long)copyObject.value);
        } else if (copyObject.value instanceof Short) {
            this.value = new Short((Short)copyObject.value);
        } else if (copyObject.value instanceof boolean[]) {
            this.value = ((boolean[])copyObject.value).clone();
        } else if (copyObject.value instanceof byte[]) {
            this.value = ((byte[])copyObject.value).clone();
        } else if (copyObject.value instanceof char[]) {
            this.value = ((char[])copyObject.value).clone();
        } else if (copyObject.value instanceof double[]) {
            this.value = ((double[])copyObject.value).clone();
        } else if (copyObject.value instanceof float[]) {
            this.value = ((float[])copyObject.value).clone();
        } else if (copyObject.value instanceof int[]) {
            this.value = ((int[])copyObject.value).clone();
        } else if (copyObject.value instanceof long[]) {
            this.value = ((long[])copyObject.value).clone();
        } else if (copyObject.value instanceof short[]) {
            this.value = ((short[])copyObject.value).clone();
        } else if (copyObject.value instanceof Object[]) {
            this.value = ((Object[])copyObject.value).clone();
        } else {
            throw new UnsupportedOperationException("Unable to create copy of class " + copyObject.getClass());
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public final void readByteArray(byte[] arr) {
        this.readByteArray(arr, 0);
    }

    public final void readString(String str) {
        this.readString(str, 0);
    }

    public abstract int getSize();

    public void readByteArray(byte[] arr, int offset) {
        this.readString(new String(arr), offset);
    }

    public void readString(String str, int offset) {
        this.readByteArray(str.substring(offset).getBytes(), 0);
    }

    public abstract String toString();

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractMP3Object)) {
            return false;
        }
        AbstractMP3Object abstractMp3Object = (AbstractMP3Object)obj;
        if (!this.identifier.equals(abstractMp3Object.identifier)) {
            return false;
        }
        if (this.value == null && abstractMp3Object.value == null) {
            return true;
        }
        if (this.value == null || abstractMp3Object.value == null) {
            return false;
        }
        return !(this.value instanceof boolean[] && abstractMp3Object.value instanceof boolean[] ? !Arrays.equals((boolean[])this.value, (boolean[])abstractMp3Object.value) : (this.value instanceof byte[] && abstractMp3Object.value instanceof byte[] ? !Arrays.equals((byte[])this.value, (byte[])abstractMp3Object.value) : (this.value instanceof char[] && abstractMp3Object.value instanceof char[] ? !Arrays.equals((char[])this.value, (char[])abstractMp3Object.value) : (this.value instanceof double[] && abstractMp3Object.value instanceof double[] ? !Arrays.equals((double[])this.value, (double[])abstractMp3Object.value) : (this.value instanceof float[] && abstractMp3Object.value instanceof float[] ? !Arrays.equals((float[])this.value, (float[])abstractMp3Object.value) : (this.value instanceof int[] && abstractMp3Object.value instanceof int[] ? !Arrays.equals((int[])this.value, (int[])abstractMp3Object.value) : (this.value instanceof long[] && abstractMp3Object.value instanceof long[] ? !Arrays.equals((long[])this.value, (long[])abstractMp3Object.value) : (this.value instanceof Object[] && abstractMp3Object.value instanceof Object[] ? !Arrays.equals((Object[])this.value, (Object[])abstractMp3Object.value) : (this.value instanceof short[] && abstractMp3Object.value instanceof short[] ? !Arrays.equals((short[])this.value, (short[])abstractMp3Object.value) : !this.value.equals(abstractMp3Object.value))))))))));
    }

    public byte[] writeByteArray() {
        return this.writeString().getBytes();
    }

    public String writeString() {
        return new String(this.writeByteArray());
    }
}

