/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectLyrics3TimeStamp
extends AbstractMP3Object {
    private long minute = 0L;
    private long second = 0L;
    private byte timeStampFormat = 0;

    public ObjectLyrics3TimeStamp(String identifier) {
        this.identifier = identifier;
    }

    public ObjectLyrics3TimeStamp(ObjectLyrics3TimeStamp copyObject) {
        super(copyObject);
        this.minute = copyObject.minute;
        this.second = copyObject.second;
    }

    public void setMinute(long minute) {
        this.minute = minute;
    }

    public long getMinute() {
        return this.minute;
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setTimeStampFormat(byte timeStampFormat) {
        this.timeStampFormat = timeStampFormat;
    }

    public void setSecond(long second) {
        this.second = second;
    }

    public long getSecond() {
        return this.second;
    }

    public int getSize() {
        return 7;
    }

    public void setTimeStamp(long timeStamp, byte timeStampFormat) {
        this.minute = (timeStamp /= 1000L) / 60L;
        this.second = timeStamp % 60L;
        this.timeStampFormat = timeStampFormat;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectLyrics3TimeStamp)) {
            return false;
        }
        ObjectLyrics3TimeStamp objectLyrics3TimeStamp = (ObjectLyrics3TimeStamp)obj;
        if (this.minute != objectLyrics3TimeStamp.minute) {
            return false;
        }
        if (this.second != objectLyrics3TimeStamp.second) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String timeStamp, int offset) {
        if (timeStamp == null) {
            throw new NullPointerException("Image is null");
        }
        if (offset < 0 || offset >= timeStamp.length()) {
            throw new IndexOutOfBoundsException("Offset to timeStamp is out of bounds: offset = " + offset + ", timeStamp.length()" + timeStamp.length());
        }
        if ((timeStamp = timeStamp.substring(offset)).length() == 7) {
            this.minute = Integer.parseInt(timeStamp.substring(1, 3));
            this.second = Integer.parseInt(timeStamp.substring(4, 6));
        } else {
            this.minute = 0L;
            this.second = 0L;
        }
    }

    public String toString() {
        return this.writeString();
    }

    public String writeString() {
        String str = "[";
        if (this.minute < 0L) {
            str = str + "00";
        } else {
            if (this.minute < 10L) {
                str = str + '0';
            }
            str = str + Long.toString(this.minute);
        }
        str = str + ':';
        if (this.second < 0L) {
            str = str + "00";
        } else {
            if (this.second < 10L) {
                str = str + '0';
            }
            str = str + Long.toString(this.second);
        }
        str = str + ']';
        return str;
    }
}

