/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.farng.mp3.TagConstant;
import org.farng.mp3.object.ObjectHashMapInterface;
import org.farng.mp3.object.ObjectStringFixedLength;

public class ObjectStringHashMap
extends ObjectStringFixedLength
implements ObjectHashMapInterface {
    public static final String LANGUAGE = "Language";
    HashMap idToString = null;
    HashMap stringToId = null;
    boolean hasEmptyValue = false;

    public ObjectStringHashMap(String identifier, int size) {
        super(identifier, size);
        if (!identifier.equals(LANGUAGE)) {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
        this.stringToId = TagConstant.languageStringToId;
        this.idToString = TagConstant.languageIdToString;
    }

    public ObjectStringHashMap(ObjectStringHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.idToString = copyObject.idToString;
        this.stringToId = copyObject.stringToId;
    }

    public HashMap getIdToString() {
        return this.idToString;
    }

    public HashMap getStringToId() {
        return this.stringToId;
    }

    public void setValue(Object value) {
        this.value = value instanceof String ? ((String)value).toLowerCase() : value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectStringHashMap)) {
            return false;
        }
        ObjectStringHashMap objectStringHashMap = (ObjectStringHashMap)obj;
        if (this.hasEmptyValue != objectStringHashMap.hasEmptyValue) {
            return false;
        }
        if (this.idToString == null ? objectStringHashMap.idToString != null : !this.idToString.equals(objectStringHashMap.idToString)) {
            return false;
        }
        if (this.idToString == null ? objectStringHashMap.idToString != null : !this.stringToId.equals(objectStringHashMap.stringToId)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        if (this.idToString == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.idToString.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.idToString.get(this.value) == null) {
            return "";
        }
        return this.idToString.get(this.value).toString();
    }
}

