/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.junit.Assert;

public class AssertValidFolderParentVisitor
implements EntryTree.TreeVisitor {
    private CMISClient client;

    public AssertValidFolderParentVisitor(CMISClient client) {
        this.client = client;
    }

    public void visit(EntryTree entry) throws Exception {
        Link parentLink = this.client.getFolderParentLink(entry.entry);
        if (entry.parent == null) {
            Assert.assertNull((Object)parentLink);
            return;
        }
        if (entry.type.equals("cmis:folder")) {
            Assert.assertNotNull((Object)parentLink);
        }
        if (parentLink == null) {
            return;
        }
        Entry parent = this.client.getEntry(parentLink.getHref());
        Assert.assertEquals((Object)entry.parent.getId(), (Object)parent.getId());
    }
}

