/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.util.ArrayList;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Service;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.junit.Assert;

public class CMISTestFixture {
    private Long testStartTime = null;
    private CMISClient client;
    private String name;
    private Entry testCaseFolder = null;

    public CMISTestFixture(CMISClient client, String name) {
        this.client = client;
        this.name = name;
    }

    private long getStartTime() {
        if (this.testStartTime == null) {
            this.testStartTime = System.currentTimeMillis();
        }
        return this.testStartTime;
    }

    public Entry getTestCaseFolder() throws Exception {
        if (this.testCaseFolder == null) {
            Service service = this.client.getRepository();
            IRI rootFolderHREF = this.client.getRootCollection(this.client.getWorkspace(service));
            Assert.assertNotNull((Object)rootFolderHREF);
            String folderName = "CMISTCK " + this.getStartTime() + " - " + this.name;
            this.testCaseFolder = this.client.createFolder(rootFolderHREF, null, folderName);
        }
        return this.testCaseFolder;
    }

    public Entry createTestDocument(String name) throws Exception {
        return this.createTestDocument(name, null);
    }

    public Entry createTestDocument(String name, String template) throws Exception {
        return this.createTestDocument(name, template, true);
    }

    public Entry createTestDocument(String name, String template, boolean expectNoContent) throws Exception {
        Link children = this.client.getChildrenLink(this.getTestCaseFolder());
        return this.client.createDocument(children.getHref(), null, name, template, expectNoContent);
    }

    public Entry createTestFolder(String name) throws Exception {
        return this.createTestFolder(name, null);
    }

    public Entry createTestFolder(String name, String template) throws Exception {
        Link children = this.client.getChildrenLink(this.getTestCaseFolder());
        return this.client.createFolder(children.getHref(), null, name, template);
    }

    public EntryTree createTestTree(String name, int depth, int docCount, String folderTemplate, String docTemplate) throws Exception {
        if (depth <= 0) {
            return null;
        }
        Entry root = this.createTestFolder(name, folderTemplate);
        return this.createTree(this.getTestCaseFolder(), root, depth - 1, docCount, folderTemplate, docTemplate);
    }

    private EntryTree createTree(Entry parent, Entry entry, int depth, int docCount, String folderTemplate, String docTemplate) throws Exception {
        String name = entry.getTitle();
        EntryTree folderEntry = new EntryTree();
        folderEntry.parent = parent;
        folderEntry.entry = entry;
        folderEntry.type = "cmis:folder";
        folderEntry.children = new ArrayList<EntryTree>();
        Link childrenLink = this.client.getChildrenLink(entry);
        int docIdx = 0;
        while (docIdx < docCount) {
            EntryTree docEntry = new EntryTree();
            String docName = String.valueOf(name) + " doc " + docIdx;
            docEntry.parent = entry;
            String cmisType = null;
            String cmisContentPath = null;
            String content = null;
            if (docTemplate == null) {
                switch (docIdx % 3) {
                    case 1: {
                        cmisType = "image/jpeg";
                        cmisContentPath = "org/apache/chemistry/tck/atompub/images/image1.jpg";
                        break;
                    }
                    case 2: {
                        cmisType = "image/png";
                        cmisContentPath = "org/apache/chemistry/tck/atompub/images/image2.png";
                        break;
                    }
                    default: {
                        content = name;
                    }
                }
                docEntry.entry = this.client.createDocument(childrenLink.getHref(), null, docName, null, false, content, cmisType, cmisContentPath);
            } else {
                docEntry.entry = this.client.createDocument(childrenLink.getHref(), null, docName, docTemplate);
            }
            docEntry.type = "cmis:document";
            folderEntry.children.add(docEntry);
            ++docIdx;
        }
        if (depth > 0) {
            String folderName = String.valueOf(name) + " (child)";
            Entry subFolder = this.client.createFolder(childrenLink.getHref(), null, folderName, folderTemplate);
            folderEntry.children.add(this.createTree(entry, subFolder, depth - 1, docCount, folderTemplate, docTemplate));
        }
        return folderEntry;
    }

    public void delete() throws Exception {
        if (this.testCaseFolder != null) {
            Link descendants = this.client.getDescendantsLink(this.testCaseFolder);
            Assert.assertNotNull((Object)descendants);
            DeleteRequest delete = new DeleteRequest(descendants.getHref().toString());
            this.client.executeRequest(delete, -1);
        }
    }
}

