/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.chemistry.abdera.ext.CMISChildren;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISProperty;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;

public class CMISTree
extends EntryTree {
    public CMISTree(EntryTree parentEntryTree, Feed cmisTree) {
        this.parent = parentEntryTree.parent;
        this.entry = parentEntryTree.entry;
        this.type = parentEntryTree.type;
        this.children = new ArrayList();
        for (Entry child : cmisTree.getEntries()) {
            EntryTree childEntryTree = this.createEntryTree(this.entry, child);
            this.children.add(childEntryTree);
        }
    }

    public CMISTree(Entry parent, Entry entry, String type) {
        this.parent = parent;
        this.entry = entry;
        this.type = type;
        this.children = Collections.emptyList();
    }

    private EntryTree createEntryTree(Entry parent, Entry entry) {
        Feed childrenFeed;
        CMISChildren children;
        EntryTree entryTree = new EntryTree();
        entryTree.parent = parent;
        entryTree.entry = entry;
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        CMISProperty baseTypeId = object.getBaseTypeId();
        if (baseTypeId != null) {
            entryTree.type = baseTypeId.getStringValue();
        }
        if ((children = (CMISChildren)entry.getFirstChild(CMISConstants.CHILDREN)) != null && (childrenFeed = children.getFeed()) != null) {
            entryTree.children = new ArrayList<EntryTree>();
            for (Entry child : childrenFeed.getEntries()) {
                EntryTree childEntryTree = this.createEntryTree(entry, child);
                entryTree.children.add(childEntryTree);
            }
        }
        return entryTree;
    }
}

