/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.abdera.model.Entry;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;

public class UpdateTest
extends TCKTest {
    public void testUpdatePutCMISContent() throws Exception {
        String mimetype;
        Entry document = this.fixture.createTestDocument("testUpdatePutCMISContent");
        String string = mimetype = document.getContentMimeType() != null ? document.getContentMimeType().toString() : null;
        if (mimetype != null) {
            Assert.assertEquals((Object)"text/plain", (Object)mimetype);
        }
        String updateFile = this.templates.load("updatedocument.cmisatomentry.xml");
        updateFile = updateFile.replace("${ID}", document.getId().toString());
        String guid = String.valueOf(System.currentTimeMillis());
        updateFile = updateFile.replace("${NAME}", guid);
        updateFile = updateFile.replace("${CMISCONTENT}", new String(Base64.encodeBase64((byte[])("updated content " + guid).getBytes())));
        PutRequest putReq = new PutRequest(document.getSelfLink().getHref().toString(), updateFile, "application/atom+xml;type=entry");
        Response res = this.client.executeRequest(putReq, 200);
        Assert.assertNotNull((Object)res);
        Entry updated = this.model.parseEntry((Reader)new StringReader(res.getContentAsString()), null);
        Assert.assertEquals((Object)document.getId(), (Object)updated.getId());
        Assert.assertEquals((Object)document.getPublished(), (Object)updated.getPublished());
        Assert.assertEquals((Object)("Updated Title " + guid), (Object)updated.getTitle());
        Assert.assertEquals((Object)"text/plain", (Object)updated.getContentMimeType().toString());
        Response contentRes = this.client.executeRequest(new GetRequest(updated.getContentSrc().toString()), 200);
        Assert.assertEquals((Object)("updated content " + guid), (Object)contentRes.getContentAsString());
    }

    public void testUpdatePutAtomContent() throws Exception {
        String mimetype;
        Entry document = this.fixture.createTestDocument("testUpdatePutAtomContent");
        String string = mimetype = document.getContentMimeType() != null ? document.getContentMimeType().toString() : null;
        if (mimetype != null) {
            Assert.assertEquals((Object)"text/plain", (Object)mimetype);
        }
        String updateFile = this.templates.load("updatedocument.atomentry.xml");
        updateFile = updateFile.replace("${ID}", document.getId().toString());
        String guid = String.valueOf(System.currentTimeMillis());
        updateFile = updateFile.replace("${NAME}", guid);
        PutRequest putReq = new PutRequest(document.getSelfLink().getHref().toString(), updateFile, "application/atom+xml;type=entry");
        Response res = this.client.executeRequest(putReq, 200);
        Assert.assertNotNull((Object)res);
        Entry updated = this.model.parseEntry((Reader)new StringReader(res.getContentAsString()), null);
        Assert.assertEquals((Object)document.getId(), (Object)updated.getId());
        Assert.assertEquals((Object)document.getPublished(), (Object)updated.getPublished());
        Assert.assertEquals((Object)("Updated Title " + guid), (Object)updated.getTitle());
        Assert.assertTrue((boolean)updated.getContentMimeType().toString().startsWith("text/plain"));
        Response contentRes = this.client.executeRequest(new GetRequest(updated.getContentSrc().toString()), 200);
        Assert.assertEquals((Object)("updated content " + guid), (Object)contentRes.getContentAsString());
    }

    public void testUpdatePutAtomEntry() throws Exception {
        Entry document = this.fixture.createTestDocument("testUpdatePutAtomEntry");
        String updatedTitle = "I\u221a\u00b1t\u221a\u00b4rn\u221a\u00a2ti\u221a\u00a5n\u221a\u2020liz\u221a\u00b6ti\u221a\u220fn - 2";
        document.setTitle(updatedTitle);
        StringWriter writer = new StringWriter();
        document.writeTo((Writer)writer);
        PutRequest putReq = new PutRequest(document.getSelfLink().getHref().toString(), writer.toString(), "application/atom+xml;type=entry");
        Response res = this.client.executeRequest(putReq, 200);
        Assert.assertNotNull((Object)res);
        Entry updated = this.model.parseEntry((Reader)new StringReader(res.getContentAsString()), null);
        Assert.assertEquals((Object)updatedTitle, (Object)updated.getTitle());
    }
}

