/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PostRequest;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.http.Request;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class VersionsTest
extends TCKTest {
    public void tearDown() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        for (Entry pwc : checkedout.getEntries()) {
            this.client.executeRequest(new DeleteRequest(pwc.getSelfLink().getHref().toString()), 204);
        }
        super.tearDown();
    }

    public void testGetCheckedOut() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        Assert.assertNotNull((Object)scopeId);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        Assert.assertEquals((long)0L, (long)checkedout.getEntries().size());
    }

    public void testCheckout() throws Exception {
        Entry document = this.fixture.createTestDocument("testCheckout");
        CMISObject docObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        GetRequest documentReq = new GetRequest(document.getSelfLink().getHref().toString());
        Response documentRes = this.client.executeRequest(documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String documentXML = documentRes.getContentAsString();
        Assert.assertNotNull((Object)documentXML);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        PostRequest checkoutReq = new PostRequest(checkedoutHREF.toString(), documentXML, "application/atom+xml;type=entry");
        Response pwcRes = this.client.executeRequest(checkoutReq, 201);
        Assert.assertNotNull((Object)pwcRes);
        String pwcXml = pwcRes.getContentAsString();
        Assert.assertNotNull((Object)pwcXml);
        Entry pwc = this.model.parseEntry((Reader)new StringReader(pwcXml), null);
        Assert.assertNotNull((Object)pwc);
        CMISObject pwcObject = (CMISObject)pwc.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)pwcObject);
        Assert.assertTrue((boolean)pwcObject.isVersionSeriesCheckedOut().getBooleanValue());
        Assert.assertEquals((Object)docObject.getVersionSeriesId().getStringValue(), (Object)pwcObject.getVersionSeriesId().getStringValue());
        Assert.assertEquals((Object)docObject.getVersionSeriesId().getStringValue(), (Object)pwcObject.getVersionSeriesId().getStringValue());
        Assert.assertEquals((Object)pwcObject.getObjectId().getStringValue(), (Object)pwcObject.getVersionSeriesCheckedOutId().getStringValue());
        Assert.assertNotNull((Object)pwcObject.getVersionSeriesCheckedOutBy().getStringValue());
        Response pwcGetRes = this.client.executeRequest(new GetRequest(pwc.getSelfLink().getHref().toString()), 200);
        Assert.assertNotNull((Object)pwcGetRes);
        String pwcGetXml = pwcRes.getContentAsString();
        Entry pwcGet = this.model.parseEntry((Reader)new StringReader(pwcGetXml), null);
        Assert.assertNotNull((Object)pwcGet);
        CMISObject pwcGetObject = (CMISObject)pwc.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)pwcGetObject);
        Assert.assertTrue((boolean)pwcGetObject.isVersionSeriesCheckedOut().getBooleanValue());
        Assert.assertEquals((Object)docObject.getVersionSeriesId().getStringValue(), (Object)pwcGetObject.getVersionSeriesId().getStringValue());
        Assert.assertEquals((Object)pwcGetObject.getObjectId().getStringValue(), (Object)pwcGetObject.getVersionSeriesCheckedOutId().getStringValue());
        Assert.assertNotNull((Object)pwcGetObject.getVersionSeriesCheckedOutBy().getStringValue());
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        Assert.assertEquals((long)1L, (long)checkedout.getEntries().size());
    }

    public void testCancelCheckout() throws Exception {
        Entry document = this.fixture.createTestDocument("testCancelCheckout");
        GetRequest documentReq = new GetRequest(document.getSelfLink().getHref().toString());
        Response documentRes = this.client.executeRequest(documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String xml = documentRes.getContentAsString();
        Assert.assertNotNull((Object)xml);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        PostRequest checkoutReq = new PostRequest(checkedoutHREF.toString(), xml, "application/atom+xml;type=entry");
        Response pwcRes = this.client.executeRequest(checkoutReq, 201);
        Assert.assertNotNull((Object)pwcRes);
        String pwcXml = pwcRes.getContentAsString();
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        Assert.assertEquals((long)1L, (long)checkedout.getEntries().size());
        Entry pwc = this.model.parseEntry((Reader)new StringReader(pwcXml), null);
        Assert.assertNotNull((Object)pwc);
        Response cancelRes = this.client.executeRequest(new DeleteRequest(pwc.getSelfLink().getHref().toString()), 204);
        Assert.assertNotNull((Object)cancelRes);
        Feed checkedout2 = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout2);
        Assert.assertEquals((long)0L, (long)checkedout2.getEntries().size());
    }

    public void testCheckIn() throws Exception {
        Entry document = this.fixture.createTestDocument("testCheckin");
        GetRequest documentReq = new GetRequest(document.getSelfLink().getHref().toString());
        Response documentRes = this.client.executeRequest(documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String xml = documentRes.getContentAsString();
        Assert.assertNotNull((Object)xml);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        PostRequest checkoutReq = new PostRequest(checkedoutHREF.toString(), xml, "application/atom+xml;type=entry");
        Response pwcRes = this.client.executeRequest(checkoutReq, 201);
        Assert.assertNotNull((Object)pwcRes);
        Entry pwc = this.model.parseEntry((Reader)new StringReader(pwcRes.getContentAsString()), null);
        Assert.assertNotNull((Object)pwc);
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        Assert.assertEquals((long)1L, (long)checkedout.getEntries().size());
        Entry checkedoutdoc = this.client.getEntry(document.getSelfLink().getHref());
        CMISObject checkedoutdocObject = (CMISObject)checkedoutdoc.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)checkedoutdocObject);
        Assert.assertTrue((boolean)checkedoutdocObject.isVersionSeriesCheckedOut().getBooleanValue());
        Assert.assertNotNull((Object)checkedoutdocObject.getVersionSeriesCheckedOutId().getStringValue());
        Assert.assertNotNull((Object)checkedoutdocObject.getVersionSeriesCheckedOutBy().getStringValue());
        String updateFile = this.templates.load("updatedocument.atomentry.xml");
        updateFile = updateFile.replace("${ID}", document.getId().toString());
        String guid = String.valueOf(System.currentTimeMillis());
        updateFile = updateFile.replace("${NAME}", guid);
        PutRequest updateReq = new PutRequest(pwc.getEditLink().getHref().toString(), updateFile, "application/atom+xml;type=entry");
        Response pwcUpdatedres = this.client.executeRequest(updateReq, 200);
        Assert.assertNotNull((Object)pwcUpdatedres);
        Entry updated = this.model.parseEntry((Reader)new StringReader(pwcUpdatedres.getContentAsString()), null);
        Assert.assertEquals((Object)pwc.getId(), (Object)updated.getId());
        Assert.assertEquals((Object)pwc.getPublished(), (Object)updated.getPublished());
        Assert.assertEquals((Object)("Updated Title " + guid), (Object)updated.getTitle());
        Assert.assertEquals((Object)"text/plain", (Object)updated.getContentMimeType().toString());
        Response pwcContentRes = this.client.executeRequest(new GetRequest(pwc.getContentSrc().toString()), 200);
        Assert.assertEquals((Object)("updated content " + guid), (Object)pwcContentRes.getContentAsString());
        String checkinFile = this.templates.load("checkindocument.atomentry.xml");
        String checkinUrl = pwc.getSelfLink().getHref().toString();
        HashMap<String, String> args2 = new HashMap<String, String>();
        args2.put("checkinComment", guid);
        args2.put("checkin", "true");
        Request checkinReq = new PutRequest(checkinUrl, checkinFile, "application/atom+xml;type=entry").setArgs(args2);
        Response checkinRes = this.client.executeRequest(checkinReq, 200);
        Assert.assertNotNull((Object)checkinRes);
        String checkinResXML = checkinRes.getContentAsString();
        Feed checkedout2 = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout2);
        Assert.assertEquals((long)0L, (long)checkedout2.getEntries().size());
        Entry checkedIn = this.model.parseEntry((Reader)new StringReader(checkinResXML), null);
        Entry updatedDoc = this.client.getEntry(checkedIn.getSelfLink().getHref());
        Assert.assertEquals((Object)("Updated Title " + guid), (Object)updatedDoc.getTitle());
        Assert.assertEquals((Object)"text/plain", (Object)updatedDoc.getContentMimeType().toString());
        Response updatedContentRes = this.client.executeRequest(new GetRequest(updatedDoc.getContentSrc().toString()), 200);
        Assert.assertEquals((Object)("updated content " + guid), (Object)updatedContentRes.getContentAsString());
        CMISObject updatedObject = (CMISObject)updatedDoc.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)updatedObject);
        Assert.assertFalse((boolean)updatedObject.isVersionSeriesCheckedOut().getBooleanValue());
        Assert.assertNull((Object)updatedObject.getVersionSeriesCheckedOutId().getStringValue());
        Assert.assertNull((Object)updatedObject.getVersionSeriesCheckedOutBy().getStringValue());
        updatedDoc = this.client.getEntry(updatedDoc.getSelfLink().getHref(), Collections.singletonMap("returnVersion", "latestmajor"));
        updatedObject = (CMISObject)updatedDoc.getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)guid, (Object)updatedObject.getCheckinComment().getStringValue());
    }

    public void testUpdateOnCheckIn() throws Exception {
        Entry document = this.fixture.createTestDocument("testUpdateOnCheckIn");
        GetRequest documentReq = new GetRequest(document.getSelfLink().getHref().toString());
        Response documentRes = this.client.executeRequest(documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String xml = documentRes.getContentAsString();
        Assert.assertNotNull((Object)xml);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        PostRequest checkoutReq = new PostRequest(checkedoutHREF.toString(), xml, "application/atom+xml;type=entry");
        Response pwcRes = this.client.executeRequest(checkoutReq, 201);
        Assert.assertNotNull((Object)pwcRes);
        Entry pwc = this.model.parseEntry((Reader)new StringReader(pwcRes.getContentAsString()), null);
        Assert.assertNotNull((Object)pwc);
        Entry testFolder = this.fixture.getTestCaseFolder();
        CMISObject object = (CMISObject)testFolder.getExtension(CMISConstants.OBJECT);
        String scopeId = object.getObjectId().getStringValue();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("folderId", scopeId);
        Feed checkedout = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout);
        Assert.assertEquals((long)1L, (long)checkedout.getEntries().size());
        String checkinFile = this.templates.load("checkinandupdatedocument.atomentry.xml");
        String guid = String.valueOf(System.currentTimeMillis());
        checkinFile = checkinFile.replace("${NAME}", guid);
        String checkinUrl = pwc.getSelfLink().getHref().toString();
        HashMap<String, String> args2 = new HashMap<String, String>();
        args2.put("checkinComment", guid);
        args2.put("checkin", "true");
        Request checkinReq = new PutRequest(checkinUrl, checkinFile, "application/atom+xml;type=entry").setArgs(args2);
        Response checkinRes = this.client.executeRequest(checkinReq, 200);
        Assert.assertNotNull((Object)checkinRes);
        String checkinResXML = checkinRes.getContentAsString();
        Feed checkedout2 = this.client.getFeed(new IRI(checkedoutHREF.toString()), args);
        Assert.assertNotNull((Object)checkedout2);
        Assert.assertEquals((long)0L, (long)checkedout2.getEntries().size());
        Entry checkedIn = this.model.parseEntry((Reader)new StringReader(checkinResXML), null);
        Entry updatedDoc = this.client.getEntry(checkedIn.getSelfLink().getHref());
        Assert.assertEquals((Object)"text/plain", (Object)updatedDoc.getContentMimeType().toString());
        Response updatedContentRes = this.client.executeRequest(new GetRequest(updatedDoc.getContentSrc().toString()), 200);
        Assert.assertEquals((Object)("updated content " + guid), (Object)updatedContentRes.getContentAsString());
    }

    public void testGetAllVersions() throws Exception {
        int NUMBER_OF_VERSIONS = 3;
        Entry document = this.fixture.createTestDocument("testGetAllVersions");
        GetRequest documentReq = new GetRequest(document.getSelfLink().getHref().toString());
        Response documentRes = this.client.executeRequest(documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String xml = documentRes.getContentAsString();
        Assert.assertNotNull((Object)xml);
        Link allVersionsLink = document.getLink("version-history");
        Assert.assertNotNull((Object)allVersionsLink);
        Feed allVersions = this.client.getFeed(allVersionsLink.getHref());
        Assert.assertNotNull((Object)allVersions);
        int initialVersions = allVersions.getEntries().size();
        Assert.assertTrue((initialVersions > 0 ? 1 : 0) != 0);
        IRI checkedoutHREF = this.client.getCheckedOutCollection(this.client.getWorkspace());
        int i = 0;
        while (i < NUMBER_OF_VERSIONS) {
            PostRequest checkoutReq = new PostRequest(checkedoutHREF.toString(), xml, "application/atom+xml;type=entry");
            Response pwcRes = this.client.executeRequest(checkoutReq, 201);
            Assert.assertNotNull((Object)pwcRes);
            Entry pwc = this.model.parseEntry((Reader)new StringReader(pwcRes.getContentAsString()), null);
            Assert.assertNotNull((Object)pwc);
            String checkinFile = this.templates.load("checkinandupdatedocument.atomentry.xml");
            checkinFile = checkinFile.replace("${NAME}", "checkin " + i);
            String checkinUrl = pwc.getSelfLink().getHref().toString();
            HashMap<String, String> args2 = new HashMap<String, String>();
            args2.put("checkinComment", "checkin" + i);
            args2.put("checkin", "true");
            Request checkinReq = new PutRequest(checkinUrl, checkinFile, "application/atom+xml;type=entry").setArgs(args2);
            Response checkinRes = this.client.executeRequest(checkinReq, 200);
            Assert.assertNotNull((Object)checkinRes);
            xml = checkinRes.getContentAsString();
            Assert.assertNotNull((Object)xml);
            ++i;
        }
        allVersions = this.client.getFeed(allVersionsLink.getHref());
        Assert.assertNotNull((Object)allVersions);
        Assert.assertEquals((long)(NUMBER_OF_VERSIONS + initialVersions), (long)allVersions.getEntries().size());
        boolean pastLatestMajor = false;
        int versionIndex = NUMBER_OF_VERSIONS - 1;
        int i2 = 0;
        while (i2 < allVersions.getEntries().size()) {
            Link versionLink = ((Entry)allVersions.getEntries().get(i2)).getSelfLink();
            Assert.assertNotNull((Object)versionLink);
            Entry version = this.client.getEntry(versionLink.getHref());
            Assert.assertNotNull((Object)version);
            CMISObject versionObject = (CMISObject)version.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)versionObject);
            if (pastLatestMajor) {
                Assert.assertFalse((String)"More than one latest major version!", (boolean)versionObject.isLatestMajorVersion().getBooleanValue());
            } else {
                pastLatestMajor = versionObject.isLatestMajorVersion().getBooleanValue();
            }
            if (versionIndex >= 0) {
                Response versionContentRes = this.client.executeRequest(new GetRequest(version.getContentSrc().toString()), 200);
                if (pastLatestMajor) {
                    Assert.assertEquals((Object)("updated content checkin " + versionIndex), (Object)versionContentRes.getContentAsString());
                    Assert.assertEquals((Object)("checkin" + versionIndex), (Object)versionObject.getCheckinComment().getStringValue());
                    --versionIndex;
                }
            }
            ++i2;
        }
        Assert.assertTrue((String)"No latest major version found", (boolean)pastLatestMajor);
        Assert.assertEquals((String)"Not all versions found", (long)-1L, (long)versionIndex);
    }
}

