/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.cache;

import info.bliki.wiki.cache.AbstractWikiStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class WikiStringBuilder
extends AbstractWikiStringBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = 4383685877147921099L;

    public WikiStringBuilder() {
    }

    public WikiStringBuilder(int capacity) {
        super(capacity);
    }

    public WikiStringBuilder(CharSequence seq) {
        super(seq.toString());
    }

    public WikiStringBuilder(String str) {
        super(str);
    }

    public WikiStringBuilder append(boolean b) {
        this.append0(b ? "true" : "false");
        return this;
    }

    public WikiStringBuilder append(char c) {
        this.append0(c);
        return this;
    }

    public WikiStringBuilder append(int i) {
        this.append0(Integer.toString(i));
        return this;
    }

    public WikiStringBuilder append(long lng) {
        this.append0(Long.toString(lng));
        return this;
    }

    public WikiStringBuilder append(float f) {
        this.append0(Float.toString(f));
        return this;
    }

    public WikiStringBuilder append(double d) {
        this.append0(Double.toString(d));
        return this;
    }

    public WikiStringBuilder append(Object obj) {
        if (obj == null) {
            this.appendNull();
        } else {
            this.append0(obj.toString());
        }
        return this;
    }

    public WikiStringBuilder append(String str) {
        this.append0(str);
        return this;
    }

    public WikiStringBuilder append(StringBuffer sb) {
        if (sb == null) {
            this.appendNull();
        } else {
            this.append0(sb.toString(), 0, sb.length());
        }
        return this;
    }

    public WikiStringBuilder append(char[] ch) {
        this.append0(ch);
        return this;
    }

    public WikiStringBuilder append(char[] str, int offset, int len) {
        this.append0(str, offset, len);
        return this;
    }

    public WikiStringBuilder append(CharSequence csq) {
        if (csq == null) {
            this.appendNull();
        } else {
            this.append0(csq.toString());
        }
        return this;
    }

    public WikiStringBuilder append(CharSequence csq, int start, int end) {
        this.append0(csq, start, end);
        return this;
    }

    public WikiStringBuilder appendCodePoint(int codePoint) {
        this.append0(Character.toChars(codePoint));
        return this;
    }

    public WikiStringBuilder delete(int start, int end) {
        this.delete0(start, end);
        return this;
    }

    public WikiStringBuilder deleteCharAt(int index) {
        this.deleteCharAt0(index);
        return this;
    }

    public WikiStringBuilder insert(int offset, boolean b) {
        this.insert0(offset, b ? "true" : "false");
        return this;
    }

    public WikiStringBuilder insert(int offset, char c) {
        this.insert0(offset, c);
        return this;
    }

    public WikiStringBuilder insert(int offset, int i) {
        this.insert0(offset, Integer.toString(i));
        return this;
    }

    public WikiStringBuilder insert(int offset, long l) {
        this.insert0(offset, Long.toString(l));
        return this;
    }

    public WikiStringBuilder insert(int offset, float f) {
        this.insert0(offset, Float.toString(f));
        return this;
    }

    public WikiStringBuilder insert(int offset, double d) {
        this.insert0(offset, Double.toString(d));
        return this;
    }

    public WikiStringBuilder insert(int offset, Object obj) {
        this.insert0(offset, obj == null ? "null" : obj.toString());
        return this;
    }

    public WikiStringBuilder insert(int offset, String str) {
        this.insert0(offset, str);
        return this;
    }

    public WikiStringBuilder insert(int offset, char[] ch) {
        this.insert0(offset, ch);
        return this;
    }

    public WikiStringBuilder insert(int offset, char[] str, int strOffset, int strLen) {
        this.insert0(offset, str, strOffset, strLen);
        return this;
    }

    public WikiStringBuilder insert(int offset, CharSequence s) {
        this.insert0(offset, s == null ? "null" : s.toString());
        return this;
    }

    public WikiStringBuilder insert(int offset, CharSequence s, int start, int end) {
        this.insert0(offset, s, start, end);
        return this;
    }

    public WikiStringBuilder replace(int start, int end, String str) {
        this.replace0(start, end, str);
        return this;
    }

    public WikiStringBuilder reverse() {
        this.reverse0();
        return this;
    }

    public String toString() {
        return super.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int count = in.readInt();
        char[] value = (char[])in.readObject();
        this.set(value, count);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this.getValue());
    }
}

