/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRelationshipReference;
import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractRepositoryReference;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.WebScriptException;

public class AssociationIdRelationshipReference
implements CMISRelationshipReference {
    private CMISServices cmisServices;
    private String assocId;

    public AssociationIdRelationshipReference(CMISServices cmisServices, String assocId) {
        this.cmisServices = cmisServices;
        this.assocId = assocId;
    }

    public AssociationRef getAssocRef() {
        try {
            return (AssociationRef)this.cmisServices.getReadableObject("assoc:" + this.assocId, AssociationRef.class);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public CMISRepositoryReference getRepositoryReference() {
        return new AbstractRepositoryReference(this.cmisServices){

            public StoreRef getStoreRef() {
                return AssociationIdRelationshipReference.this.getAssocRef().getSourceRef().getStoreRef();
            }
        };
    }

    public String toString() {
        return "AssociationIdRelationshipReference[assocId=" + this.assocId + "]";
    }
}

