/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractObjectReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class NodeIdReference
extends AbstractObjectReference {
    private String id;
    private String[] reference;

    public NodeIdReference(CMISServices cmisServices, CMISRepositoryReference repo, String id) {
        super(cmisServices, repo);
        this.id = id;
        StoreRef storeRef = repo.getStoreRef();
        String[] idParts = this.id.split("/");
        this.reference = new String[2 + idParts.length];
        this.reference[0] = storeRef.getProtocol();
        this.reference[1] = storeRef.getIdentifier();
        System.arraycopy(idParts, 0, this.reference, 2, idParts.length);
    }

    public NodeRef getNodeRef() {
        return this.cmisServices.getNode("node", this.reference);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "NodeIdReference[storeRef=" + this.repo.getStoreRef() + ",id=" + this.id + "]";
    }
}

