/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractObjectReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class ObjectPathReference
extends AbstractObjectReference {
    protected String path;
    protected String[] reference;

    public ObjectPathReference(CMISServices cmisServices, CMISRepositoryReference repo, String path) {
        super(cmisServices, repo);
        this.path = cmisServices.getDefaultRootPath() + path;
        String[] splitPath = this.path.split("/");
        String[] pathSegments = new String[splitPath.length - 1];
        System.arraycopy(splitPath, 1, pathSegments, 0, splitPath.length - 1);
        this.reference = new String[2 + pathSegments.length];
        StoreRef storeRef = repo.getStoreRef();
        this.reference[0] = storeRef.getProtocol();
        this.reference[1] = storeRef.getIdentifier();
        System.arraycopy(pathSegments, 0, this.reference, 2, pathSegments.length);
    }

    public NodeRef getNodeRef() {
        return this.cmisServices.getNode("path", this.reference);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "ObjectPathReference[storeRef=" + this.repo.getStoreRef() + ",path=" + this.path + "]";
    }
}

