/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.template.TemplateAssociation;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateValueConverter;
import org.springframework.extensions.webscripts.WebScriptException;

public class CMISPropertyValueMethod
implements TemplateMethodModelEx {
    public static TemplateModel IS_NULL = new BeanModel((Object)new NULL(), BeansWrapper.getDefaultInstance());
    private CMISServices cmisService;
    private TemplateImageResolver imageResolver;
    private TemplateValueConverter templateValueConverter;

    public CMISPropertyValueMethod(CMISServices cmisService, RepositoryImageResolver imageResolver, TemplateValueConverter templateValueConverter) {
        this.cmisService = cmisService;
        this.imageResolver = imageResolver.getImageResolver();
        this.templateValueConverter = templateValueConverter;
    }

    public Object exec(List args) throws TemplateModelException {
        Object wrapped = null;
        String propertyName = null;
        boolean asObject = false;
        try {
            int i = 0;
            Object arg = args.get(i++);
            if (arg instanceof BeanModel) {
                wrapped = ((BeanModel)arg).getWrappedObject();
            }
            if ((arg = args.get(i++)) instanceof TemplateScalarModel) {
                propertyName = ((TemplateScalarModel)arg).getAsString();
            }
            if ((arg = args.get(i++)) instanceof TemplateBooleanModel) {
                asObject = ((TemplateBooleanModel)arg).getAsBoolean();
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Object result = null;
            if (wrapped != null && wrapped instanceof TemplateNode) {
                result = this.cmisService.getProperty(((TemplateNode)wrapped).getNodeRef(), null, propertyName);
            } else if (wrapped != null && wrapped instanceof TemplateAssociation) {
                result = this.cmisService.getProperty(((TemplateAssociation)wrapped).getAssociationRef(), propertyName);
            }
            if (asObject && result instanceof String) {
                result = this.cmisService.getReadableObject((String)result, Object.class);
            }
            return result == null ? IS_NULL : this.templateValueConverter.convertValue(result, this.imageResolver);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public static class NULL {
    }
}

